/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class SegmentRoutingAppConfig
extends Config<ApplicationId> {
    private static final String VROUTER_MACS = "vRouterMacs";
    private static final String SUPPRESS_SUBNET = "suppressSubnet";
    private static final String SUPPRESS_HOST_BY_PORT = "suppressHostByPort";
    private static final String SUPPRESS_HOST_BY_PROVIDER = "suppressHostByProvider";
    private static final String MPLS_ECMP = "MPLS-ECMP";

    public boolean isValid() {
        return this.hasOnlyFields(new String[]{VROUTER_MACS, SUPPRESS_SUBNET, SUPPRESS_HOST_BY_PORT, SUPPRESS_HOST_BY_PROVIDER, MPLS_ECMP}) && this.vRouterMacs() != null && this.suppressSubnet() != null && this.suppressHostByPort() != null && this.suppressHostByProvider() != null;
    }

    public boolean mplsEcmp() {
        return this.get(MPLS_ECMP, false);
    }

    public SegmentRoutingAppConfig setMplsEcmp(boolean mplsEcmp) {
        this.object.put(MPLS_ECMP, mplsEcmp);
        return this;
    }

    public Set<MacAddress> vRouterMacs() {
        if (!this.object.has(VROUTER_MACS)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayNode arrayNode = (ArrayNode)this.object.path(VROUTER_MACS);
        for (JsonNode jsonNode : arrayNode) {
            MacAddress mac;
            String macStr = jsonNode.asText(null);
            if (macStr == null) {
                return null;
            }
            try {
                mac = MacAddress.valueOf((String)macStr);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            builder.add((Object)mac);
        }
        return builder.build();
    }

    public SegmentRoutingAppConfig setVRouterMacs(Set<MacAddress> vRouterMacs) {
        if (vRouterMacs == null) {
            this.object.remove(VROUTER_MACS);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            vRouterMacs.forEach(mac -> arrayNode.add(mac.toString()));
            this.object.set(VROUTER_MACS, (JsonNode)arrayNode);
        }
        return this;
    }

    public Set<ConnectPoint> suppressSubnet() {
        if (!this.object.has(SUPPRESS_SUBNET)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayNode arrayNode = (ArrayNode)this.object.path(SUPPRESS_SUBNET);
        for (JsonNode jsonNode : arrayNode) {
            String portName = jsonNode.asText(null);
            if (portName == null) {
                return null;
            }
            try {
                builder.add((Object)ConnectPoint.deviceConnectPoint((String)portName));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return builder.build();
    }

    public SegmentRoutingAppConfig setSuppressSubnet(Set<ConnectPoint> suppressSubnet) {
        if (suppressSubnet == null) {
            this.object.remove(SUPPRESS_SUBNET);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            suppressSubnet.forEach(connectPoint -> arrayNode.add(connectPoint.deviceId() + "/" + connectPoint.port()));
            this.object.set(SUPPRESS_SUBNET, (JsonNode)arrayNode);
        }
        return this;
    }

    public Set<ConnectPoint> suppressHostByPort() {
        if (!this.object.has(SUPPRESS_HOST_BY_PORT)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayNode arrayNode = (ArrayNode)this.object.path(SUPPRESS_HOST_BY_PORT);
        for (JsonNode jsonNode : arrayNode) {
            String portName = jsonNode.asText(null);
            if (portName == null) {
                return null;
            }
            try {
                builder.add((Object)ConnectPoint.deviceConnectPoint((String)portName));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return builder.build();
    }

    public SegmentRoutingAppConfig setSuppressHostByPort(Set<ConnectPoint> connectPoints) {
        if (connectPoints == null) {
            this.object.remove(SUPPRESS_HOST_BY_PORT);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            connectPoints.forEach(connectPoint -> arrayNode.add(connectPoint.deviceId() + "/" + connectPoint.port()));
            this.object.set(SUPPRESS_HOST_BY_PORT, (JsonNode)arrayNode);
        }
        return this;
    }

    public Set<String> suppressHostByProvider() {
        if (!this.object.has(SUPPRESS_HOST_BY_PROVIDER)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayNode arrayNode = (ArrayNode)this.object.path(SUPPRESS_HOST_BY_PROVIDER);
        for (JsonNode jsonNode : arrayNode) {
            String providerName = jsonNode.asText(null);
            if (providerName == null) {
                return null;
            }
            builder.add((Object)providerName);
        }
        return builder.build();
    }

    public SegmentRoutingAppConfig setSuppressHostByProvider(Set<String> providers) {
        if (providers == null) {
            this.object.remove(SUPPRESS_HOST_BY_PROVIDER);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            providers.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            this.object.set(SUPPRESS_HOST_BY_PROVIDER, (JsonNode)arrayNode);
        }
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add(VROUTER_MACS, this.vRouterMacs()).add(SUPPRESS_SUBNET, this.suppressSubnet()).add(SUPPRESS_HOST_BY_PORT, this.suppressHostByPort()).add(SUPPRESS_HOST_BY_PROVIDER, this.suppressHostByProvider()).add("mplsEcmp", this.mplsEcmp()).toString();
    }
}

