/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;
import org.onosproject.segmentrouting.pwaas.DefaultL2Tunnel;
import org.onosproject.segmentrouting.pwaas.DefaultL2TunnelDescription;
import org.onosproject.segmentrouting.pwaas.DefaultL2TunnelPolicy;
import org.onosproject.segmentrouting.pwaas.L2Mode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwaasConfig
extends Config<ApplicationId> {
    private static Logger log = LoggerFactory.getLogger(PwaasConfig.class);
    private static final String SRC_CP = "cP1";
    private static final String DST_CP = "cP2";
    private static final String SRC_OUTER_TAG = "cP1OuterTag";
    private static final String DST_OUTER_TAG = "cP2OuterTag";
    private static final String SRC_INNER_TAG = "cP1InnerTag";
    private static final String DST_INNER_TAG = "cP2InnerTag";
    private static final String MODE = "mode";
    private static final String ALL_VLAN = "allVlan";
    private static final String SD_TAG = "sdTag";
    private static final String PW_LABEL = "pwLabel";
    private static final String MISSING_PARAMS = "Missing parameters in pseudo wire description";
    private static final String INVALID_L2_MODE = "Invalid pseudo wire mode";

    public boolean isValid() {
        try {
            this.getPwIds().forEach(this::getPwDescription);
        }
        catch (IllegalArgumentException e) {
            log.warn("{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public Set<Long> getPwIds() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.object.fields().forEachRemaining(entry -> {
            Long tunnelId = Long.parseLong((String)entry.getKey());
            builder.add((Object)tunnelId);
        });
        return builder.build();
    }

    public DefaultL2TunnelDescription getPwDescription(Long tunnelId) {
        JsonNode pwDescription = this.object.get(tunnelId.toString());
        if (!this.hasFields((ObjectNode)pwDescription, new String[]{SRC_CP, SRC_INNER_TAG, SRC_OUTER_TAG, DST_CP, DST_INNER_TAG, DST_OUTER_TAG, MODE, ALL_VLAN, SD_TAG, PW_LABEL})) {
            throw new IllegalArgumentException(MISSING_PARAMS);
        }
        String tempString = pwDescription.get(SRC_CP).asText();
        ConnectPoint srcCp = ConnectPoint.deviceConnectPoint((String)tempString);
        tempString = pwDescription.get(DST_CP).asText();
        ConnectPoint dstCp = ConnectPoint.deviceConnectPoint((String)tempString);
        tempString = pwDescription.get(SRC_INNER_TAG).asText();
        VlanId srcInnerTag = VlanId.vlanId((String)tempString);
        tempString = pwDescription.get(SRC_OUTER_TAG).asText();
        VlanId srcOuterTag = VlanId.vlanId((String)tempString);
        tempString = pwDescription.get(DST_INNER_TAG).asText();
        VlanId dstInnerTag = VlanId.vlanId((String)tempString);
        tempString = pwDescription.get(DST_OUTER_TAG).asText();
        VlanId dstOuterTag = VlanId.vlanId((String)tempString);
        tempString = pwDescription.get(MODE).asText();
        L2Mode l2Mode = L2Mode.valueOf(tempString);
        boolean allVlan = pwDescription.get(ALL_VLAN).asBoolean();
        tempString = pwDescription.get(SD_TAG).asText();
        VlanId sdTag = VlanId.vlanId((String)tempString);
        tempString = pwDescription.get(PW_LABEL).asText();
        MplsLabel pwLabel = MplsLabel.mplsLabel((String)tempString);
        DefaultL2Tunnel l2Tunnel = new DefaultL2Tunnel(l2Mode, sdTag, tunnelId, pwLabel);
        DefaultL2TunnelPolicy l2TunnelPolicy = new DefaultL2TunnelPolicy(tunnelId, srcCp, srcInnerTag, srcOuterTag, dstCp, dstInnerTag, dstOuterTag, allVlan);
        return new DefaultL2TunnelDescription(l2Tunnel, l2TunnelPolicy);
    }
}

