/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.incubator.net.config.basics.InterfaceConfig;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceProperties;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.onosproject.segmentrouting.config.SegmentRoutingDeviceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceConfiguration
implements DeviceProperties {
    private static final String NO_SUBNET = "No subnet configured on {}";
    private static final Logger log = LoggerFactory.getLogger(DeviceConfiguration.class);
    private final List<Integer> allSegmentIds = new ArrayList<Integer>();
    private final Map<DeviceId, SegmentRouterInfo> deviceConfigMap = new ConcurrentHashMap<DeviceId, SegmentRouterInfo>();
    private SegmentRoutingManager srManager;

    public DeviceConfiguration(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        Set deviceSubjects = srManager.cfgService.getSubjects(DeviceId.class, SegmentRoutingDeviceConfig.class);
        deviceSubjects.forEach(subject -> {
            SegmentRoutingDeviceConfig config = (SegmentRoutingDeviceConfig)srManager.cfgService.getConfig(subject, SegmentRoutingDeviceConfig.class);
            SegmentRouterInfo info = new SegmentRouterInfo();
            info.deviceId = subject;
            info.ipv4NodeSid = config.nodeSidIPv4();
            info.ipv6NodeSid = config.nodeSidIPv6();
            info.ipv4Loopback = config.routerIpv4();
            info.ipv6Loopback = config.routerIpv6();
            info.mac = config.routerMac();
            info.isEdge = config.isEdgeRouter();
            info.adjacencySids = config.adjacencySids();
            this.deviceConfigMap.put(info.deviceId, info);
            log.debug("Read device config for device: {}", (Object)info.deviceId);
            this.allSegmentIds.add(info.ipv4NodeSid);
        });
        Set portSubjects = srManager.cfgService.getSubjects(ConnectPoint.class, InterfaceConfig.class);
        portSubjects.stream().filter(subject -> !this.isSuppressedPort((ConnectPoint)subject)).forEach(subject -> {
            Set networkInterfaces;
            InterfaceConfig config = (InterfaceConfig)srManager.cfgService.getConfig(subject, InterfaceConfig.class);
            try {
                networkInterfaces = config.getInterfaces();
            }
            catch (ConfigException e) {
                log.error("Error loading port configuration");
                return;
            }
            networkInterfaces.forEach(networkInterface -> {
                VlanId vlanId = networkInterface.vlan();
                ConnectPoint connectPoint = networkInterface.connectPoint();
                DeviceId dpid = connectPoint.deviceId();
                PortNumber port = connectPoint.port();
                SegmentRouterInfo info = this.deviceConfigMap.get(dpid);
                if (info != null) {
                    List interfaceAddresses = networkInterface.ipAddressesList();
                    interfaceAddresses.forEach(interfaceAddress -> {
                        int prefixLength = interfaceAddress.subnetAddress().prefixLength();
                        IpPrefix ipPrefix = interfaceAddress.subnetAddress();
                        if (ipPrefix.isIp4()) {
                            if (prefixLength != 0 && prefixLength != 32) {
                                info.gatewayIps.put((Object)port, (Object)interfaceAddress.ipAddress());
                            }
                            info.subnets.put((Object)port, (Object)interfaceAddress.subnetAddress());
                        } else {
                            if (prefixLength != 0 && prefixLength != 128) {
                                info.gatewayIps.put((Object)port, (Object)interfaceAddress.ipAddress());
                            }
                            info.subnets.put((Object)port, (Object)interfaceAddress.subnetAddress());
                        }
                    });
                }
            });
            srManager.registerConnectPoint((ConnectPoint)subject);
        });
    }

    @Override
    public boolean isConfigured(DeviceId deviceId) {
        return this.deviceConfigMap.get(deviceId) != null;
    }

    @Override
    public int getIPv4SegmentId(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getIPv4SegmentId for device{} is {}", (Object)deviceId, (Object)srinfo.ipv4NodeSid);
            return srinfo.ipv4NodeSid;
        }
        String message = "getIPv4SegmentId fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    @Override
    public int getIPv6SegmentId(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getIPv6SegmentId for device{} is {}", (Object)deviceId, (Object)srinfo.ipv6NodeSid);
            return srinfo.ipv6NodeSid;
        }
        String message = "getIPv6SegmentId fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    public int getIPv4SegmentId(MacAddress routerMac) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().mac.equals((Object)routerMac)) continue;
            return entry.getValue().ipv4NodeSid;
        }
        return -1;
    }

    public int getIPv6SegmentId(MacAddress routerMac) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().mac.equals((Object)routerMac)) continue;
            return entry.getValue().ipv6NodeSid;
        }
        return -1;
    }

    public int getIPv4SegmentId(Ip4Address routerAddress) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().ipv4Loopback.equals((Object)routerAddress)) continue;
            return entry.getValue().ipv4NodeSid;
        }
        return -1;
    }

    public int getIPv6SegmentId(Ip6Address routerAddress) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().ipv6Loopback.equals((Object)routerAddress)) continue;
            return entry.getValue().ipv6NodeSid;
        }
        return -1;
    }

    @Override
    public MacAddress getDeviceMac(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getDeviceMac for device{} is {}", (Object)deviceId, (Object)srinfo.mac);
            return srinfo.mac;
        }
        String message = "getDeviceMac fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    public Ip4Address getRouterIpv4(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getRouterIpv4 for device{} is {}", (Object)deviceId, (Object)srinfo.ipv4Loopback);
            return srinfo.ipv4Loopback;
        }
        String message = "getRouterIpv4 fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    public Ip6Address getRouterIpv6(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getRouterIpv6 for device{} is {}", (Object)deviceId, (Object)srinfo.ipv6Loopback);
            return srinfo.ipv6Loopback;
        }
        String message = "getRouterIpv6 fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    @Override
    public boolean isEdgeDevice(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("isEdgeDevice for device{} is {}", (Object)deviceId, (Object)srinfo.isEdge);
            return srinfo.isEdge;
        }
        String message = "isEdgeDevice fails for device: " + deviceId + ".";
        throw new DeviceConfigNotFoundException(message);
    }

    @Override
    public List<Integer> getAllDeviceSegmentIds() {
        return this.allSegmentIds;
    }

    @Override
    public Map<IpPrefix, List<PortNumber>> getSubnetPortsMap(DeviceId deviceId) throws DeviceConfigNotFoundException {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo == null) {
            String message = "getSubnetPortsMap fails for device: " + deviceId + ".";
            throw new DeviceConfigNotFoundException(message);
        }
        SetMultimap<PortNumber, IpPrefix> portSubnetMap = srinfo.subnets;
        HashMap<IpPrefix, List<PortNumber>> subnetPortMap = new HashMap<IpPrefix, List<PortNumber>>();
        portSubnetMap.entries().forEach(entry -> {
            PortNumber port = (PortNumber)entry.getKey();
            IpPrefix subnet = (IpPrefix)entry.getValue();
            if (subnet.prefixLength() == 32 || subnet.prefixLength() == 128) {
                return;
            }
            if (subnetPortMap.containsKey(subnet)) {
                ((List)subnetPortMap.get(subnet)).add(port);
            } else {
                ArrayList<PortNumber> ports = new ArrayList<PortNumber>();
                ports.add(port);
                subnetPortMap.put(subnet, ports);
            }
        });
        return subnetPortMap;
    }

    public DeviceId getDeviceId(int sid) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (entry.getValue().ipv4NodeSid != sid && entry.getValue().ipv6NodeSid != sid) continue;
            return entry.getValue().deviceId;
        }
        return null;
    }

    public DeviceId getDeviceId(Ip4Address ipAddress) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().ipv4Loopback.equals((Object)ipAddress)) continue;
            return entry.getValue().deviceId;
        }
        return null;
    }

    public DeviceId getDeviceId(Ip6Address ipAddress) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().ipv6Loopback.equals((Object)ipAddress)) continue;
            return entry.getValue().deviceId;
        }
        return null;
    }

    public Set<IpAddress> getPortIPs(DeviceId deviceId) {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            log.trace("getSubnetGatewayIps for device{} is {}", (Object)deviceId, (Object)srinfo.gatewayIps.values());
            return ImmutableSet.copyOf((Collection)srinfo.gatewayIps.values());
        }
        return null;
    }

    public Set<IpPrefix> getSubnets(DeviceId deviceId) {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        if (srinfo != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            return builder.addAll((Iterable)srinfo.subnets.values()).build();
        }
        return null;
    }

    public Set<IpPrefix> getPortSubnets(DeviceId deviceId, PortNumber port) {
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, port);
        if (this.isSuppressedPort(connectPoint)) {
            return Collections.emptySet();
        }
        Set<IpPrefix> subnets = this.srManager.interfaceService.getInterfacesByPort(connectPoint).stream().flatMap(intf -> intf.ipAddressesList().stream()).map(InterfaceIpAddress::subnetAddress).collect(Collectors.toSet());
        if (subnets.isEmpty()) {
            log.debug(NO_SUBNET, (Object)connectPoint);
            return Collections.emptySet();
        }
        return subnets;
    }

    public Ip4Address getRouterIpAddressForASubnetHost(Ip4Address destIpAddress) {
        Interface matchIntf = this.srManager.interfaceService.getMatchingInterface((IpAddress)destIpAddress);
        if (matchIntf == null) {
            log.debug("No router was found for {}", (Object)destIpAddress);
            return null;
        }
        DeviceId routerDeviceId = matchIntf.connectPoint().deviceId();
        SegmentRouterInfo srInfo = this.deviceConfigMap.get(routerDeviceId);
        if (srInfo == null) {
            log.debug("No device config was found for {}", (Object)routerDeviceId);
            return null;
        }
        return srInfo.ipv4Loopback;
    }

    public Ip6Address getRouterIpAddressForASubnetHost(Ip6Address destIpAddress) {
        Interface matchIntf = this.srManager.interfaceService.getMatchingInterface((IpAddress)destIpAddress);
        if (matchIntf == null) {
            log.debug("No router was found for {}", (Object)destIpAddress);
            return null;
        }
        DeviceId routerDeviceId = matchIntf.connectPoint().deviceId();
        SegmentRouterInfo srInfo = this.deviceConfigMap.get(routerDeviceId);
        if (srInfo == null) {
            log.debug("No device config was found for {}", (Object)routerDeviceId);
            return null;
        }
        return srInfo.ipv6Loopback;
    }

    public MacAddress getRouterMacForAGatewayIp(IpAddress gatewayIpAddress) {
        for (Map.Entry<DeviceId, SegmentRouterInfo> entry : this.deviceConfigMap.entrySet()) {
            if (!entry.getValue().gatewayIps.values().contains(gatewayIpAddress)) continue;
            return entry.getValue().mac;
        }
        log.debug("Cannot find a router for {}", (Object)gatewayIpAddress);
        return null;
    }

    public boolean inSameSubnet(DeviceId deviceId, IpAddress hostIp) {
        Set<IpPrefix> subnets = this.getSubnets(deviceId);
        if (subnets == null) {
            return false;
        }
        for (IpPrefix subnet : subnets) {
            if (subnet.prefixLength() == 0 || !subnet.contains(hostIp)) continue;
            return true;
        }
        return false;
    }

    public boolean inSameSubnet(ConnectPoint connectPoint, IpAddress ip) {
        return this.getPortSubnets(connectPoint.deviceId(), connectPoint.port()).stream().anyMatch(ipPrefix -> ipPrefix.contains(ip));
    }

    public Set<Integer> getPortsForAdjacencySid(DeviceId deviceId, int sid) {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        return srinfo != null ? ImmutableSet.copyOf((Collection)srinfo.adjacencySids.get(sid)) : ImmutableSet.copyOf(new HashSet());
    }

    public boolean isAdjacencySid(DeviceId deviceId, int sid) {
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(deviceId);
        return srinfo != null && srinfo.adjacencySids.containsKey(sid);
    }

    public void addSubnet(ConnectPoint cp, IpPrefix ipPrefix) {
        Preconditions.checkNotNull((Object)cp);
        Preconditions.checkNotNull((Object)ipPrefix);
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(cp.deviceId());
        if (srinfo == null) {
            log.warn("Device {} is not configured. Abort.", (Object)cp.deviceId());
            return;
        }
        srinfo.subnets.put((Object)cp.port(), (Object)ipPrefix);
    }

    public void removeSubnet(ConnectPoint cp, IpPrefix ipPrefix) {
        Preconditions.checkNotNull((Object)cp);
        Preconditions.checkNotNull((Object)ipPrefix);
        SegmentRouterInfo srinfo = this.deviceConfigMap.get(cp.deviceId());
        if (srinfo == null) {
            log.warn("Device {} is not configured. Abort.", (Object)cp.deviceId());
            return;
        }
        srinfo.subnets.remove((Object)cp.port(), (Object)ipPrefix);
    }

    private boolean isSuppressedPort(ConnectPoint connectPoint) {
        SegmentRoutingAppConfig appConfig = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId(), SegmentRoutingAppConfig.class);
        if (appConfig != null && appConfig.suppressSubnet().contains(connectPoint)) {
            log.info("Interface configuration on port {} is ignored", (Object)connectPoint);
            return true;
        }
        return false;
    }

    private class SegmentRouterInfo {
        int ipv4NodeSid;
        int ipv6NodeSid;
        DeviceId deviceId;
        Ip4Address ipv4Loopback;
        Ip6Address ipv6Loopback;
        MacAddress mac;
        boolean isEdge;
        SetMultimap<PortNumber, IpAddress> gatewayIps = HashMultimap.create();
        SetMultimap<PortNumber, IpPrefix> subnets = HashMultimap.create();
        Map<Integer, Set<Integer>> adjacencySids;
    }
}

