/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import com.google.common.collect.Lists;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.TunnelHandler;

@Command(scope="onos", name="sr-tunnel-remove", description="Remove a tunnel")
public class TunnelRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="tunnel ID", description="tunnel ID", required=true, multiValued=false)
    String tunnelId;

    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        DefaultTunnel tunnel = new DefaultTunnel(this.tunnelId, Lists.newArrayList());
        TunnelHandler.Result result = srService.removeTunnel(tunnel);
        switch (result) {
            case TUNNEL_IN_USE: {
                this.print("ERROR: the tunnel is still in use", new Object[0]);
                break;
            }
            case TUNNEL_NOT_FOUND: {
                this.print("ERROR: the tunnel is not found", new Object[0]);
                break;
            }
        }
    }
}

