/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.Tunnel;

@Command(scope="onos", name="sr-tunnel-list", description="Lists all tunnels")
public class TunnelListCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING = "  id=%s, path=%s";

    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        srService.getTunnels().forEach(tunnel -> this.printTunnel((Tunnel)tunnel));
    }

    private void printTunnel(Tunnel tunnel) {
        this.print(FORMAT_MAPPING, new Object[]{tunnel.id(), tunnel.labelIds()});
    }
}

