/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.TunnelHandler;

@Command(scope="onos", name="sr-tunnel-add", description="Create a new tunnel")
public class TunnelAddCommand
extends AbstractShellCommand {
    @Argument(index=0, name="tunnel ID", description="tunnel ID", required=true, multiValued=false)
    String tunnelId;
    @Argument(index=1, name="label path", description="label path", required=true, multiValued=false)
    String labels;

    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        ArrayList<Integer> labelIds = new ArrayList<Integer>();
        StringTokenizer strToken = new StringTokenizer(this.labels, ",");
        while (strToken.hasMoreTokens()) {
            labelIds.add(Integer.valueOf(strToken.nextToken()));
        }
        DefaultTunnel tunnel = new DefaultTunnel(this.tunnelId, labelIds);
        TunnelHandler.Result result = srService.createTunnel(tunnel);
        switch (result) {
            case ID_EXISTS: {
                this.print("ERROR: the same tunnel ID exists", new Object[0]);
                break;
            }
            case TUNNEL_EXISTS: {
                this.print("ERROR: the same tunnel exists", new Object[0]);
                break;
            }
            case INTERNAL_ERROR: {
                this.print("ERROR: internal tunnel creation error", new Object[0]);
                break;
            }
            case WRONG_PATH: {
                this.print("ERROR: the tunnel path is wrong", new Object[0]);
                break;
            }
        }
    }
}

