/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.TunnelPolicy;

@Command(scope="onos", name="sr-policy-list", description="Lists all policies")
public class PolicyListCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING_TUNNEL = "  id=%s, type=%s,  prio=%d, src=%s, port=%d, dst=%s, port=%d, proto=%s, tunnel=%s";

    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        srService.getPolicies().forEach(policy -> this.printPolicy((Policy)policy));
    }

    private void printPolicy(Policy policy) {
        if (policy.type() == Policy.Type.TUNNEL_FLOW) {
            this.print(FORMAT_MAPPING_TUNNEL, new Object[]{policy.id(), policy.type(), policy.priority(), policy.srcIp(), policy.srcPort(), policy.dstIp(), policy.dstPort(), policy.ipProto() == null ? "" : policy.ipProto(), ((TunnelPolicy)policy).tunnelId()});
        }
    }
}

