/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.PolicyHandler;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.TunnelPolicy;

@Command(scope="onos", name="sr-policy-add", description="Create a new policy")
public class PolicyAddCommand
extends AbstractShellCommand {
    @Argument(index=0, name="ID", description="policy ID", required=true, multiValued=false)
    String policyId;
    @Argument(index=1, name="priority", description="priority", required=true, multiValued=false)
    int priority;
    @Argument(index=2, name="src_IP", description="src IP", required=false, multiValued=false)
    String srcIp;
    @Argument(index=3, name="src_port", description="src port", required=false, multiValued=false)
    short srcPort;
    @Argument(index=4, name="dst_IP", description="dst IP", required=false, multiValued=false)
    String dstIp;
    @Argument(index=5, name="dst_port", description="dst port", required=false, multiValued=false)
    short dstPort;
    @Argument(index=6, name="proto", description="IP protocol", required=false, multiValued=false)
    String proto;
    @Argument(index=7, name="policy_type", description="policy type", required=true, multiValued=false)
    String policyType;
    @Argument(index=8, name="tunnel_ID", description="tunnel ID", required=false, multiValued=false)
    String tunnelId;

    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        TunnelPolicy.Builder tpb = TunnelPolicy.builder().setPolicyId(this.policyId);
        tpb.setPriority(this.priority);
        tpb.setType(Policy.Type.valueOf(this.policyType));
        if (this.srcIp != null) {
            tpb.setSrcIp(this.srcIp);
        }
        if (this.dstIp != null) {
            tpb.setDstIp(this.dstIp);
        }
        if (this.srcPort != 0) {
            tpb.setSrcPort(this.srcPort);
        }
        if (this.dstPort != 0) {
            tpb.setDstPort(this.dstPort);
        }
        if (!"ip".equals(this.proto)) {
            tpb.setIpProto(this.proto);
        }
        if (Policy.Type.valueOf(this.policyType) == Policy.Type.TUNNEL_FLOW) {
            if (this.tunnelId == null) {
                this.error("tunnel ID must be specified for TUNNEL_FLOW policy", new Object[0]);
                return;
            }
            tpb.setTunnelId(this.tunnelId);
        }
        PolicyHandler.Result result = srService.createPolicy(tpb.build());
        switch (result) {
            case POLICY_EXISTS: {
                this.error("the same policy exists", new Object[0]);
                break;
            }
            case ID_EXISTS: {
                this.error("the same policy ID exists", new Object[0]);
                break;
            }
            case TUNNEL_NOT_FOUND: {
                this.error("the tunnel is not found", new Object[0]);
                break;
            }
            case UNSUPPORTED_TYPE: {
                this.error("the policy type specified is not supported", new Object[0]);
                break;
            }
        }
    }
}

