/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting.cli;

import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpPrefix;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.segmentrouting.SegmentRoutingService;

@Command(scope="onos", name="sr-device-subnets", description="List device-subnet mapping in Segment Routing")
public class DeviceSubnetListCommand
extends AbstractShellCommand {
    protected void execute() {
        SegmentRoutingService srService = (SegmentRoutingService)AbstractShellCommand.get(SegmentRoutingService.class);
        this.printDeviceSubnetMap(srService.getDeviceSubnetMap());
    }

    private void printDeviceSubnetMap(Map<DeviceId, Set<IpPrefix>> deviceSubnetMap) {
        deviceSubnetMap.forEach((deviceId, ipPrefices) -> {
            this.print("%s", new Object[]{deviceId});
            ipPrefices.forEach(ipPrefix -> this.print("    %s", new Object[]{ipPrefix}));
        });
    }
}

