/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.XConnectConfig;
import org.onosproject.segmentrouting.storekey.XConnectStoreKey;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XConnectHandler {
    private static final Logger log = LoggerFactory.getLogger(XConnectHandler.class);
    private static final String CONFIG_NOT_FOUND = "XConnect config not found";
    private static final String NOT_MASTER = "Not master controller";
    private final SegmentRoutingManager srManager;
    private final StorageService storageService;
    private final ConsistentMap<XConnectStoreKey, NextObjective> xConnectNextObjStore;
    private final KryoNamespace.Builder xConnectKryo;

    protected XConnectHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.storageService = srManager.storageService;
        this.xConnectKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{XConnectStoreKey.class}).register(new Class[]{NextObjContext.class});
        this.xConnectNextObjStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-xconnect-nextobj-store")).withSerializer(Serializer.using((KryoNamespace)this.xConnectKryo.build()))).build();
    }

    public void init(DeviceId deviceId) {
        XConnectConfig config = (XConnectConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, XConnectConfig.class);
        if (config == null) {
            log.info("Skip XConnect initialization: {}", (Object)CONFIG_NOT_FOUND);
            return;
        }
        config.getXconnects(deviceId).forEach(key -> this.populateXConnect((XConnectStoreKey)key, config.getPorts((XConnectStoreKey)key)));
    }

    protected void processXConnectConfigAdded(NetworkConfigEvent event) {
        log.info("Processing XConnect CONFIG_ADDED");
        XConnectConfig config = (XConnectConfig)((Object)event.config().get());
        config.getXconnects().forEach(key -> this.populateXConnect((XConnectStoreKey)key, config.getPorts((XConnectStoreKey)key)));
    }

    protected void processXConnectConfigUpdated(NetworkConfigEvent event) {
        log.info("Processing XConnect CONFIG_UPDATED");
        XConnectConfig prevConfig = (XConnectConfig)((Object)event.prevConfig().get());
        XConnectConfig config = (XConnectConfig)((Object)event.config().get());
        Set<XConnectStoreKey> prevKeys = prevConfig.getXconnects();
        Set<XConnectStoreKey> keys = config.getXconnects();
        Set<XConnectStoreKey> pendingRemove = prevKeys.stream().filter(key -> !keys.contains(key)).collect(Collectors.toSet());
        Set<XConnectStoreKey> pendingAdd = keys.stream().filter(key -> !prevKeys.contains(key)).collect(Collectors.toSet());
        Set<XConnectStoreKey> pendingUpdate = keys.stream().filter(key -> prevKeys.contains(key) && !config.getPorts((XConnectStoreKey)key).equals(prevConfig.getPorts((XConnectStoreKey)key))).collect(Collectors.toSet());
        pendingRemove.forEach(key -> this.revokeXConnect((XConnectStoreKey)key, prevConfig.getPorts((XConnectStoreKey)key)));
        pendingAdd.forEach(key -> this.populateXConnect((XConnectStoreKey)key, config.getPorts((XConnectStoreKey)key)));
        pendingUpdate.forEach(key -> this.updateXConnect((XConnectStoreKey)key, prevConfig.getPorts((XConnectStoreKey)key), config.getPorts((XConnectStoreKey)key)));
    }

    protected void processXConnectConfigRemoved(NetworkConfigEvent event) {
        log.info("Processing XConnect CONFIG_REMOVED");
        XConnectConfig prevConfig = (XConnectConfig)((Object)event.prevConfig().get());
        prevConfig.getXconnects().forEach(key -> this.revokeXConnect((XConnectStoreKey)key, prevConfig.getPorts((XConnectStoreKey)key)));
    }

    public boolean hasXConnect(ConnectPoint cp) {
        XConnectConfig config = (XConnectConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, XConnectConfig.class);
        if (config == null) {
            log.warn("Failed to read XConnect config: {}", (Object)CONFIG_NOT_FOUND);
            return false;
        }
        return config.getXconnects(cp.deviceId()).stream().anyMatch(key -> config.getPorts((XConnectStoreKey)key).contains(cp.port()));
    }

    private void populateXConnect(XConnectStoreKey key, Set<PortNumber> ports) {
        if (!this.srManager.mastershipService.isLocalMaster(key.deviceId())) {
            log.info("Abort populating XConnect {}: {}", (Object)key, (Object)NOT_MASTER);
            return;
        }
        this.populateFilter(key, ports);
        this.populateFwd(key, this.populateNext(key, ports));
    }

    private void populateFilter(XConnectStoreKey key, Set<PortNumber> ports) {
        ports.forEach(port -> {
            FilteringObjective.Builder filtObjBuilder = this.filterObjBuilder(key, (PortNumber)port);
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("XConnect FilterObj for {} on port {} populated", (Object)key, port), (objective, error) -> log.warn("Failed to populate XConnect FilterObj for {} on port {}: {}", new Object[]{key, port, error}));
            this.srManager.flowObjectiveService.filter(key.deviceId(), filtObjBuilder.add((ObjectiveContext)context));
        });
    }

    private NextObjective populateNext(XConnectStoreKey key, Set<PortNumber> ports) {
        NextObjective nextObj = null;
        if (this.xConnectNextObjStore.containsKey((Object)key)) {
            nextObj = (NextObjective)this.xConnectNextObjStore.get((Object)key).value();
            log.debug("NextObj for {} found, id={}", (Object)key, (Object)nextObj.id());
        } else {
            NextObjective.Builder nextObjBuilder = this.nextObjBuilder(key, ports);
            NextObjContext nextContext = new NextObjContext(Objective.Operation.ADD, key);
            nextObj = nextObjBuilder.add((ObjectiveContext)nextContext);
            this.srManager.flowObjectiveService.next(key.deviceId(), nextObj);
            this.xConnectNextObjStore.put((Object)key, (Object)nextObj);
            log.debug("NextObj for {} not found. Creating new NextObj with id={}", (Object)key, (Object)nextObj.id());
        }
        return nextObj;
    }

    private void populateFwd(XConnectStoreKey key, NextObjective nextObj) {
        ForwardingObjective.Builder fwdObjBuilder = this.fwdObjBuilder(key, nextObj.id());
        DefaultObjectiveContext fwdContext = new DefaultObjectiveContext(objective -> log.debug("XConnect FwdObj for {} populated", (Object)key), (objective, error) -> log.warn("Failed to populate XConnect FwdObj for {}: {}", (Object)key, error));
        this.srManager.flowObjectiveService.forward(key.deviceId(), fwdObjBuilder.add((ObjectiveContext)fwdContext));
    }

    private void revokeXConnect(XConnectStoreKey key, Set<PortNumber> ports) {
        if (!this.srManager.mastershipService.isLocalMaster(key.deviceId())) {
            log.info("Abort populating XConnect {}: {}", (Object)key, (Object)NOT_MASTER);
            return;
        }
        this.revokeFilter(key, ports);
        if (this.xConnectNextObjStore.containsKey((Object)key)) {
            NextObjective nextObj = (NextObjective)this.xConnectNextObjStore.get((Object)key).value();
            this.revokeFwd(key, nextObj, null);
            this.revokeNext(key, nextObj, null);
        } else {
            log.warn("NextObj for {} does not exist in the store.", (Object)key);
        }
    }

    private void revokeFilter(XConnectStoreKey key, Set<PortNumber> ports) {
        ports.forEach(port -> {
            FilteringObjective.Builder filtObjBuilder = this.filterObjBuilder(key, (PortNumber)port);
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("XConnect FilterObj for {} on port {} revoked", (Object)key, port), (objective, error) -> log.warn("Failed to revoke XConnect FilterObj for {} on port {}: {}", new Object[]{key, port, error}));
            this.srManager.flowObjectiveService.filter(key.deviceId(), filtObjBuilder.remove((ObjectiveContext)context));
        });
    }

    private void revokeNext(final XConnectStoreKey key, NextObjective nextObj, final CompletableFuture<ObjectiveError> nextFuture) {
        ObjectiveContext context = new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                log.debug("Previous NextObj for {} removed", (Object)key);
                if (nextFuture != null) {
                    nextFuture.complete(null);
                }
            }

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to remove previous NextObj for {}: {}", (Object)key, (Object)error);
                if (nextFuture != null) {
                    nextFuture.complete(error);
                }
            }
        };
        this.srManager.flowObjectiveService.next(key.deviceId(), (NextObjective)nextObj.copy().remove(context));
        this.xConnectNextObjStore.remove((Object)key);
    }

    private void revokeFwd(final XConnectStoreKey key, NextObjective nextObj, final CompletableFuture<ObjectiveError> fwdFuture) {
        ForwardingObjective.Builder fwdObjBuilder = this.fwdObjBuilder(key, nextObj.id());
        ObjectiveContext context = new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                log.debug("Previous FwdObj for {} removed", (Object)key);
                if (fwdFuture != null) {
                    fwdFuture.complete(null);
                }
            }

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to remove previous FwdObj for {}: {}", (Object)key, (Object)error);
                if (fwdFuture != null) {
                    fwdFuture.complete(error);
                }
            }
        };
        this.srManager.flowObjectiveService.forward(key.deviceId(), fwdObjBuilder.remove(context));
    }

    private void updateXConnect(XConnectStoreKey key, Set<PortNumber> prevPorts, Set<PortNumber> ports) {
        prevPorts.stream().filter(port -> !ports.contains(port)).forEach(port -> this.revokeFilter(key, (Set<PortNumber>)ImmutableSet.of((Object)port)));
        ports.stream().filter(port -> !prevPorts.contains(port)).forEach(port -> this.populateFilter(key, (Set<PortNumber>)ImmutableSet.of((Object)port)));
        CompletableFuture<ObjectiveError> fwdFuture = new CompletableFuture<ObjectiveError>();
        CompletableFuture nextFuture = new CompletableFuture();
        if (this.xConnectNextObjStore.containsKey((Object)key)) {
            NextObjective nextObj = (NextObjective)this.xConnectNextObjStore.get((Object)key).value();
            this.revokeFwd(key, nextObj, fwdFuture);
            fwdFuture.thenAcceptAsync(fwdStatus -> {
                if (fwdStatus == null) {
                    log.debug("Fwd removed. Now remove group {}", (Object)key);
                    this.revokeNext(key, nextObj, nextFuture);
                }
            });
            nextFuture.thenAcceptAsync(nextStatus -> {
                if (nextStatus == null) {
                    log.debug("Installing new group and flow for {}", (Object)key);
                    this.populateFwd(key, this.populateNext(key, ports));
                }
            });
        } else {
            log.warn("NextObj for {} does not exist in the store.", (Object)key);
        }
    }

    protected void removeDevice(DeviceId deviceId) {
        this.xConnectNextObjStore.entrySet().stream().filter(entry -> ((XConnectStoreKey)entry.getKey()).deviceId().equals((Object)deviceId)).forEach(entry -> this.xConnectNextObjStore.remove(entry.getKey()));
        log.debug("{} is removed from xConnectNextObjStore", (Object)deviceId);
    }

    private NextObjective.Builder nextObjBuilder(XConnectStoreKey key, Set<PortNumber> ports) {
        int nextId = this.srManager.flowObjectiveService.allocateNextId();
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchVlanId(key.vlanId()).build();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.BROADCAST).fromApp(this.srManager.appId).withMeta(metadata);
        ports.forEach(arg_0 -> XConnectHandler.lambda$nextObjBuilder$26((NextObjective.Builder)nextObjBuilder, arg_0));
        return nextObjBuilder;
    }

    private ForwardingObjective.Builder fwdObjBuilder(XConnectStoreKey key, int nextId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        sbuilder.matchVlanId(key.vlanId());
        sbuilder.matchEthDst(MacAddress.NONE);
        DefaultForwardingObjective.Builder fob = DefaultForwardingObjective.builder();
        fob.withFlag(ForwardingObjective.Flag.SPECIFIC).withSelector(sbuilder.build()).nextStep(nextId).withPriority(1000).fromApp(this.srManager.appId).makePermanent();
        return fob;
    }

    private FilteringObjective.Builder filterObjBuilder(XConnectStoreKey key, PortNumber port) {
        DefaultFilteringObjective.Builder fob = DefaultFilteringObjective.builder();
        fob.withKey(Criteria.matchInPort((PortNumber)port)).addCondition(Criteria.matchVlanId((VlanId)key.vlanId())).addCondition(Criteria.matchEthDst((MacAddress)MacAddress.NONE)).withPriority(1000);
        return fob.permit().fromApp(this.srManager.appId);
    }

    private static /* synthetic */ void lambda$nextObjBuilder$26(NextObjective.Builder nextObjBuilder, PortNumber port) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        tBuilder.setOutput(port);
        nextObjBuilder.addTreatment(tBuilder.build());
    }

    private final class NextObjContext
    implements ObjectiveContext {
        Objective.Operation op;
        XConnectStoreKey key;

        private NextObjContext(Objective.Operation op, XConnectStoreKey key) {
            this.op = op;
            this.key = key;
        }

        public void onSuccess(Objective objective) {
            log.debug("XConnect NextObj for {} {}ED", (Object)this.key, (Object)this.op);
        }

        public void onError(Objective objective, ObjectiveError error) {
            log.warn("Failed to {} XConnect NextObj for {}: {}", new Object[]{this.op, this.key, error});
        }
    }
}

