/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.segmentrouting.Policy;

public final class TunnelPolicy
implements Policy {
    private final Policy.Type type;
    private final String id;
    private final int priority;
    private final String tunnelId;
    private String dstIp;
    private String srcIp;
    private String ipProto;
    private short srcPort;
    private short dstPort;

    private TunnelPolicy(String policyId, Policy.Type type, int priority, String tunnelId, String srcIp, String dstIp, String ipProto, short srcPort, short dstPort) {
        this.id = (String)Preconditions.checkNotNull((Object)policyId);
        this.type = type;
        this.tunnelId = tunnelId;
        this.priority = priority;
        this.dstIp = dstIp;
        this.srcIp = srcIp;
        this.ipProto = ipProto;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
    }

    public TunnelPolicy(TunnelPolicy p) {
        this.id = p.id;
        this.type = p.type;
        this.tunnelId = p.tunnelId;
        this.priority = p.priority;
        this.srcIp = p.srcIp;
        this.dstIp = p.dstIp;
        this.ipProto = p.ipProto;
        this.srcPort = p.srcPort;
        this.dstPort = p.dstPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Policy.Type type() {
        return this.type;
    }

    @Override
    public String srcIp() {
        return this.srcIp;
    }

    @Override
    public String dstIp() {
        return this.dstIp;
    }

    @Override
    public String ipProto() {
        return this.ipProto;
    }

    @Override
    public short srcPort() {
        return this.srcPort;
    }

    @Override
    public short dstPort() {
        return this.dstPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TunnelPolicy) {
            TunnelPolicy that = (TunnelPolicy)o;
            if (this.type.equals((Object)that.type) && this.tunnelId.equals(that.tunnelId) && this.priority == that.priority && this.srcIp.equals(that.srcIp) && this.dstIp.equals(that.dstIp) && this.srcPort == that.srcPort && this.dstPort == that.dstPort && this.ipProto.equals(that.ipProto)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tunnelId, this.srcIp, this.dstIp, this.ipProto, this.srcPort, this.dstPort, this.priority});
    }

    public String tunnelId() {
        return this.tunnelId;
    }

    public static final class Builder {
        private String id;
        private Policy.Type type;
        private int priority;
        private String tunnelId;
        private String dstIp;
        private String srcIp;
        private String ipProto;
        private short srcPort;
        private short dstPort;

        public Builder setPolicyId(String id) {
            this.id = id;
            return this;
        }

        public Builder setType(Policy.Type type) {
            this.type = type;
            return this;
        }

        public Builder setSrcIp(String srcIp) {
            this.srcIp = srcIp;
            return this;
        }

        public Builder setDstIp(String dstIp) {
            this.dstIp = dstIp;
            return this;
        }

        public Builder setIpProto(String proto) {
            this.ipProto = proto;
            return this;
        }

        public Builder setSrcPort(short srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public Builder setDstPort(short dstPort) {
            this.dstPort = dstPort;
            return this;
        }

        public Builder setPriority(int p) {
            this.priority = p;
            return this;
        }

        public Builder setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public Policy build() {
            return new TunnelPolicy(this.id, this.type, this.priority, this.tunnelId, this.srcIp, this.dstIp, this.ipProto, this.srcPort, this.dstPort);
        }
    }
}

