/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.link.LinkService;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.Tunnel;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.onosproject.segmentrouting.grouphandler.DefaultGroupHandler;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeviceConfiguration config;
    private final EventuallyConsistentMap<String, Tunnel> tunnelStore;
    private Map<DeviceId, DefaultGroupHandler> groupHandlerMap;
    private LinkService linkService;

    public TunnelHandler(LinkService linkService, DeviceConfiguration deviceConfiguration, Map<DeviceId, DefaultGroupHandler> groupHandlerMap, EventuallyConsistentMap<String, Tunnel> tunnelStore) {
        this.linkService = linkService;
        this.config = deviceConfiguration;
        this.groupHandlerMap = groupHandlerMap;
        this.tunnelStore = tunnelStore;
    }

    public Result createTunnel(Tunnel tunnel) {
        if (tunnel.labelIds().isEmpty() || tunnel.labelIds().size() < 3) {
            this.log.error("More than one router needs to specified to created a tunnel");
            return Result.WRONG_PATH;
        }
        if (this.tunnelStore.containsKey((Object)tunnel.id())) {
            this.log.warn("The same tunnel ID exists already");
            return Result.ID_EXISTS;
        }
        if (this.tunnelStore.containsValue((Object)tunnel)) {
            this.log.warn("The same tunnel exists already");
            return Result.TUNNEL_EXISTS;
        }
        int groupId = this.createGroupsForTunnel(tunnel);
        if (groupId < 0) {
            this.log.error("Failed to create groups for the tunnel");
            return Result.INTERNAL_ERROR;
        }
        tunnel.setGroupId(groupId);
        this.tunnelStore.put((Object)tunnel.id(), (Object)tunnel);
        return Result.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Result removeTunnel(Tunnel tunnelInfo) {
        Tunnel tunnel = (Tunnel)this.tunnelStore.get((Object)tunnelInfo.id());
        if (tunnel == null) {
            this.log.error("No tunnel found for tunnel ID {}", (Object)tunnelInfo.id());
            return Result.TUNNEL_NOT_FOUND;
        }
        DeviceId deviceId = this.config.getDeviceId(tunnel.labelIds().get(0));
        if (!tunnel.isAllowedToRemoveGroup()) {
            this.log.debug("The group is not removed because it is being used.");
            this.tunnelStore.remove((Object)tunnel.id());
            return Result.SUCCESS;
        }
        if (this.groupHandlerMap.get(deviceId).removeGroup(tunnel.groupId())) {
            this.tunnelStore.remove((Object)tunnel.id());
            return Result.SUCCESS;
        }
        this.log.error("Failed to remove the tunnel {}", (Object)tunnelInfo.id());
        return Result.INTERNAL_ERROR;
    }

    public Tunnel getTunnel(String tid) {
        return (Tunnel)this.tunnelStore.get((Object)tid);
    }

    public List<Tunnel> getTunnels() {
        ArrayList<Tunnel> tunnels = new ArrayList<Tunnel>();
        this.tunnelStore.values().forEach(tunnel -> tunnels.add(new DefaultTunnel((DefaultTunnel)tunnel)));
        return tunnels;
    }

    private int createGroupsForTunnel(Tunnel tunnel) {
        int groupError = -1;
        DeviceId deviceId = this.config.getDeviceId(tunnel.labelIds().get(0));
        if (deviceId == null) {
            this.log.warn("No device found for SID {}", (Object)tunnel.labelIds().get(0));
            return -1;
        }
        if (this.groupHandlerMap.get(deviceId) == null) {
            this.log.warn("group handler not found for {}", (Object)deviceId);
            return -1;
        }
        HashSet<DeviceId> deviceIds = new HashSet<DeviceId>();
        int sid = tunnel.labelIds().get(1);
        if (this.config.isAdjacencySid(deviceId, sid)) {
            Set<Integer> portNumbers = this.config.getPortsForAdjacencySid(deviceId, sid);
            for (Link link : this.linkService.getDeviceEgressLinks(deviceId)) {
                for (Integer port : portNumbers) {
                    if (link.src().port().toLong() != (long)port.intValue()) continue;
                    deviceIds.add(link.dst().deviceId());
                }
            }
        } else {
            deviceIds.add(this.config.getDeviceId(sid));
        }
        NeighborSet ns = new NeighborSet(deviceIds, false, tunnel.labelIds().get(2));
        if (this.groupHandlerMap.get(deviceId).hasNextObjectiveId(ns)) {
            tunnel.allowToRemoveGroup(false);
        } else {
            tunnel.allowToRemoveGroup(true);
        }
        return this.groupHandlerMap.get(deviceId).getNextObjectiveId(ns, null, true);
    }

    public static enum Result {
        SUCCESS,
        WRONG_PATH,
        TUNNEL_EXISTS,
        ID_EXISTS,
        TUNNEL_NOT_FOUND,
        TUNNEL_IN_USE,
        INTERNAL_ERROR;

    }
}

