/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentRoutingNeighbourHandler {
    private static Logger log = LoggerFactory.getLogger(SegmentRoutingNeighbourHandler.class);
    protected SegmentRoutingManager srManager;
    protected DeviceConfiguration config;

    public SegmentRoutingNeighbourHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.config = (DeviceConfiguration)Preconditions.checkNotNull((Object)srManager.deviceConfiguration);
    }

    public SegmentRoutingNeighbourHandler() {
        this.srManager = null;
        this.config = null;
    }

    protected boolean getSenderInfo(byte[] mac, byte[] ip, DeviceId deviceId, IpAddress targetAddress) {
        byte[] senderIpAddress;
        byte[] senderMacAddress;
        try {
            senderMacAddress = this.config.getDeviceMac(deviceId).toBytes();
            Object sender = targetAddress.isIp4() ? this.config.getRouterIpAddressForASubnetHost(targetAddress.getIp4Address()) : this.config.getRouterIpAddressForASubnetHost(targetAddress.getIp6Address());
            if (sender == null) {
                log.warn("Sender ip is null. Aborting getSenderInfo");
                return false;
            }
            senderIpAddress = sender.toOctets();
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting getSenderInfo");
            return false;
        }
        System.arraycopy(senderMacAddress, 0, mac, 0, senderMacAddress.length);
        System.arraycopy(senderIpAddress, 0, ip, 0, senderIpAddress.length);
        return true;
    }

    protected void sendResponse(NeighbourMessageContext pkt, MacAddress targetMac, HostService hostService) {
        HostId dstId = HostId.hostId((MacAddress)pkt.srcMac(), (VlanId)pkt.vlan());
        Host dst = hostService.getHost(dstId);
        if (dst == null) {
            log.warn("Cannot send {} response to host {} - does not exist in the store", (Object)pkt.protocol(), (Object)dstId);
            return;
        }
        pkt.reply(targetMac);
    }

    protected void flood(Ethernet packet, ConnectPoint inPort, IpAddress targetAddress) {
        try {
            this.srManager.deviceConfiguration.getSubnetPortsMap(inPort.deviceId()).forEach((subnet, ports) -> {
                if (subnet.contains(targetAddress)) {
                    ports.stream().filter(port -> port != inPort.port()).forEach(port -> this.forward(packet, new ConnectPoint((ElementId)inPort.deviceId(), port)));
                }
            });
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Cannot flood in subnet as device config not available for device: " + inPort.deviceId());
        }
    }

    protected void flood(NeighbourMessageContext pkt) {
        try {
            this.srManager.deviceConfiguration.getSubnetPortsMap(pkt.inPort().deviceId()).forEach((subnet, ports) -> {
                if (subnet.contains(pkt.target())) {
                    ports.stream().filter(port -> port != pkt.inPort().port()).forEach(port -> {
                        ConnectPoint outPoint = new ConnectPoint((ElementId)pkt.inPort().deviceId(), port);
                        pkt.forward(outPoint);
                    });
                }
            });
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Cannot flood in subnet as device config not available for device: " + pkt.inPort().deviceId());
        }
    }

    private void forward(Ethernet packet, ConnectPoint outPort) {
        ByteBuffer buf = ByteBuffer.wrap(packet.serialize());
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        tbuilder.setOutput(outPort.port());
        this.srManager.packetService.emit((OutboundPacket)new DefaultOutboundPacket(outPort.deviceId(), tbuilder.build(), buf));
    }
}

