/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.net.host.HostService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentRoutingNeighbourDispatcher
implements NeighbourMessageHandler {
    private static Logger log = LoggerFactory.getLogger(SegmentRoutingNeighbourDispatcher.class);
    private SegmentRoutingManager manager;

    public SegmentRoutingNeighbourDispatcher(SegmentRoutingManager segmentRoutingManager) {
        this.manager = segmentRoutingManager;
    }

    public void handleMessage(NeighbourMessageContext context, HostService hostService) {
        log.trace("Received a {} packet {}", (Object)context.protocol(), (Object)context.packet());
        switch (context.protocol()) {
            case ARP: {
                if (this.manager.arpHandler == null) break;
                this.manager.arpHandler.processPacketIn(context, hostService);
                break;
            }
            case NDP: {
                if (this.manager.icmpHandler == null) break;
                this.manager.icmpHandler.processPacketIn(context, hostService);
                break;
            }
            default: {
                log.warn("Unknown protocol", (Object)context.protocol());
            }
        }
    }
}

