/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.InterfaceConfig;
import org.onosproject.incubator.net.config.basics.McastConfig;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.incubator.net.neighbour.NeighbourResolutionService;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.incubator.net.routing.RouteListener;
import org.onosproject.incubator.net.routing.RouteService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastListener;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.segmentrouting.AppConfigHandler;
import org.onosproject.segmentrouting.ArpHandler;
import org.onosproject.segmentrouting.DefaultRoutingHandler;
import org.onosproject.segmentrouting.DefaultTunnel;
import org.onosproject.segmentrouting.HostHandler;
import org.onosproject.segmentrouting.IcmpHandler;
import org.onosproject.segmentrouting.IpHandler;
import org.onosproject.segmentrouting.McastHandler;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.PolicyHandler;
import org.onosproject.segmentrouting.RouteHandler;
import org.onosproject.segmentrouting.RoutingRulePopulator;
import org.onosproject.segmentrouting.SegmentRoutingNeighbourDispatcher;
import org.onosproject.segmentrouting.SegmentRoutingService;
import org.onosproject.segmentrouting.Tunnel;
import org.onosproject.segmentrouting.TunnelHandler;
import org.onosproject.segmentrouting.TunnelPolicy;
import org.onosproject.segmentrouting.XConnectHandler;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.onosproject.segmentrouting.config.PwaasConfig;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.onosproject.segmentrouting.config.SegmentRoutingDeviceConfig;
import org.onosproject.segmentrouting.config.XConnectConfig;
import org.onosproject.segmentrouting.grouphandler.DefaultGroupHandler;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;
import org.onosproject.segmentrouting.pwaas.L2TunnelHandler;
import org.onosproject.segmentrouting.storekey.NeighborSetNextObjectiveStoreKey;
import org.onosproject.segmentrouting.storekey.PortNextObjectiveStoreKey;
import org.onosproject.segmentrouting.storekey.SubnetAssignedVidStoreKey;
import org.onosproject.segmentrouting.storekey.VlanNextObjectiveStoreKey;
import org.onosproject.segmentrouting.storekey.XConnectStoreKey;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class SegmentRoutingManager
implements SegmentRoutingService {
    private static Logger log = LoggerFactory.getLogger(SegmentRoutingManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ComponentConfigService compCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private NeighbourResolutionService neighbourResolutionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    MulticastRouteService multicastRouteService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    RouteService routeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public NetworkConfigRegistry cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    public InterfaceService interfaceService;
    ArpHandler arpHandler = null;
    IcmpHandler icmpHandler = null;
    IpHandler ipHandler = null;
    RoutingRulePopulator routingRulePopulator = null;
    ApplicationId appId;
    DeviceConfiguration deviceConfiguration = null;
    DefaultRoutingHandler defaultRoutingHandler = null;
    private TunnelHandler tunnelHandler = null;
    private PolicyHandler policyHandler = null;
    private InternalPacketProcessor processor = null;
    private InternalLinkListener linkListener = null;
    private InternalDeviceListener deviceListener = null;
    private AppConfigHandler appCfgHandler = null;
    XConnectHandler xConnectHandler = null;
    private McastHandler mcastHandler = null;
    HostHandler hostHandler = null;
    private RouteHandler routeHandler = null;
    private SegmentRoutingNeighbourDispatcher neighbourHandler = null;
    private L2TunnelHandler l2TunnelHandler = null;
    private InternalEventHandler eventHandler = new InternalEventHandler();
    private final InternalHostListener hostListener = new InternalHostListener();
    private final InternalConfigListener cfgListener = new InternalConfigListener(this);
    private final InternalMcastListener mcastListener = new InternalMcastListener();
    private final InternalRouteEventListener routeListener = new InternalRouteEventListener();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"SegmentRoutingManager", (String)"event-%d", (Logger)log));
    private static ScheduledFuture<?> eventHandlerFuture = null;
    private ConcurrentLinkedQueue<Event> eventQueue = new ConcurrentLinkedQueue();
    private Map<DeviceId, DefaultGroupHandler> groupHandlerMap = new ConcurrentHashMap<DeviceId, DefaultGroupHandler>();
    EventuallyConsistentMap<NeighborSetNextObjectiveStoreKey, Integer> nsNextObjStore = null;
    EventuallyConsistentMap<VlanNextObjectiveStoreKey, Integer> vlanNextObjStore = null;
    EventuallyConsistentMap<PortNextObjectiveStoreKey, Integer> portNextObjStore = null;
    private EventuallyConsistentMap<String, Tunnel> tunnelStore = null;
    private EventuallyConsistentMap<String, Policy> policyStore = null;
    private final ConfigFactory<DeviceId, SegmentRoutingDeviceConfig> deviceConfigFactory = new ConfigFactory<DeviceId, SegmentRoutingDeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, SegmentRoutingDeviceConfig.class, "segmentrouting"){

        public SegmentRoutingDeviceConfig createConfig() {
            return new SegmentRoutingDeviceConfig();
        }
    };
    private final ConfigFactory<ApplicationId, SegmentRoutingAppConfig> appConfigFactory = new ConfigFactory<ApplicationId, SegmentRoutingAppConfig>(SubjectFactories.APP_SUBJECT_FACTORY, SegmentRoutingAppConfig.class, "segmentrouting"){

        public SegmentRoutingAppConfig createConfig() {
            return new SegmentRoutingAppConfig();
        }
    };
    private final ConfigFactory<ApplicationId, XConnectConfig> xConnectConfigFactory = new ConfigFactory<ApplicationId, XConnectConfig>(SubjectFactories.APP_SUBJECT_FACTORY, XConnectConfig.class, "xconnect"){

        public XConnectConfig createConfig() {
            return new XConnectConfig();
        }
    };
    private ConfigFactory<ApplicationId, McastConfig> mcastConfigFactory = new ConfigFactory<ApplicationId, McastConfig>(SubjectFactories.APP_SUBJECT_FACTORY, McastConfig.class, "multicast"){

        public McastConfig createConfig() {
            return new McastConfig();
        }
    };
    private final ConfigFactory<ApplicationId, PwaasConfig> pwaasConfigFactory = new ConfigFactory<ApplicationId, PwaasConfig>(SubjectFactories.APP_SUBJECT_FACTORY, PwaasConfig.class, "pwaas"){

        public PwaasConfig createConfig() {
            return new PwaasConfig();
        }
    };
    private Object threadSchedulerLock = new Object();
    private static int numOfEventsQueued = 0;
    private static int numOfEventsExecuted = 0;
    private static int numOfHandlerExecution = 0;
    private static int numOfHandlerScheduled = 0;
    public static final String APP_NAME = "org.onosproject.segmentrouting";
    public static final VlanId INTERNAL_VLAN = VlanId.vlanId((short)4094);

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        log.debug("Creating EC map nsnextobjectivestore");
        EventuallyConsistentMapBuilder nsNextObjMapBuilder = this.storageService.eventuallyConsistentMapBuilder();
        this.nsNextObjStore = nsNextObjMapBuilder.withName("nsnextobjectivestore").withSerializer(this.createSerializer()).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        log.trace("Current size {}", (Object)this.nsNextObjStore.size());
        log.debug("Creating EC map vlannextobjectivestore");
        EventuallyConsistentMapBuilder vlanNextObjMapBuilder = this.storageService.eventuallyConsistentMapBuilder();
        this.vlanNextObjStore = vlanNextObjMapBuilder.withName("vlannextobjectivestore").withSerializer(this.createSerializer()).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        log.debug("Creating EC map subnetnextobjectivestore");
        EventuallyConsistentMapBuilder portNextObjMapBuilder = this.storageService.eventuallyConsistentMapBuilder();
        this.portNextObjStore = portNextObjMapBuilder.withName("portnextobjectivestore").withSerializer(this.createSerializer()).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        EventuallyConsistentMapBuilder tunnelMapBuilder = this.storageService.eventuallyConsistentMapBuilder();
        this.tunnelStore = tunnelMapBuilder.withName("tunnelstore").withSerializer(this.createSerializer()).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        EventuallyConsistentMapBuilder policyMapBuilder = this.storageService.eventuallyConsistentMapBuilder();
        this.policyStore = policyMapBuilder.withName("policystore").withSerializer(this.createSerializer()).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.compCfgService.preSetProperty("org.onosproject.net.group.impl.GroupManager", "purgeOnDisconnection", "true");
        this.compCfgService.preSetProperty("org.onosproject.net.flow.impl.FlowRuleManager", "purgeOnDisconnection", "true");
        this.compCfgService.preSetProperty("org.onosproject.provider.host.impl.HostLocationProvider", "requestInterceptsEnabled", "false");
        this.compCfgService.preSetProperty("org.onosproject.incubator.net.neighbour.impl.NeighbourResolutionManager", "requestInterceptsEnabled", "false");
        this.compCfgService.preSetProperty("org.onosproject.dhcprelay.DhcpRelay", "arpEnabled", "false");
        this.compCfgService.preSetProperty("org.onosproject.net.host.impl.HostManager", "greedyLearningIpv6", "true");
        this.compCfgService.preSetProperty("org.onosproject.routing.cpr.ControlPlaneRedirectManager", "forceUnprovision", "true");
        this.compCfgService.preSetProperty("org.onosproject.incubator.store.routing.impl.RouteStoreImpl", "distributed", "true");
        this.processor = new InternalPacketProcessor();
        this.linkListener = new InternalLinkListener();
        this.deviceListener = new InternalDeviceListener();
        this.appCfgHandler = new AppConfigHandler(this);
        this.xConnectHandler = new XConnectHandler(this);
        this.mcastHandler = new McastHandler(this);
        this.hostHandler = new HostHandler(this);
        this.routeHandler = new RouteHandler(this);
        this.neighbourHandler = new SegmentRoutingNeighbourDispatcher(this);
        this.l2TunnelHandler = new L2TunnelHandler(this);
        this.cfgService.addListener((EventListener)this.cfgListener);
        this.cfgService.registerConfigFactory(this.deviceConfigFactory);
        this.cfgService.registerConfigFactory(this.appConfigFactory);
        this.cfgService.registerConfigFactory(this.xConnectConfigFactory);
        this.cfgService.registerConfigFactory(this.mcastConfigFactory);
        this.cfgService.registerConfigFactory(this.pwaasConfigFactory);
        this.hostService.addListener((EventListener)this.hostListener);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        this.linkService.addListener((EventListener)this.linkListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.multicastRouteService.addListener((EventListener)this.mcastListener);
        this.routeService.addListener((EventListener)this.routeListener);
        this.cfgListener.configureNetwork();
        log.info("Started");
    }

    private KryoNamespace.Builder createSerializer() {
        return new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{NeighborSetNextObjectiveStoreKey.class, VlanNextObjectiveStoreKey.class, SubnetAssignedVidStoreKey.class, NeighborSet.class, Tunnel.class, DefaultTunnel.class, Policy.class, TunnelPolicy.class, Policy.Type.class, PortNextObjectiveStoreKey.class, XConnectStoreKey.class});
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgListener);
        this.cfgService.unregisterConfigFactory(this.deviceConfigFactory);
        this.cfgService.unregisterConfigFactory(this.appConfigFactory);
        this.cfgService.unregisterConfigFactory(this.xConnectConfigFactory);
        this.cfgService.unregisterConfigFactory(this.mcastConfigFactory);
        this.cfgService.unregisterConfigFactory(this.pwaasConfigFactory);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.multicastRouteService.removeListener((EventListener)this.mcastListener);
        this.routeService.removeListener((EventListener)this.routeListener);
        this.neighbourResolutionService.unregisterNeighbourHandlers(this.appId);
        this.processor = null;
        this.linkListener = null;
        this.deviceListener = null;
        this.groupHandlerMap.clear();
        this.nsNextObjStore.destroy();
        this.vlanNextObjStore.destroy();
        this.portNextObjStore.destroy();
        this.tunnelStore.destroy();
        this.policyStore.destroy();
        log.info("Stopped");
    }

    @Override
    public List<Tunnel> getTunnels() {
        return this.tunnelHandler.getTunnels();
    }

    @Override
    public TunnelHandler.Result createTunnel(Tunnel tunnel) {
        return this.tunnelHandler.createTunnel(tunnel);
    }

    @Override
    public TunnelHandler.Result removeTunnel(Tunnel tunnel) {
        for (Policy policy : this.policyHandler.getPolicies()) {
            TunnelPolicy tunnelPolicy;
            if (policy.type() != Policy.Type.TUNNEL_FLOW || !(tunnelPolicy = (TunnelPolicy)policy).tunnelId().equals(tunnel.id())) continue;
            log.warn("Cannot remove the tunnel used by a policy");
            return TunnelHandler.Result.TUNNEL_IN_USE;
        }
        return this.tunnelHandler.removeTunnel(tunnel);
    }

    @Override
    public PolicyHandler.Result removePolicy(Policy policy) {
        return this.policyHandler.removePolicy(policy);
    }

    @Override
    public PolicyHandler.Result createPolicy(Policy policy) {
        return this.policyHandler.createPolicy(policy);
    }

    @Override
    public List<Policy> getPolicies() {
        return this.policyHandler.getPolicies();
    }

    @Override
    public void rerouteNetwork() {
        this.cfgListener.configureNetwork();
        for (Device device : this.deviceService.getDevices()) {
            if (!this.mastershipService.isLocalMaster(device.id())) continue;
            this.defaultRoutingHandler.populatePortAddressingRules(device.id());
        }
        this.defaultRoutingHandler.startPopulationProcess();
    }

    @Override
    public Map<DeviceId, Set<IpPrefix>> getDeviceSubnetMap() {
        HashMap deviceSubnetMap = Maps.newHashMap();
        this.deviceService.getAvailableDevices().forEach(device -> deviceSubnetMap.put(device.id(), this.deviceConfiguration.getSubnets(device.id())));
        return deviceSubnetMap;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public DeviceConfiguration deviceConfiguration() {
        return this.deviceConfiguration;
    }

    public EventuallyConsistentMap<NeighborSetNextObjectiveStoreKey, Integer> nsNextObjStore() {
        return this.nsNextObjStore;
    }

    public EventuallyConsistentMap<VlanNextObjectiveStoreKey, Integer> vlanNextObjStore() {
        return this.vlanNextObjStore;
    }

    public EventuallyConsistentMap<PortNextObjectiveStoreKey, Integer> portNextObjStore() {
        return this.portNextObjStore;
    }

    public boolean getMplsEcmp() {
        SegmentRoutingAppConfig segmentRoutingAppConfig = (SegmentRoutingAppConfig)this.cfgService.getConfig((Object)this.appId, SegmentRoutingAppConfig.class);
        return segmentRoutingAppConfig != null && segmentRoutingAppConfig.mplsEcmp();
    }

    public Tunnel getTunnel(String tunnelId) {
        return this.tunnelHandler.getTunnel(tunnelId);
    }

    public VlanId getUntaggedVlanId(ConnectPoint connectPoint) {
        return this.interfaceService.getInterfacesByPort(connectPoint).stream().filter(intf -> !intf.vlanUntagged().equals((Object)VlanId.NONE)).map(Interface::vlanUntagged).findFirst().orElse(null);
    }

    public Set<VlanId> getTaggedVlanId(ConnectPoint connectPoint) {
        Set interfaces = this.interfaceService.getInterfacesByPort(connectPoint);
        return interfaces.stream().map(Interface::vlanTagged).flatMap(vlanIds -> vlanIds.stream()).collect(Collectors.toSet());
    }

    public VlanId getNativeVlanId(ConnectPoint connectPoint) {
        Set interfaces = this.interfaceService.getInterfacesByPort(connectPoint);
        return interfaces.stream().filter(intf -> !intf.vlanNative().equals((Object)VlanId.NONE)).map(Interface::vlanNative).findFirst().orElse(null);
    }

    public Multimap<VlanId, PortNumber> getVlanPortMap(DeviceId deviceId) {
        HashMultimap vlanPortMap = HashMultimap.create();
        this.interfaceService.getInterfaces().stream().filter(intf -> intf.connectPoint().deviceId().equals((Object)deviceId)).forEach(intf -> {
            vlanPortMap.put((Object)intf.vlanUntagged(), (Object)intf.connectPoint().port());
            intf.vlanTagged().forEach(vlanTagged -> vlanPortMap.put(vlanTagged, (Object)intf.connectPoint().port()));
            vlanPortMap.put((Object)intf.vlanNative(), (Object)intf.connectPoint().port());
        });
        vlanPortMap.removeAll((Object)VlanId.NONE);
        return vlanPortMap;
    }

    public int getNextObjectiveId(DeviceId deviceId, NeighborSet ns, TrafficSelector meta, boolean isBos) {
        if (this.groupHandlerMap.get(deviceId) != null) {
            log.trace("getNextObjectiveId query in device {}", (Object)deviceId);
            return this.groupHandlerMap.get(deviceId).getNextObjectiveId(ns, meta, isBos);
        }
        log.warn("getNextObjectiveId query - groupHandler for device {} not found", (Object)deviceId);
        return -1;
    }

    public int getNextObjectiveId(DeviceId deviceId, NeighborSet ns, TrafficSelector meta) {
        return this.getNextObjectiveId(deviceId, ns, meta, true);
    }

    public int getVlanNextObjectiveId(DeviceId deviceId, VlanId vlanId) {
        if (this.groupHandlerMap.get(deviceId) != null) {
            log.trace("getVlanNextObjectiveId query in device {}", (Object)deviceId);
            return this.groupHandlerMap.get(deviceId).getVlanNextObjectiveId(vlanId);
        }
        log.warn("getVlanNextObjectiveId query - groupHandler for device {} not found", (Object)deviceId);
        return -1;
    }

    public int getPortNextObjectiveId(DeviceId deviceId, PortNumber portNum, TrafficTreatment treatment, TrafficSelector meta, boolean createIfMissing) {
        DefaultGroupHandler ghdlr = this.groupHandlerMap.get(deviceId);
        if (ghdlr != null) {
            return ghdlr.getPortNextObjectiveId(portNum, treatment, meta, createIfMissing);
        }
        log.warn("getPortNextObjectiveId query - groupHandler for device {} not found", (Object)deviceId);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleEventHandlerIfNotScheduled(Event event) {
        Object object = this.threadSchedulerLock;
        synchronized (object) {
            this.eventQueue.add(event);
            ++numOfEventsQueued;
            if (numOfHandlerScheduled - numOfHandlerExecution == 0) {
                eventHandlerFuture = this.executorService.schedule(this.eventHandler, 100L, TimeUnit.MILLISECONDS);
                ++numOfHandlerScheduled;
            }
            log.trace("numOfEventsQueued {}, numOfEventHandlerScheduled {}", (Object)numOfEventsQueued, (Object)numOfHandlerScheduled);
        }
    }

    private void processLinkAdded(Link link) {
        log.info("** LINK ADDED {}", (Object)link.toString());
        if (!this.deviceConfiguration.isConfigured(link.src().deviceId())) {
            log.warn("Source device of this link is not configured.");
            return;
        }
        DefaultGroupHandler groupHandler = this.groupHandlerMap.get(link.src().deviceId());
        if (groupHandler != null) {
            groupHandler.linkUp(link, this.mastershipService.isLocalMaster(link.src().deviceId()));
        } else {
            Device device = this.deviceService.getDevice(link.src().deviceId());
            if (device != null) {
                log.warn("processLinkAdded: Link Added Notification without Device Added event, still handling it");
                this.processDeviceAdded(device);
                groupHandler = this.groupHandlerMap.get(link.src().deviceId());
                groupHandler.linkUp(link, this.mastershipService.isLocalMaster(device.id()));
            }
        }
        log.trace("Starting optimized route population process");
        this.defaultRoutingHandler.populateRoutingRulesForLinkStatusChange(null);
        this.mcastHandler.init();
    }

    private void processLinkRemoved(Link link) {
        log.info("** LINK REMOVED {}", (Object)link.toString());
        DefaultGroupHandler groupHandler = this.groupHandlerMap.get(link.src().deviceId());
        if (groupHandler != null) {
            groupHandler.portDown(link.src().port(), this.mastershipService.isLocalMaster(link.src().deviceId()));
        }
        log.trace("Starting optimized route population process");
        this.defaultRoutingHandler.populateRoutingRulesForLinkStatusChange(link);
        this.mcastHandler.processLinkDown(link);
    }

    private void processDeviceAdded(Device device) {
        log.info("** DEVICE ADDED with ID {}", (Object)device.id());
        this.routingRulePopulator.populateIpPunts(device.id());
        this.routingRulePopulator.populateArpNdpPunts(device.id());
        if (this.deviceConfiguration == null || !this.deviceConfiguration.isConfigured(device.id())) {
            log.warn("Device configuration uploading. Device {} will be processed after config completes.", (Object)device.id());
            return;
        }
        this.processDeviceAddedInternal(device.id());
    }

    private void processDeviceAddedInternal(DeviceId deviceId) {
        DefaultGroupHandler groupHandler;
        log.debug("Current groupHandlerMap devs: {}", this.groupHandlerMap.keySet());
        if (this.groupHandlerMap.get(deviceId) == null) {
            try {
                groupHandler = DefaultGroupHandler.createGroupHandler(deviceId, this.appId, this.deviceConfiguration, this.linkService, this.flowObjectiveService, this);
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn(e.getMessage() + " Aborting processDeviceAdded.");
                return;
            }
            log.debug("updating groupHandlerMap with new config for device: {}", (Object)deviceId);
            this.groupHandlerMap.put(deviceId, groupHandler);
        }
        if (this.mastershipService.isLocalMaster(deviceId)) {
            this.defaultRoutingHandler.populatePortAddressingRules(deviceId);
            this.hostHandler.init(deviceId);
            this.xConnectHandler.init(deviceId);
            groupHandler = this.groupHandlerMap.get(deviceId);
            groupHandler.createGroupsFromVlanConfig();
            this.routingRulePopulator.populateSubnetBroadcastRule(deviceId);
        }
        this.appCfgHandler.init(deviceId);
        this.routeHandler.init(deviceId);
    }

    private void processDeviceRemoved(Device device) {
        this.nsNextObjStore.entrySet().stream().filter(entry -> ((NeighborSetNextObjectiveStoreKey)entry.getKey()).deviceId().equals((Object)device.id())).forEach(entry -> this.nsNextObjStore.remove(entry.getKey()));
        this.vlanNextObjStore.entrySet().stream().filter(entry -> ((VlanNextObjectiveStoreKey)entry.getKey()).deviceId().equals((Object)device.id())).forEach(entry -> this.vlanNextObjStore.remove(entry.getKey()));
        this.portNextObjStore.entrySet().stream().filter(entry -> ((PortNextObjectiveStoreKey)entry.getKey()).deviceId().equals((Object)device.id())).forEach(entry -> this.portNextObjStore.remove(entry.getKey()));
        this.groupHandlerMap.remove(device.id());
        this.defaultRoutingHandler.purgeEcmpGraph(device.id());
        this.mcastHandler.removeDevice(device.id());
        this.xConnectHandler.removeDevice(device.id());
    }

    private void processPortUpdated(Device device, Port port) {
        if (this.deviceConfiguration == null || !this.deviceConfiguration.isConfigured(device.id())) {
            log.warn("Device configuration uploading. Not handling port event fordev: {} port: {}", (Object)device.id(), (Object)port.number());
            return;
        }
        if (!this.mastershipService.isLocalMaster(device.id())) {
            log.debug("Not master for dev:{} .. not handling port updated eventfor port {}", (Object)device.id(), (Object)port.number());
            return;
        }
        if (port.isEnabled()) {
            log.info("Switchport {}/{} enabled..programming filters", (Object)device.id(), (Object)port.number());
            this.routingRulePopulator.processSinglePortFilters(device.id(), port.number(), true);
        } else {
            log.info("Switchport {}/{} disabled..removing filters", (Object)device.id(), (Object)port.number());
            this.routingRulePopulator.processSinglePortFilters(device.id(), port.number(), false);
        }
        ConnectPoint cp = new ConnectPoint((ElementId)device.id(), port.number());
        VlanId untaggedVlan = this.getUntaggedVlanId(cp);
        VlanId nativeVlan = this.getNativeVlanId(cp);
        Set<VlanId> taggedVlans = this.getTaggedVlanId(cp);
        if (untaggedVlan == null && nativeVlan == null && taggedVlans.isEmpty()) {
            log.debug("Not handling port updated event for unconfigured port dev/port: {}/{}", (Object)device.id(), (Object)port.number());
            return;
        }
        if (untaggedVlan != null) {
            this.processEdgePort(device, port, untaggedVlan, true);
        }
        if (nativeVlan != null) {
            this.processEdgePort(device, port, nativeVlan, true);
        }
        if (!taggedVlans.isEmpty()) {
            taggedVlans.forEach(tag -> this.processEdgePort(device, port, (VlanId)tag, false));
        }
    }

    private void processEdgePort(Device device, Port port, VlanId vlanId, boolean popVlan) {
        boolean portUp = port.isEnabled();
        if (portUp) {
            log.info("Device:EdgePort {}:{} is enabled in vlan: {}", new Object[]{device.id(), port.number(), vlanId});
        } else {
            log.info("Device:EdgePort {}:{} is disabled in vlan: {}", new Object[]{device.id(), port.number(), vlanId});
        }
        DefaultGroupHandler groupHandler = this.groupHandlerMap.get(device.id());
        if (groupHandler != null) {
            groupHandler.processEdgePort(port.number(), vlanId, popVlan, portUp);
        } else {
            log.warn("Group handler not found for dev:{}. Not handling edge port {} event for port:{}", new Object[]{device.id(), portUp ? "UP" : "DOWN", port.number()});
        }
    }

    public void registerConnectPoint(ConnectPoint portToRegister) {
        this.neighbourResolutionService.registerNeighbourHandler(portToRegister, (NeighbourMessageHandler)this.neighbourHandler, this.appId);
    }

    protected void bindCompCfgService(ComponentConfigService componentConfigService) {
        this.compCfgService = componentConfigService;
    }

    protected void unbindCompCfgService(ComponentConfigService componentConfigService) {
        if (this.compCfgService == componentConfigService) {
            this.compCfgService = null;
        }
    }

    protected void bindNeighbourResolutionService(NeighbourResolutionService neighbourResolutionService) {
        this.neighbourResolutionService = neighbourResolutionService;
    }

    protected void unbindNeighbourResolutionService(NeighbourResolutionService neighbourResolutionService) {
        if (this.neighbourResolutionService == neighbourResolutionService) {
            this.neighbourResolutionService = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindMulticastRouteService(MulticastRouteService multicastRouteService) {
        this.multicastRouteService = multicastRouteService;
    }

    protected void unbindMulticastRouteService(MulticastRouteService multicastRouteService) {
        if (this.multicastRouteService == multicastRouteService) {
            this.multicastRouteService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindRouteService(RouteService routeService) {
        this.routeService = routeService;
    }

    protected void unbindRouteService(RouteService routeService) {
        if (this.routeService == routeService) {
            this.routeService = null;
        }
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    private class InternalRouteEventListener
    implements RouteListener {
        private InternalRouteEventListener() {
        }

        public void event(RouteEvent event) {
            switch ((RouteEvent.Type)event.type()) {
                case ROUTE_ADDED: {
                    SegmentRoutingManager.this.routeHandler.processRouteAdded(event);
                    break;
                }
                case ROUTE_UPDATED: {
                    SegmentRoutingManager.this.routeHandler.processRouteUpdated(event);
                    break;
                }
                case ROUTE_REMOVED: {
                    SegmentRoutingManager.this.routeHandler.processRouteRemoved(event);
                    break;
                }
            }
        }
    }

    private class InternalMcastListener
    implements McastListener {
        private InternalMcastListener() {
        }

        public void event(McastEvent event) {
            switch ((McastEvent.Type)event.type()) {
                case SOURCE_ADDED: {
                    SegmentRoutingManager.this.mcastHandler.processSourceAdded(event);
                    break;
                }
                case SINK_ADDED: {
                    SegmentRoutingManager.this.mcastHandler.processSinkAdded(event);
                    break;
                }
                case SINK_REMOVED: {
                    SegmentRoutingManager.this.mcastHandler.processSinkRemoved(event);
                    break;
                }
            }
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            DeviceId deviceId = ((Host)event.subject()).location().deviceId();
            if (!SegmentRoutingManager.this.mastershipService.isLocalMaster(deviceId)) {
                return;
            }
            switch ((HostEvent.Type)event.type()) {
                case HOST_ADDED: {
                    SegmentRoutingManager.this.hostHandler.processHostAddedEvent(event);
                    break;
                }
                case HOST_MOVED: {
                    SegmentRoutingManager.this.hostHandler.processHostMovedEvent(event);
                    break;
                }
                case HOST_REMOVED: {
                    SegmentRoutingManager.this.hostHandler.processHostRemoveEvent(event);
                    break;
                }
                case HOST_UPDATED: {
                    SegmentRoutingManager.this.hostHandler.processHostUpdatedEvent(event);
                    break;
                }
                default: {
                    log.warn("Unsupported host event type: {}", (Object)event.type());
                }
            }
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        SegmentRoutingManager srManager;

        public InternalConfigListener(SegmentRoutingManager srManager) {
            this.srManager = srManager;
        }

        public void configureNetwork() {
            SegmentRoutingManager.this.deviceConfiguration = new DeviceConfiguration(this.srManager);
            SegmentRoutingManager.this.arpHandler = new ArpHandler(this.srManager);
            SegmentRoutingManager.this.icmpHandler = new IcmpHandler(this.srManager);
            SegmentRoutingManager.this.ipHandler = new IpHandler(this.srManager);
            SegmentRoutingManager.this.routingRulePopulator = new RoutingRulePopulator(this.srManager);
            SegmentRoutingManager.this.defaultRoutingHandler = new DefaultRoutingHandler(this.srManager);
            SegmentRoutingManager.this.tunnelHandler = new TunnelHandler(SegmentRoutingManager.this.linkService, SegmentRoutingManager.this.deviceConfiguration, SegmentRoutingManager.this.groupHandlerMap, (EventuallyConsistentMap<String, Tunnel>)SegmentRoutingManager.this.tunnelStore);
            SegmentRoutingManager.this.policyHandler = new PolicyHandler(SegmentRoutingManager.this.appId, SegmentRoutingManager.this.deviceConfiguration, SegmentRoutingManager.this.flowObjectiveService, SegmentRoutingManager.this.tunnelHandler, (EventuallyConsistentMap<String, Policy>)SegmentRoutingManager.this.policyStore);
            for (Device device : SegmentRoutingManager.this.deviceService.getDevices()) {
                SegmentRoutingManager.this.processDeviceAdded(device);
            }
            SegmentRoutingManager.this.defaultRoutingHandler.startPopulationProcess();
            SegmentRoutingManager.this.mcastHandler.init();
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(SegmentRoutingDeviceConfig.class)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        log.info("Segment Routing Device Config added for {}", event.subject());
                        this.configureNetwork();
                        break;
                    }
                    case CONFIG_UPDATED: {
                        log.info("Segment Routing Config updated for {}", event.subject());
                        break;
                    }
                }
            } else if (event.configClass().equals(InterfaceConfig.class)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        log.info("Interface Config added for {}", event.subject());
                        this.configureNetwork();
                        break;
                    }
                    case CONFIG_UPDATED: {
                        log.info("Interface Config updated for {}", event.subject());
                        break;
                    }
                }
            } else if (event.configClass().equals(SegmentRoutingAppConfig.class)) {
                Preconditions.checkState((SegmentRoutingManager.this.appCfgHandler != null ? 1 : 0) != 0, (Object)"NetworkConfigEventHandler is not initialized");
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        SegmentRoutingManager.this.appCfgHandler.processAppConfigAdded(event);
                        break;
                    }
                    case CONFIG_UPDATED: {
                        SegmentRoutingManager.this.appCfgHandler.processAppConfigUpdated(event);
                        break;
                    }
                    case CONFIG_REMOVED: {
                        SegmentRoutingManager.this.appCfgHandler.processAppConfigRemoved(event);
                        break;
                    }
                }
                this.configureNetwork();
            } else if (event.configClass().equals(XConnectConfig.class)) {
                Preconditions.checkState((SegmentRoutingManager.this.xConnectHandler != null ? 1 : 0) != 0, (Object)"XConnectHandler is not initialized");
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        SegmentRoutingManager.this.xConnectHandler.processXConnectConfigAdded(event);
                        break;
                    }
                    case CONFIG_UPDATED: {
                        SegmentRoutingManager.this.xConnectHandler.processXConnectConfigUpdated(event);
                        break;
                    }
                    case CONFIG_REMOVED: {
                        SegmentRoutingManager.this.xConnectHandler.processXConnectConfigRemoved(event);
                        break;
                    }
                }
            } else if (event.configClass().equals(PwaasConfig.class)) {
                Preconditions.checkState((SegmentRoutingManager.this.l2TunnelHandler != null ? 1 : 0) != 0, (Object)"L2TunnelHandler is not initialized");
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: {
                        SegmentRoutingManager.this.l2TunnelHandler.processPwaasConfigAdded(event);
                        break;
                    }
                    case CONFIG_UPDATED: {
                        SegmentRoutingManager.this.l2TunnelHandler.processPwaasConfigUpdated(event);
                        break;
                    }
                    case CONFIG_REMOVED: {
                        SegmentRoutingManager.this.l2TunnelHandler.processPwaasConfigRemoved(event);
                        break;
                    }
                }
            }
        }
    }

    private class InternalEventHandler
    implements Runnable {
        private InternalEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Event event = null;
                    Object object = SegmentRoutingManager.this.threadSchedulerLock;
                    synchronized (object) {
                        if (SegmentRoutingManager.this.eventQueue.isEmpty()) {
                            numOfHandlerExecution++;
                            log.debug("numOfHandlerExecution {} numOfEventsExecuted {}", (Object)numOfHandlerExecution, (Object)numOfEventsExecuted);
                            break;
                        }
                        event = (Event)SegmentRoutingManager.this.eventQueue.poll();
                        numOfEventsExecuted++;
                    }
                    if (event.type() == LinkEvent.Type.LINK_ADDED || event.type() == LinkEvent.Type.LINK_UPDATED) {
                        SegmentRoutingManager.this.processLinkAdded((Link)event.subject());
                        continue;
                    }
                    if (event.type() == LinkEvent.Type.LINK_REMOVED) {
                        Link linkRemoved = (Link)event.subject();
                        if (linkRemoved.src().elementId() instanceof DeviceId && !SegmentRoutingManager.this.deviceService.isAvailable(linkRemoved.src().deviceId()) || linkRemoved.dst().elementId() instanceof DeviceId && !SegmentRoutingManager.this.deviceService.isAvailable(linkRemoved.dst().deviceId())) continue;
                        SegmentRoutingManager.this.processLinkRemoved((Link)event.subject());
                        continue;
                    }
                    if (event.type() == DeviceEvent.Type.DEVICE_ADDED || event.type() == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED || event.type() == DeviceEvent.Type.DEVICE_UPDATED) {
                        DeviceId deviceId = ((Device)event.subject()).id();
                        if (SegmentRoutingManager.this.deviceService.isAvailable(deviceId)) {
                            log.info("Processing device event {} for available device {}", (Object)event.type(), (Object)((Device)event.subject()).id());
                            SegmentRoutingManager.this.processDeviceAdded((Device)event.subject());
                            continue;
                        }
                        log.info("Processing device event {} for unavailable device {}", (Object)event.type(), (Object)((Device)event.subject()).id());
                        SegmentRoutingManager.this.processDeviceRemoved((Device)event.subject());
                        continue;
                    }
                    if (event.type() == DeviceEvent.Type.PORT_ADDED) {
                        log.debug("** PORT ADDED {}/{} -> {}", new Object[]{((Device)((DeviceEvent)event).subject()).id(), ((DeviceEvent)event).port().number(), event.type()});
                        continue;
                    }
                    if (event.type() == DeviceEvent.Type.PORT_UPDATED) {
                        log.info("** PORT UPDATED {}/{} -> {}", new Object[]{event.subject(), ((DeviceEvent)event).port(), event.type()});
                        SegmentRoutingManager.this.processPortUpdated((Device)event.subject(), ((DeviceEvent)event).port());
                        continue;
                    }
                    log.warn("Unhandled event type: {}", (Object)event.type());
                }
            }
            catch (Exception e) {
                log.error("SegmentRouting event handler thread thrown an exception: {}", (Throwable)e);
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case PORT_UPDATED: 
                case PORT_ADDED: 
                case DEVICE_UPDATED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    log.debug("Event {} received from Device Service", (Object)event.type());
                    SegmentRoutingManager.this.scheduleEventHandlerIfNotScheduled((Event)event);
                    break;
                }
            }
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            if (event.type() == LinkEvent.Type.LINK_ADDED || event.type() == LinkEvent.Type.LINK_UPDATED || event.type() == LinkEvent.Type.LINK_REMOVED) {
                log.debug("Event {} received from Link Service", (Object)event.type());
                SegmentRoutingManager.this.scheduleEventHandlerIfNotScheduled((Event)event);
            }
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            IPv6 ipv6Packet;
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethernet = pkt.parsed();
            if (ethernet == null) {
                return;
            }
            log.trace("Rcvd pktin: {}", (Object)ethernet);
            if (ethernet.getEtherType() == Ethernet.TYPE_ARP) {
                log.warn("Received unexpected ARP packet on {}", (Object)context.inPacket().receivedFrom());
                log.trace("{}", (Object)ethernet);
                return;
            }
            if (ethernet.getEtherType() == Ethernet.TYPE_IPV4) {
                IPv4 ipv4Packet = (IPv4)ethernet.getPayload();
                if (ipv4Packet.getProtocol() == 1) {
                    SegmentRoutingManager.this.icmpHandler.processIcmp(ethernet, pkt.receivedFrom());
                }
            } else if (ethernet.getEtherType() == Ethernet.TYPE_IPV6 && (ipv6Packet = (IPv6)ethernet.getPayload()).getNextHeader() == 58) {
                ICMP6 icmp6Packet = (ICMP6)ipv6Packet.getPayload();
                if (icmp6Packet.getIcmpType() == -128 || icmp6Packet.getIcmpType() == -127) {
                    SegmentRoutingManager.this.icmpHandler.processIcmpv6(ethernet, pkt.receivedFrom());
                } else {
                    log.debug("Received ICMPv6 0x{} - not handled", (Object)Integer.toHexString(icmp6Packet.getIcmpType() & 0xFF));
                }
            }
        }
    }
}

