/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.segmentrouting.DefaultRoutingHandler;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.onosproject.segmentrouting.grouphandler.NeighborSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingRulePopulator {
    private static final Logger log = LoggerFactory.getLogger(RoutingRulePopulator.class);
    private AtomicLong rulePopulationCounter;
    private SegmentRoutingManager srManager;
    private DeviceConfiguration config;

    public RoutingRulePopulator(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.config = (DeviceConfiguration)Preconditions.checkNotNull((Object)srManager.deviceConfiguration);
        this.rulePopulationCounter = new AtomicLong(0L);
    }

    public void resetCounter() {
        this.rulePopulationCounter.set(0L);
    }

    public long getCounter() {
        return this.rulePopulationCounter.get();
    }

    public void populateRoute(DeviceId deviceId, IpPrefix prefix, MacAddress hostMac, VlanId hostVlanId, PortNumber outPort) {
        ForwardingObjective.Builder fwdBuilder;
        log.debug("Populate routing entry for route {} at {}:{}", new Object[]{prefix, deviceId, outPort});
        try {
            fwdBuilder = this.routingFwdObjBuilder(deviceId, prefix, hostMac, hostVlanId, outPort, false);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting populateIpRuleForHost.");
            return;
        }
        if (fwdBuilder == null) {
            log.warn("Aborting host routing table entry due to error for dev:{} route:{}", (Object)deviceId, (Object)prefix);
            return;
        }
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Routing rule for route {} populated", (Object)prefix), (objective, error) -> log.warn("Failed to populate routing rule for route {}: {}", (Object)prefix, error));
        this.srManager.flowObjectiveService.forward(deviceId, fwdBuilder.add((ObjectiveContext)context));
        this.rulePopulationCounter.incrementAndGet();
    }

    public void revokeRoute(DeviceId deviceId, IpPrefix prefix, MacAddress hostMac, VlanId hostVlanId, PortNumber outPort) {
        ForwardingObjective.Builder fwdBuilder;
        log.debug("Revoke IP table entry for route {} at {}:{}", new Object[]{prefix, deviceId, outPort});
        try {
            fwdBuilder = this.routingFwdObjBuilder(deviceId, prefix, hostMac, hostVlanId, outPort, true);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting revokeIpRuleForHost.");
            return;
        }
        if (fwdBuilder == null) {
            log.warn("Aborting host routing table entries due to error for dev:{} route:{}", (Object)deviceId, (Object)prefix);
            return;
        }
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("IP rule for route {} revoked", (Object)prefix), (objective, error) -> log.warn("Failed to revoke IP rule for route {}: {}", (Object)prefix, error));
        this.srManager.flowObjectiveService.forward(deviceId, fwdBuilder.remove((ObjectiveContext)context));
    }

    private ForwardingObjective.Builder routingFwdObjBuilder(DeviceId deviceId, IpPrefix prefix, MacAddress hostMac, VlanId hostVlanId, PortNumber outPort, boolean revoke) throws DeviceConfigNotFoundException {
        MacAddress deviceMac = this.config.getDeviceMac(deviceId);
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, outPort);
        VlanId untaggedVlan = this.srManager.getUntaggedVlanId(connectPoint);
        Set<VlanId> taggedVlans = this.srManager.getTaggedVlanId(connectPoint);
        VlanId nativeVlan = this.srManager.getNativeVlanId(connectPoint);
        TrafficSelector.Builder sbuilder = this.buildIpSelectorFromIpPrefix(prefix);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        tbuilder.deferred().setEthDst(hostMac).setEthSrc(deviceMac).setOutput(outPort);
        TrafficSelector.Builder mbuilder = DefaultTrafficSelector.builder();
        if (taggedVlans.contains(hostVlanId)) {
            tbuilder.setVlanId(hostVlanId);
        } else if (hostVlanId.equals((Object)VlanId.NONE)) {
            if (untaggedVlan != null) {
                mbuilder.matchVlanId(untaggedVlan);
            } else if (nativeVlan != null) {
                mbuilder.matchVlanId(nativeVlan);
            } else {
                mbuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
            }
        } else {
            log.warn("Tagged nexthop {}/{} is not allowed on {} without VLAN listed in tagged vlan", new Object[]{hostMac, hostVlanId, connectPoint});
            return null;
        }
        int portNextObjId = this.srManager.getPortNextObjectiveId(deviceId, outPort, tbuilder.build(), mbuilder.build(), !revoke);
        if (portNextObjId == -1) {
            return null;
        }
        return DefaultForwardingObjective.builder().withSelector(sbuilder.build()).nextStep(portNextObjId).fromApp(this.srManager.appId).makePermanent().withPriority(this.getPriorityFromPrefix(prefix)).withFlag(ForwardingObjective.Flag.SPECIFIC);
    }

    public boolean populateIpRuleForSubnet(DeviceId deviceId, Set<IpPrefix> subnets, DeviceId destSw, Set<DeviceId> nextHops) {
        for (IpPrefix subnet : subnets) {
            if (this.populateIpRuleForRouter(deviceId, subnet, destSw, nextHops)) continue;
            return false;
        }
        return true;
    }

    public boolean revokeIpRuleForSubnet(Set<IpPrefix> subnets) {
        for (IpPrefix subnet : subnets) {
            if (this.revokeIpRuleForRouter(subnet)) continue;
            return false;
        }
        return true;
    }

    public boolean populateIpRuleForRouter(DeviceId deviceId, IpPrefix ipPrefix, DeviceId destSw, Set<DeviceId> nextHops) {
        TrafficTreatment treatment;
        NeighborSet ns;
        int segmentId;
        try {
            segmentId = ipPrefix.isIp4() ? this.config.getIPv4SegmentId(destSw) : this.config.getIPv6SegmentId(destSw);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting populateIpRuleForRouter.");
            return false;
        }
        TrafficSelector.Builder sbuilder = this.buildIpSelectorFromIpPrefix(ipPrefix);
        TrafficSelector selector = sbuilder.build();
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        if (nextHops.size() == 1 && nextHops.toArray()[0].equals(destSw)) {
            tbuilder.immediate().decNwTtl();
            ns = new NeighborSet(nextHops, false);
            treatment = tbuilder.build();
        } else {
            ns = new NeighborSet(nextHops, false, segmentId);
            treatment = null;
        }
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder((TrafficSelector)selector);
        metabuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
        int nextId = this.srManager.getNextObjectiveId(deviceId, ns, metabuilder.build());
        if (nextId <= 0) {
            log.warn("No next objective in {} for ns: {}", (Object)deviceId, (Object)ns);
            return false;
        }
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.srManager.appId).makePermanent().nextStep(nextId).withSelector(selector).withPriority(this.getPriorityFromPrefix(ipPrefix)).withFlag(ForwardingObjective.Flag.SPECIFIC);
        if (treatment != null) {
            fwdBuilder.withTreatment(treatment);
        }
        log.debug("Installing IPv4 forwarding objective for router IP/subnet {} in switch {}", (Object)ipPrefix, (Object)deviceId);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("IP rule for router {} populated in dev:{}", (Object)ipPrefix, (Object)deviceId), (objective, error) -> log.warn("Failed to populate IP rule for router {}: {} in dev:{}", new Object[]{ipPrefix, error, deviceId}));
        this.srManager.flowObjectiveService.forward(deviceId, fwdBuilder.add((ObjectiveContext)context));
        this.rulePopulationCounter.incrementAndGet();
        return true;
    }

    public boolean revokeIpRuleForRouter(IpPrefix ipPrefix) {
        TrafficSelector.Builder sbuilder = this.buildIpSelectorFromIpPrefix(ipPrefix);
        TrafficSelector selector = sbuilder.build();
        TrafficTreatment dummyTreatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.srManager.appId).makePermanent().withSelector(selector).withTreatment(dummyTreatment).withPriority(this.getPriorityFromPrefix(ipPrefix)).withFlag(ForwardingObjective.Flag.SPECIFIC);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("IP rule for router {} revoked", (Object)ipPrefix), (objective, error) -> log.warn("Failed to revoke IP rule for router {}: {}", (Object)ipPrefix, error));
        this.srManager.deviceService.getAvailableDevices().forEach(arg_0 -> this.lambda$revokeIpRuleForRouter$8((ForwardingObjective.Builder)fwdBuilder, (ObjectiveContext)context, arg_0));
        return true;
    }

    private Collection<ForwardingObjective> handleMpls(DeviceId targetSwId, DeviceId destSwId, Set<DeviceId> nextHops, int segmentId, IpAddress routerIp, boolean isMplsBos) {
        ForwardingObjective.Builder fwdObjNoBosBuilder;
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        ArrayList fwdObjBuilders = Lists.newArrayList();
        sbuilder.matchEthType(Ethernet.MPLS_UNICAST);
        sbuilder.matchMplsLabel(MplsLabel.mplsLabel((int)segmentId));
        sbuilder.matchMplsBos(isMplsBos);
        TrafficSelector selector = sbuilder.build();
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder((TrafficSelector)selector);
        metabuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
        if (nextHops.size() == 1 && destSwId.equals(nextHops.toArray()[0])) {
            log.debug("populateMplsRule: Installing MPLS forwarding objective for label {} in switch {} with pop", (Object)segmentId, (Object)targetSwId);
            fwdObjNoBosBuilder = this.getMplsForwardingObjective(targetSwId, nextHops, true, isMplsBos, metabuilder.build(), routerIp);
            if (fwdObjNoBosBuilder == null) {
                return Collections.emptyList();
            }
            fwdObjBuilders.add(fwdObjNoBosBuilder);
        } else {
            log.debug("Installing MPLS forwarding objective for label {} in switch {} without pop", (Object)segmentId, (Object)targetSwId);
            fwdObjNoBosBuilder = this.getMplsForwardingObjective(targetSwId, nextHops, false, isMplsBos, metabuilder.build(), routerIp);
            if (fwdObjNoBosBuilder == null) {
                return Collections.emptyList();
            }
            fwdObjBuilders.add(fwdObjNoBosBuilder);
        }
        ArrayList fwdObjs = Lists.newArrayList();
        for (ForwardingObjective.Builder fwdObjBuilder : fwdObjBuilders) {
            ((ForwardingObjective.Builder)((ForwardingObjective.Builder)fwdObjBuilder.fromApp(this.srManager.appId).makePermanent()).withSelector(selector).withPriority(100)).withFlag(ForwardingObjective.Flag.SPECIFIC);
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("MPLS rule {} for SID {} populated in dev:{} ", new Object[]{objective.id(), segmentId, targetSwId}), (objective, error) -> log.warn("Failed to populate MPLS rule {} for SID {}: {} in dev:{}", new Object[]{objective.id(), segmentId, error, targetSwId}));
            ForwardingObjective fob = fwdObjBuilder.add((ObjectiveContext)context);
            fwdObjs.add(fob);
        }
        return fwdObjs;
    }

    public boolean populateMplsRule(DeviceId targetSwId, DeviceId destSwId, Set<DeviceId> nextHops, IpAddress routerIp) {
        int segmentId;
        try {
            segmentId = routerIp.isIp4() ? this.config.getIPv4SegmentId(destSwId) : this.config.getIPv6SegmentId(destSwId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting populateMplsRule.");
            return false;
        }
        ArrayList<Object> fwdObjs = new ArrayList<Object>();
        Collection<Object> fwdObjsMpls = Collections.emptyList();
        fwdObjsMpls = this.handleMpls(targetSwId, destSwId, nextHops, segmentId, routerIp, true);
        if (fwdObjsMpls.isEmpty()) {
            return false;
        }
        fwdObjs.addAll(fwdObjsMpls);
        for (ForwardingObjective forwardingObjective : fwdObjs) {
            log.debug("Sending MPLS fwd obj {} for SID {}-> next {} in sw: {}", new Object[]{forwardingObjective.id(), segmentId, forwardingObjective.nextId(), targetSwId});
            this.srManager.flowObjectiveService.forward(targetSwId, forwardingObjective);
            this.rulePopulationCounter.incrementAndGet();
        }
        return true;
    }

    private ForwardingObjective.Builder getMplsForwardingObjective(DeviceId deviceId, Set<DeviceId> nextHops, boolean phpRequired, boolean isBos, TrafficSelector meta, IpAddress routerIp) {
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.SPECIFIC);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        if (phpRequired) {
            log.debug("getMplsForwardingObjective: php required");
            tbuilder.deferred().copyTtlIn();
            if (isBos) {
                if (routerIp.isIp4()) {
                    tbuilder.deferred().popMpls(EthType.EtherType.IPV4.ethType());
                } else {
                    tbuilder.deferred().popMpls(EthType.EtherType.IPV6.ethType());
                }
                tbuilder.decNwTtl();
            } else {
                tbuilder.deferred().popMpls(EthType.EtherType.MPLS_UNICAST.ethType()).decMplsTtl();
            }
        } else {
            log.debug("getMplsForwardingObjective: php not required");
            tbuilder.deferred().decMplsTtl();
        }
        fwdBuilder.withTreatment(tbuilder.build());
        NeighborSet ns = NeighborSet.neighborSet(false, nextHops, false);
        if (!isBos && this.srManager.getMplsEcmp()) {
            ns = NeighborSet.neighborSet(false, nextHops, true);
        } else if (!isBos && !this.srManager.getMplsEcmp()) {
            ns = NeighborSet.neighborSet(true, nextHops, true);
        }
        log.debug("Trying to get a nextObjId for mpls rule on device:{} to ns:{}", (Object)deviceId, (Object)ns);
        int nextId = this.srManager.getNextObjectiveId(deviceId, ns, meta, isBos);
        if (nextId <= 0) {
            log.warn("No next objective in {} for ns: {}", (Object)deviceId, (Object)ns);
            return null;
        }
        log.debug("nextObjId found:{} for mpls rule on device:{} to ns:{}", new Object[]{nextId, deviceId, ns});
        fwdBuilder.nextStep(nextId);
        return fwdBuilder;
    }

    public DefaultRoutingHandler.PortFilterInfo populateVlanMacFilters(DeviceId deviceId) {
        log.debug("Installing per-port filtering objective for untagged packets in device {}", (Object)deviceId);
        List devPorts = this.srManager.deviceService.getPorts(deviceId);
        if (devPorts == null || devPorts.isEmpty()) {
            log.warn("Device {} ports not available. Unable to add MacVlan filters", (Object)deviceId);
            return null;
        }
        int disabledPorts = 0;
        int errorPorts = 0;
        int filteredPorts = 0;
        for (Port port : devPorts) {
            if (!port.isEnabled()) {
                ++disabledPorts;
                continue;
            }
            if (this.processSinglePortFilters(deviceId, port.number(), true)) {
                ++filteredPorts;
                continue;
            }
            ++errorPorts;
        }
        log.debug("Filtering on dev:{}, disabledPorts:{}, errorPorts:{}, filteredPorts:{}", new Object[]{deviceId, disabledPorts, errorPorts, filteredPorts});
        DefaultRoutingHandler defaultRoutingHandler = this.srManager.defaultRoutingHandler;
        defaultRoutingHandler.getClass();
        return defaultRoutingHandler.new DefaultRoutingHandler.PortFilterInfo(disabledPorts, errorPorts, filteredPorts);
    }

    public boolean processSinglePortFilters(DeviceId deviceId, PortNumber portnum, boolean install) {
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, portnum);
        VlanId untaggedVlan = this.srManager.getUntaggedVlanId(connectPoint);
        Set<VlanId> taggedVlans = this.srManager.getTaggedVlanId(connectPoint);
        VlanId nativeVlan = this.srManager.getNativeVlanId(connectPoint);
        if (taggedVlans.size() != 0) {
            if (!this.srManager.getTaggedVlanId(connectPoint).stream().allMatch(taggedVlanId -> this.processSinglePortFiltersInternal(deviceId, portnum, false, (VlanId)taggedVlanId, install))) {
                return false;
            }
            if (nativeVlan != null && !this.processSinglePortFiltersInternal(deviceId, portnum, true, nativeVlan, install)) {
                return false;
            }
        } else if (untaggedVlan != null ? !this.processSinglePortFiltersInternal(deviceId, portnum, true, untaggedVlan, install) : !this.processSinglePortFiltersInternal(deviceId, portnum, true, SegmentRoutingManager.INTERNAL_VLAN, install)) {
            return false;
        }
        return true;
    }

    private boolean processSinglePortFiltersInternal(DeviceId deviceId, PortNumber portnum, boolean pushVlan, VlanId vlanId, boolean install) {
        FilteringObjective.Builder fob = this.buildFilteringObjective(deviceId, portnum, pushVlan, vlanId);
        if (fob == null) {
            return false;
        }
        log.info("{} filtering objectives for dev/port:{}/{}", new Object[]{install ? "Installing" : "Removing", deviceId, portnum});
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Filter for {}/{} {}", new Object[]{deviceId, portnum, install ? "installed" : "removed"}), (objective, error) -> log.warn("Failed to {} filter for {}/{}: {}", new Object[]{install ? "install" : "remove", deviceId, portnum, error}));
        if (install) {
            this.srManager.flowObjectiveService.filter(deviceId, fob.add((ObjectiveContext)context));
        } else {
            this.srManager.flowObjectiveService.filter(deviceId, fob.remove((ObjectiveContext)context));
        }
        return true;
    }

    private FilteringObjective.Builder buildFilteringObjective(DeviceId deviceId, PortNumber portnum, boolean pushVlan, VlanId vlanId) {
        MacAddress deviceMac;
        try {
            deviceMac = this.config.getDeviceMac(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Processing SinglePortFilters aborted");
            return null;
        }
        DefaultFilteringObjective.Builder fob = DefaultFilteringObjective.builder();
        fob.withKey(Criteria.matchInPort((PortNumber)portnum)).addCondition(Criteria.matchEthDst((MacAddress)deviceMac)).withPriority(100);
        if (pushVlan) {
            fob.addCondition(Criteria.matchVlanId((VlanId)VlanId.NONE));
            TrafficTreatment tt = DefaultTrafficTreatment.builder().pushVlan().setVlanId(vlanId).build();
            fob.withMeta(tt);
        } else {
            fob.addCondition(Criteria.matchVlanId((VlanId)vlanId));
        }
        fob.permit().fromApp(this.srManager.appId);
        return fob;
    }

    public void populateIpPunts(DeviceId deviceId) {
        Ip6Address routerIpv6;
        Ip4Address routerIpv4;
        try {
            routerIpv4 = this.config.getRouterIpv4(deviceId);
            routerIpv6 = this.config.getRouterIpv6(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting populateIpPunts.");
            return;
        }
        if (!this.srManager.mastershipService.isLocalMaster(deviceId)) {
            log.debug("Not installing port-IP punts - not the master for dev:{} ", (Object)deviceId);
            return;
        }
        HashSet<IpAddress> allIps = new HashSet<IpAddress>(this.config.getPortIPs(deviceId));
        allIps.add((IpAddress)routerIpv4);
        if (routerIpv6 != null) {
            allIps.add((IpAddress)routerIpv6);
        }
        for (IpAddress ipaddr : allIps) {
            TrafficSelector.Builder sbuilder = this.buildIpSelectorFromIpAddress(ipaddr);
            Optional<DeviceId> optDeviceId = Optional.of(deviceId);
            this.srManager.packetService.requestPackets(sbuilder.build(), PacketPriority.CONTROL, this.srManager.appId, optDeviceId);
        }
    }

    private TrafficSelector.Builder buildIpSelectorFromIpAddress(IpAddress addressToMatch) {
        return this.buildIpSelectorFromIpPrefix(addressToMatch.toIpPrefix());
    }

    private TrafficSelector.Builder buildIpSelectorFromIpPrefix(IpPrefix prefixToMatch) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (prefixToMatch.isIp4()) {
            selectorBuilder.matchEthType(Ethernet.TYPE_IPV4);
            selectorBuilder.matchIPDst((IpPrefix)prefixToMatch.getIp4Prefix());
            return selectorBuilder;
        }
        selectorBuilder.matchEthType(Ethernet.TYPE_IPV6);
        selectorBuilder.matchIPv6Dst((IpPrefix)prefixToMatch.getIp6Prefix());
        return selectorBuilder;
    }

    public void populateArpNdpPunts(final DeviceId deviceId) {
        if (!this.srManager.mastershipService.isLocalMaster(deviceId)) {
            log.debug("Not installing ARP/NDP punts - not the master for dev:{} ", (Object)deviceId);
            return;
        }
        ForwardingObjective puntFwd = this.puntArpFwdObjective().add(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to install packet request for ARP to {}: {}", (Object)deviceId, (Object)error);
            }
        });
        this.srManager.flowObjectiveService.forward(deviceId, puntFwd);
        puntFwd = this.puntNdpFwdObjective().add(new ObjectiveContext(){

            public void onError(Objective objective, ObjectiveError error) {
                log.warn("Failed to install packet request for NDP to {}: {}", (Object)deviceId, (Object)error);
            }
        });
        this.srManager.flowObjectiveService.forward(deviceId, puntFwd);
    }

    private ForwardingObjective.Builder fwdObjBuilder(TrafficSelector selector) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        tBuilder.punt();
        return DefaultForwardingObjective.builder().withPriority(PacketPriority.CONTROL.priorityValue()).withSelector(selector).fromApp(this.srManager.appId).withFlag(ForwardingObjective.Flag.VERSATILE).withTreatment(tBuilder.build()).makePermanent();
    }

    private ForwardingObjective.Builder puntArpFwdObjective() {
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        sBuilder.matchEthType(Ethernet.TYPE_ARP);
        return this.fwdObjBuilder(sBuilder.build());
    }

    private ForwardingObjective.Builder puntNdpFwdObjective() {
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        sBuilder.matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type((byte)-121).build();
        return this.fwdObjBuilder(sBuilder.build());
    }

    public void populateSubnetBroadcastRule(DeviceId deviceId) {
        this.srManager.getVlanPortMap(deviceId).asMap().forEach((vlanId, ports) -> {
            int nextId = this.srManager.getVlanNextObjectiveId(deviceId, (VlanId)vlanId);
            if (nextId < 0) {
                log.error("Cannot install vlan {} broadcast rule in dev:{} dueto vlanId:{} or nextId:{}", new Object[]{vlanId, deviceId, vlanId, nextId});
                return;
            }
            TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
            sbuilder.matchVlanId(vlanId);
            sbuilder.matchEthDst(MacAddress.NONE);
            DefaultForwardingObjective.Builder fob = DefaultForwardingObjective.builder();
            fob.withFlag(ForwardingObjective.Flag.SPECIFIC).withSelector(sbuilder.build()).nextStep(nextId).withPriority(5).fromApp(this.srManager.appId).makePermanent();
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Vlan broadcast rule for {} populated", vlanId), (objective, error) -> log.warn("Failed to populate vlan broadcast rule for {}: {}", vlanId, error));
            this.srManager.flowObjectiveService.forward(deviceId, fob.add((ObjectiveContext)context));
        });
    }

    private int getPriorityFromPrefix(IpPrefix prefix) {
        return prefix.isIp4() ? 2000 * prefix.prefixLength() + 10 : 500 * prefix.prefixLength() + 10;
    }

    private /* synthetic */ void lambda$revokeIpRuleForRouter$8(ForwardingObjective.Builder fwdBuilder, ObjectiveContext context, Device device) {
        this.srManager.flowObjectiveService.forward(device.id(), fwdBuilder.remove(context));
    }
}

