/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.incubator.net.routing.RouteEvent;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(RouteHandler.class);
    private final SegmentRoutingManager srManager;

    public RouteHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
    }

    protected void init(DeviceId deviceId) {
        this.srManager.routeService.getRouteTables().forEach(routeTableId -> this.srManager.routeService.getRoutes(routeTableId).forEach(routeInfo -> routeInfo.allRoutes().stream().filter(resolvedRoute -> resolvedRoute.location() != null && resolvedRoute.location().deviceId().equals((Object)deviceId)).forEach(this::processRouteAddedInternal)));
    }

    protected void processRouteAdded(RouteEvent event) {
        log.info("processRouteAdded {}", (Object)event);
        this.processRouteAddedInternal((ResolvedRoute)event.subject());
    }

    private void processRouteAddedInternal(ResolvedRoute route) {
        if (!this.isReady()) {
            log.info("System is not ready. Skip adding route for {}", (Object)route.prefix());
            return;
        }
        IpPrefix prefix = route.prefix();
        MacAddress nextHopMac = route.nextHopMac();
        VlanId nextHopVlan = route.nextHopVlan();
        ConnectPoint location = route.location();
        this.srManager.deviceConfiguration.addSubnet(location, prefix);
        this.srManager.defaultRoutingHandler.populateSubnet(location, (Set<IpPrefix>)ImmutableSet.of((Object)prefix));
        this.srManager.routingRulePopulator.populateRoute(location.deviceId(), prefix, nextHopMac, nextHopVlan, location.port());
    }

    protected void processRouteUpdated(RouteEvent event) {
        log.info("processRouteUpdated {}", (Object)event);
        this.processRouteRemovedInternal(event.prevSubject());
        this.processRouteAddedInternal((ResolvedRoute)event.subject());
    }

    protected void processRouteRemoved(RouteEvent event) {
        log.info("processRouteRemoved {}", (Object)event);
        this.processRouteRemovedInternal((ResolvedRoute)event.subject());
    }

    private void processRouteRemovedInternal(ResolvedRoute route) {
        if (!this.isReady()) {
            log.info("System is not ready. Skip removing route for {}", (Object)route.prefix());
            return;
        }
        IpPrefix prefix = route.prefix();
        MacAddress nextHopMac = route.nextHopMac();
        VlanId nextHopVlan = route.nextHopVlan();
        ConnectPoint location = route.location();
        this.srManager.deviceConfiguration.removeSubnet(location, prefix);
        this.srManager.defaultRoutingHandler.revokeSubnet((Set<IpPrefix>)ImmutableSet.of((Object)prefix));
        this.srManager.routingRulePopulator.revokeRoute(location.deviceId(), prefix, nextHopMac, nextHopVlan, location.port());
    }

    private boolean isReady() {
        return Objects.nonNull(this.srManager.deviceConfiguration) && Objects.nonNull(this.srManager.defaultRoutingHandler) && Objects.nonNull(this.srManager.routingRulePopulator);
    }
}

