/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import java.util.List;
import java.util.stream.Collectors;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TpPort;
import org.onosproject.cli.net.IpProtocol;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.segmentrouting.Policy;
import org.onosproject.segmentrouting.Tunnel;
import org.onosproject.segmentrouting.TunnelHandler;
import org.onosproject.segmentrouting.TunnelPolicy;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId appId;
    private DeviceConfiguration deviceConfiguration;
    private FlowObjectiveService flowObjectiveService;
    private TunnelHandler tunnelHandler;
    private final EventuallyConsistentMap<String, Policy> policyStore;

    public PolicyHandler(ApplicationId appId, DeviceConfiguration deviceConfiguration, FlowObjectiveService flowObjectiveService, TunnelHandler tunnelHandler, EventuallyConsistentMap<String, Policy> policyStore) {
        this.appId = appId;
        this.deviceConfiguration = deviceConfiguration;
        this.flowObjectiveService = flowObjectiveService;
        this.tunnelHandler = tunnelHandler;
        this.policyStore = policyStore;
    }

    public List<Policy> getPolicies() {
        return this.policyStore.values().stream().filter(policy -> policy instanceof TunnelPolicy).map(policy -> new TunnelPolicy((TunnelPolicy)policy)).collect(Collectors.toList());
    }

    public Result createPolicy(Policy policy) {
        Tunnel tunnel;
        TunnelPolicy tunnelPolicy;
        if (this.policyStore.containsKey((Object)policy.id())) {
            this.log.warn("The policy id {} exists already", (Object)policy.id());
            return Result.ID_EXISTS;
        }
        if (this.policyStore.containsValue((Object)policy)) {
            this.log.warn("The same policy exists already");
            return Result.POLICY_EXISTS;
        }
        if (policy.type() == Policy.Type.TUNNEL_FLOW) {
            tunnelPolicy = (TunnelPolicy)policy;
            tunnel = this.tunnelHandler.getTunnel(tunnelPolicy.tunnelId());
            if (tunnel == null) {
                return Result.TUNNEL_NOT_FOUND;
            }
        } else {
            this.log.warn("Policy type {} is not supported yet.", (Object)policy.type());
            return Result.UNSUPPORTED_TYPE;
        }
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().nextStep(tunnel.groupId()).withPriority(tunnelPolicy.priority()).withSelector(this.buildSelector(policy)).withFlag(ForwardingObjective.Flag.VERSATILE);
        DeviceId source = this.deviceConfiguration.getDeviceId(tunnel.labelIds().get(0));
        this.flowObjectiveService.forward(source, fwdBuilder.add());
        this.policyStore.put((Object)policy.id(), (Object)policy);
        return Result.SUCCESS;
    }

    public Result removePolicy(Policy policyInfo) {
        if (this.policyStore.get((Object)policyInfo.id()) != null) {
            Policy policy = (Policy)this.policyStore.get((Object)policyInfo.id());
            if (policy.type() == Policy.Type.TUNNEL_FLOW) {
                TunnelPolicy tunnelPolicy = (TunnelPolicy)policy;
                Tunnel tunnel = this.tunnelHandler.getTunnel(tunnelPolicy.tunnelId());
                DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder().fromApp(this.appId).makePermanent().withSelector(this.buildSelector(policy)).withPriority(tunnelPolicy.priority()).nextStep(tunnel.groupId()).withFlag(ForwardingObjective.Flag.VERSATILE);
                DeviceId source = this.deviceConfiguration.getDeviceId(tunnel.labelIds().get(0));
                this.flowObjectiveService.forward(source, fwdBuilder.remove());
                this.policyStore.remove((Object)policyInfo.id());
            }
        } else {
            this.log.warn("Policy {} was not found", (Object)policyInfo.id());
            return Result.POLICY_NOT_FOUND;
        }
        return Result.SUCCESS;
    }

    private TrafficSelector buildSelector(Policy policy) {
        TrafficSelector.Builder tsb = DefaultTrafficSelector.builder();
        tsb.matchEthType(Ethernet.TYPE_IPV4);
        if (policy.dstIp() != null && !policy.dstIp().isEmpty()) {
            tsb.matchIPDst(IpPrefix.valueOf((String)policy.dstIp()));
        }
        if (policy.srcIp() != null && !policy.srcIp().isEmpty()) {
            tsb.matchIPSrc(IpPrefix.valueOf((String)policy.srcIp()));
        }
        if (policy.ipProto() != null && !policy.ipProto().isEmpty()) {
            Short ipProto = IpProtocol.valueOf((String)policy.ipProto()).value();
            tsb.matchIPProtocol(ipProto.byteValue());
            if (IpProtocol.valueOf((String)policy.ipProto()).equals((Object)IpProtocol.TCP)) {
                if (policy.srcPort() != 0) {
                    tsb.matchTcpSrc(TpPort.tpPort((int)policy.srcPort()));
                }
                if (policy.dstPort() != 0) {
                    tsb.matchTcpDst(TpPort.tpPort((int)policy.dstPort()));
                }
            } else if (IpProtocol.valueOf((String)policy.ipProto()).equals((Object)IpProtocol.UDP)) {
                if (policy.srcPort() != 0) {
                    tsb.matchUdpSrc(TpPort.tpPort((int)policy.srcPort()));
                }
                if (policy.dstPort() != 0) {
                    tsb.matchUdpDst(TpPort.tpPort((int)policy.dstPort()));
                }
            }
        }
        return tsb.build();
    }

    public static enum Result {
        SUCCESS,
        POLICY_EXISTS,
        ID_EXISTS,
        TUNNEL_NOT_FOUND,
        POLICY_NOT_FOUND,
        UNSUPPORTED_TYPE;

    }
}

