/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.config.basics.McastConfig;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.onosproject.segmentrouting.storekey.McastStoreKey;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McastHandler {
    private static final Logger log = LoggerFactory.getLogger(McastHandler.class);
    private final SegmentRoutingManager srManager;
    private final ApplicationId coreAppId;
    private final StorageService storageService;
    private final TopologyService topologyService;
    private final ConsistentMap<McastStoreKey, NextObjective> mcastNextObjStore;
    private final KryoNamespace.Builder mcastKryo;
    private final ConsistentMap<McastStoreKey, McastRole> mcastRoleStore;

    public McastHandler(SegmentRoutingManager srManager) {
        this.coreAppId = srManager.coreService.getAppId("org.onosproject.core");
        this.srManager = srManager;
        this.storageService = srManager.storageService;
        this.topologyService = srManager.topologyService;
        this.mcastKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{McastStoreKey.class}).register(new Class[]{McastRole.class});
        this.mcastNextObjStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-mcast-nextobj-store")).withSerializer(Serializer.using((KryoNamespace)this.mcastKryo.build("McastHandler-NextObj")))).build();
        this.mcastRoleStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-mcast-role-store")).withSerializer(Serializer.using((KryoNamespace)this.mcastKryo.build("McastHandler-Role")))).build();
    }

    protected void init() {
        this.srManager.multicastRouteService.getRoutes().forEach(mcastRoute -> {
            ConnectPoint source = this.srManager.multicastRouteService.fetchSource(mcastRoute);
            Set sinks = this.srManager.multicastRouteService.fetchSinks(mcastRoute);
            sinks.forEach(sink -> this.processSinkAddedInternal(source, (ConnectPoint)sink, mcastRoute.group()));
        });
    }

    protected void processSourceAdded(McastEvent event) {
        log.info("processSourceAdded {}", (Object)event);
        McastRouteInfo mcastRouteInfo = (McastRouteInfo)event.subject();
        if (!mcastRouteInfo.isComplete()) {
            log.info("Incompleted McastRouteInfo. Abort.");
            return;
        }
        ConnectPoint source = mcastRouteInfo.source().orElse(null);
        Set sinks = mcastRouteInfo.sinks();
        IpAddress mcastIp = mcastRouteInfo.route().group();
        sinks.forEach(sink -> this.processSinkAddedInternal(source, (ConnectPoint)sink, mcastIp));
    }

    protected void processSinkAdded(McastEvent event) {
        log.info("processSinkAdded {}", (Object)event);
        McastRouteInfo mcastRouteInfo = (McastRouteInfo)event.subject();
        if (!mcastRouteInfo.isComplete()) {
            log.info("Incompleted McastRouteInfo. Abort.");
            return;
        }
        ConnectPoint source = mcastRouteInfo.source().orElse(null);
        ConnectPoint sink = mcastRouteInfo.sink().orElse(null);
        IpAddress mcastIp = mcastRouteInfo.route().group();
        this.processSinkAddedInternal(source, sink, mcastIp);
    }

    protected void processSinkRemoved(McastEvent event) {
        Optional<Path> mcastPath;
        log.info("processSinkRemoved {}", (Object)event);
        McastRouteInfo mcastRouteInfo = (McastRouteInfo)event.subject();
        if (!mcastRouteInfo.isComplete()) {
            log.info("Incompleted McastRouteInfo. Abort.");
            return;
        }
        ConnectPoint source = mcastRouteInfo.source().orElse(null);
        ConnectPoint sink = mcastRouteInfo.sink().orElse(null);
        IpAddress mcastIp = mcastRouteInfo.route().group();
        if (!this.srManager.mastershipService.isLocalMaster(source.deviceId())) {
            log.info("Skip {} due to lack of mastership of the source device {}", (Object)mcastIp, (Object)source.deviceId());
            return;
        }
        if (source.deviceId().equals((Object)sink.deviceId())) {
            if (source.port().equals((Object)sink.port())) {
                log.warn("Sink is on the same port of source. Abort");
                return;
            }
            this.removePortFromDevice(sink.deviceId(), sink.port(), mcastIp, this.assignedVlan(source));
            return;
        }
        boolean isLast = this.removePortFromDevice(sink.deviceId(), sink.port(), mcastIp, this.assignedVlan(null));
        if (isLast) {
            this.mcastRoleStore.remove((Object)new McastStoreKey(mcastIp, sink.deviceId()));
        }
        if ((mcastPath = this.getPath(source.deviceId(), sink.deviceId(), mcastIp)).isPresent()) {
            ArrayList links = Lists.newArrayList((Iterable)mcastPath.get().links());
            Collections.reverse(links);
            for (Link link : links) {
                if (!isLast) continue;
                isLast = this.removePortFromDevice(link.src().deviceId(), link.src().port(), mcastIp, this.assignedVlan((ConnectPoint)(link.src().deviceId().equals((Object)source.deviceId()) ? source : null)));
                this.mcastRoleStore.remove((Object)new McastStoreKey(mcastIp, link.src().deviceId()));
            }
        }
    }

    private void processSinkAddedInternal(ConnectPoint source, ConnectPoint sink, IpAddress mcastIp) {
        if (!this.srManager.mastershipService.isLocalMaster(source.deviceId())) {
            log.info("Skip {} due to lack of mastership of the source device {}", (Object)source.deviceId());
            return;
        }
        this.addFilterToDevice(source.deviceId(), source.port(), this.assignedVlan(source));
        if (source.deviceId().equals((Object)sink.deviceId())) {
            if (source.port().equals((Object)sink.port())) {
                log.warn("Sink is on the same port of source. Abort");
                return;
            }
            this.addPortToDevice(sink.deviceId(), sink.port(), mcastIp, this.assignedVlan(source));
            this.mcastRoleStore.put((Object)new McastStoreKey(mcastIp, sink.deviceId()), (Object)McastRole.INGRESS);
            return;
        }
        Optional<Path> mcastPath = this.getPath(source.deviceId(), sink.deviceId(), mcastIp);
        if (mcastPath.isPresent()) {
            List links = mcastPath.get().links();
            Preconditions.checkState((links.size() == 2 ? 1 : 0) != 0, (String)"Path in leaf-spine topology should always be two hops: ", (Object)links);
            links.forEach(link -> {
                this.addPortToDevice(link.src().deviceId(), link.src().port(), mcastIp, this.assignedVlan((ConnectPoint)(link.src().deviceId().equals((Object)source.deviceId()) ? source : null)));
                this.addFilterToDevice(link.dst().deviceId(), link.dst().port(), this.assignedVlan(null));
            });
            this.addPortToDevice(sink.deviceId(), sink.port(), mcastIp, this.assignedVlan(null));
            this.mcastRoleStore.put((Object)new McastStoreKey(mcastIp, source.deviceId()), (Object)McastRole.INGRESS);
            this.mcastRoleStore.put((Object)new McastStoreKey(mcastIp, ((Link)links.get(0)).dst().deviceId()), (Object)McastRole.TRANSIT);
            this.mcastRoleStore.put((Object)new McastStoreKey(mcastIp, sink.deviceId()), (Object)McastRole.EGRESS);
        } else {
            log.warn("Unable to find a path from {} to {}. Abort sinkAdded", (Object)source.deviceId(), (Object)sink.deviceId());
        }
    }

    protected void processLinkDown(Link affectedLink) {
        this.getAffectedGroups(affectedLink).forEach(mcastIp -> {
            DeviceId ingressDevice = this.getDevice((IpAddress)mcastIp, McastRole.INGRESS).stream().findAny().orElse(null);
            DeviceId transitDevice = this.getDevice((IpAddress)mcastIp, McastRole.TRANSIT).stream().findAny().orElse(null);
            Set<DeviceId> egressDevices = this.getDevice((IpAddress)mcastIp, McastRole.EGRESS);
            ConnectPoint source = this.getSource((IpAddress)mcastIp);
            if (ingressDevice == null || transitDevice == null || egressDevices == null || source == null) {
                log.warn("Missing ingress {}, transit {}, egress {} devices or source {}", new Object[]{ingressDevice, transitDevice, egressDevices, source});
                return;
            }
            if (!this.srManager.mastershipService.isLocalMaster(source.deviceId())) {
                log.info("Skip {} due to lack of mastership of the source device {}", (Object)source.deviceId());
                return;
            }
            this.removeGroupFromDevice(transitDevice, (IpAddress)mcastIp, this.assignedVlan(null));
            PortNumber ingressTransitPort = this.ingressTransitPort((IpAddress)mcastIp);
            if (ingressTransitPort != null) {
                this.removePortFromDevice(ingressDevice, ingressTransitPort, (IpAddress)mcastIp, this.assignedVlan(source));
                this.mcastRoleStore.remove((Object)new McastStoreKey((IpAddress)mcastIp, transitDevice));
            }
            egressDevices.forEach(egressDevice -> {
                Optional<Path> mcastPath = this.getPath(ingressDevice, (DeviceId)egressDevice, (IpAddress)mcastIp);
                if (mcastPath.isPresent()) {
                    List links = mcastPath.get().links();
                    links.forEach(link -> {
                        this.addPortToDevice(link.src().deviceId(), link.src().port(), (IpAddress)mcastIp, this.assignedVlan((ConnectPoint)(link.src().deviceId().equals((Object)source.deviceId()) ? source : null)));
                        this.addFilterToDevice(link.dst().deviceId(), link.dst().port(), this.assignedVlan(null));
                    });
                    this.mcastRoleStore.put((Object)new McastStoreKey((IpAddress)mcastIp, ((Link)links.get(0)).dst().deviceId()), (Object)McastRole.TRANSIT);
                } else {
                    log.warn("Fail to recover egress device {} from link failure {}", egressDevice, (Object)affectedLink);
                    this.removeGroupFromDevice((DeviceId)egressDevice, (IpAddress)mcastIp, this.assignedVlan(null));
                }
            });
        });
    }

    private void addFilterToDevice(DeviceId deviceId, PortNumber port, VlanId assignedVlan) {
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, port);
        SegmentRoutingAppConfig appConfig = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, SegmentRoutingAppConfig.class);
        if (appConfig != null && appConfig.suppressSubnet().contains(connectPoint)) {
            log.info("Ignore suppressed port {}", (Object)connectPoint);
            return;
        }
        FilteringObjective.Builder filtObjBuilder = this.filterObjBuilder(deviceId, port, assignedVlan);
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Successfully add filter on {}/{}, vlan {}", new Object[]{deviceId, port.toLong(), assignedVlan}), (objective, error) -> log.warn("Failed to add filter on {}/{}, vlan {}: {}", new Object[]{deviceId, port.toLong(), assignedVlan, error}));
        this.srManager.flowObjectiveService.filter(deviceId, filtObjBuilder.add((ObjectiveContext)context));
    }

    private void addPortToDevice(DeviceId deviceId, PortNumber port, IpAddress mcastIp, VlanId assignedVlan) {
        McastStoreKey mcastStoreKey = new McastStoreKey(mcastIp, deviceId);
        ImmutableSet.Builder portBuilder = ImmutableSet.builder();
        if (!this.mcastNextObjStore.containsKey((Object)mcastStoreKey)) {
            portBuilder.add((Object)port);
        } else {
            NextObjective nextObj = (NextObjective)this.mcastNextObjStore.get((Object)mcastStoreKey).value();
            Set<PortNumber> existingPorts = this.getPorts(nextObj.next());
            if (existingPorts.contains(port)) {
                log.info("NextObj for {}/{} already exists. Abort", (Object)deviceId, (Object)port);
                return;
            }
            portBuilder.addAll(existingPorts).add((Object)port).build();
        }
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Successfully add {} on {}/{}, vlan {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan}), (objective, error) -> log.warn("Failed to add {} on {}/{}, vlan {}: {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan, error}));
        NextObjective newNextObj = this.nextObjBuilder(mcastIp, assignedVlan, (Set<PortNumber>)portBuilder.build()).add();
        ForwardingObjective fwdObj = this.fwdObjBuilder(mcastIp, assignedVlan, newNextObj.id()).add((ObjectiveContext)context);
        this.mcastNextObjStore.put((Object)mcastStoreKey, (Object)newNextObj);
        this.srManager.flowObjectiveService.next(deviceId, newNextObj);
        this.srManager.flowObjectiveService.forward(deviceId, fwdObj);
    }

    private boolean removePortFromDevice(DeviceId deviceId, PortNumber port, IpAddress mcastIp, VlanId assignedVlan) {
        McastStoreKey mcastStoreKey = new McastStoreKey(mcastIp, deviceId);
        if (!this.mcastNextObjStore.containsKey((Object)mcastStoreKey)) {
            log.warn("{} is not serving {} on port {}. Abort.", new Object[]{deviceId, mcastIp, port});
            return false;
        }
        NextObjective nextObj = (NextObjective)this.mcastNextObjStore.get((Object)mcastStoreKey).value();
        HashSet existingPorts = this.getPorts(nextObj.next());
        if (!existingPorts.contains(port)) {
            log.warn("{} is not serving {} on port {}. Abort.", new Object[]{deviceId, mcastIp, port});
            return false;
        }
        existingPorts = Sets.newHashSet(existingPorts);
        existingPorts.remove(port);
        if (existingPorts.isEmpty()) {
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Successfully remove {} on {}/{}, vlan {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan}), (objective, error) -> log.warn("Failed to remove {} on {}/{}, vlan {}: {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan, error}));
            ForwardingObjective fwdObj = this.fwdObjBuilder(mcastIp, assignedVlan, nextObj.id()).remove((ObjectiveContext)context);
            this.mcastNextObjStore.remove((Object)mcastStoreKey);
            this.srManager.flowObjectiveService.forward(deviceId, fwdObj);
        } else {
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Successfully update {} on {}/{}, vlan {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan}), (objective, error) -> log.warn("Failed to update {} on {}/{}, vlan {}: {}", new Object[]{mcastIp, deviceId, port.toLong(), assignedVlan, error}));
            NextObjective newNextObj = this.nextObjBuilder(mcastIp, assignedVlan, existingPorts).add();
            ForwardingObjective fwdObj = this.fwdObjBuilder(mcastIp, assignedVlan, newNextObj.id()).add((ObjectiveContext)context);
            this.mcastNextObjStore.put((Object)mcastStoreKey, (Object)newNextObj);
            this.srManager.flowObjectiveService.next(deviceId, newNextObj);
            this.srManager.flowObjectiveService.forward(deviceId, fwdObj);
        }
        return existingPorts.isEmpty();
    }

    private void removeGroupFromDevice(DeviceId deviceId, IpAddress mcastIp, VlanId assignedVlan) {
        McastStoreKey mcastStoreKey = new McastStoreKey(mcastIp, deviceId);
        if (!this.mcastNextObjStore.containsKey((Object)mcastStoreKey)) {
            log.warn("{} is not serving {}. Abort.", (Object)deviceId, (Object)mcastIp);
            return;
        }
        NextObjective nextObj = (NextObjective)this.mcastNextObjStore.get((Object)mcastStoreKey).value();
        DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Successfully remove {} on {}, vlan {}", new Object[]{mcastIp, deviceId, assignedVlan}), (objective, error) -> log.warn("Failed to remove {} on {}, vlan {}: {}", new Object[]{mcastIp, deviceId, assignedVlan, error}));
        ForwardingObjective fwdObj = this.fwdObjBuilder(mcastIp, assignedVlan, nextObj.id()).remove((ObjectiveContext)context);
        this.srManager.flowObjectiveService.forward(deviceId, fwdObj);
        this.mcastNextObjStore.remove((Object)mcastStoreKey);
        this.mcastRoleStore.remove((Object)mcastStoreKey);
    }

    public void removeDevice(DeviceId deviceId) {
        this.mcastNextObjStore.entrySet().stream().filter(entry -> ((McastStoreKey)entry.getKey()).deviceId().equals((Object)deviceId)).forEach(entry -> {
            ConnectPoint source = this.getSource(((McastStoreKey)entry.getKey()).mcastIp());
            this.removeGroupFromDevice(((McastStoreKey)entry.getKey()).deviceId(), ((McastStoreKey)entry.getKey()).mcastIp(), this.assignedVlan((ConnectPoint)(deviceId.equals((Object)source.deviceId()) ? source : null)));
            this.mcastNextObjStore.remove(entry.getKey());
        });
        log.debug("{} is removed from mcastNextObjStore", (Object)deviceId);
        this.mcastRoleStore.entrySet().stream().filter(entry -> ((McastStoreKey)entry.getKey()).deviceId().equals((Object)deviceId)).forEach(entry -> this.mcastRoleStore.remove(entry.getKey()));
        log.debug("{} is removed from mcastRoleStore", (Object)deviceId);
    }

    private NextObjective.Builder nextObjBuilder(IpAddress mcastIp, VlanId assignedVlan, Set<PortNumber> outPorts) {
        int nextId = this.srManager.flowObjectiveService.allocateNextId();
        TrafficSelector metadata = DefaultTrafficSelector.builder().matchVlanId(assignedVlan).matchIPDst(mcastIp.toIpPrefix()).build();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.BROADCAST).fromApp(this.srManager.appId).withMeta(metadata);
        outPorts.forEach(arg_0 -> this.lambda$nextObjBuilder$21((NextObjective.Builder)nextObjBuilder, arg_0));
        return nextObjBuilder;
    }

    private ForwardingObjective.Builder fwdObjBuilder(IpAddress mcastIp, VlanId assignedVlan, int nextId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        IpPrefix mcastPrefix = IpPrefix.valueOf((IpAddress)mcastIp, (int)32);
        sbuilder.matchEthType(Ethernet.TYPE_IPV4);
        sbuilder.matchIPDst(mcastPrefix);
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
        metabuilder.matchVlanId(assignedVlan);
        DefaultForwardingObjective.Builder fwdBuilder = DefaultForwardingObjective.builder();
        fwdBuilder.withSelector(sbuilder.build()).withMeta(metabuilder.build()).nextStep(nextId).withFlag(ForwardingObjective.Flag.SPECIFIC).fromApp(this.srManager.appId).withPriority(100);
        return fwdBuilder;
    }

    private FilteringObjective.Builder filterObjBuilder(DeviceId deviceId, PortNumber ingressPort, VlanId assignedVlan) {
        DefaultFilteringObjective.Builder filtBuilder = DefaultFilteringObjective.builder();
        filtBuilder.withKey(Criteria.matchInPort((PortNumber)ingressPort)).addCondition(Criteria.matchEthDstMasked((MacAddress)MacAddress.IPV4_MULTICAST, (MacAddress)MacAddress.IPV4_MULTICAST_MASK)).addCondition(Criteria.matchVlanId((VlanId)this.egressVlan())).withPriority(100);
        TrafficTreatment tt = DefaultTrafficTreatment.builder().pushVlan().setVlanId(assignedVlan).build();
        filtBuilder.withMeta(tt);
        return filtBuilder.permit().fromApp(this.srManager.appId);
    }

    private Set<PortNumber> getPorts(Collection<TrafficTreatment> treatments) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        treatments.forEach(treatment -> treatment.allInstructions().stream().filter(instr -> instr instanceof Instructions.OutputInstruction).forEach(instr -> builder.add((Object)((Instructions.OutputInstruction)instr).port())));
        return builder.build();
    }

    private Optional<Path> getPath(DeviceId src, DeviceId dst, IpAddress mcastIp) {
        ArrayList allPaths = Lists.newArrayList((Iterable)this.topologyService.getPaths(this.topologyService.currentTopology(), src, dst));
        log.debug("{} path(s) found from {} to {}", new Object[]{allPaths.size(), src, dst});
        if (allPaths.isEmpty()) {
            return Optional.empty();
        }
        McastStoreKey mcastStoreKey = new McastStoreKey(mcastIp, src);
        if (this.mcastNextObjStore.containsKey((Object)mcastStoreKey)) {
            NextObjective nextObj = (NextObjective)this.mcastNextObjStore.get((Object)mcastStoreKey).value();
            Set<PortNumber> existingPorts = this.getPorts(nextObj.next());
            for (Path path : allPaths) {
                PortNumber srcPort = ((Link)path.links().get(0)).src().port();
                if (!existingPorts.contains(srcPort)) continue;
                return Optional.of(path);
            }
        }
        Collections.shuffle(allPaths);
        return allPaths.stream().findFirst();
    }

    private Set<DeviceId> getDevice(IpAddress mcastIp, McastRole role) {
        return this.mcastRoleStore.entrySet().stream().filter(entry -> ((McastStoreKey)entry.getKey()).mcastIp().equals((Object)mcastIp) && ((Versioned)entry.getValue()).value() == role).map(Map.Entry::getKey).map(McastStoreKey::deviceId).collect(Collectors.toSet());
    }

    private ConnectPoint getSource(IpAddress mcastIp) {
        return this.srManager.multicastRouteService.getRoutes().stream().filter(mcastRoute -> mcastRoute.group().equals((Object)mcastIp)).map(mcastRoute -> this.srManager.multicastRouteService.fetchSource(mcastRoute)).findAny().orElse(null);
    }

    private Set<IpAddress> getAffectedGroups(Link link) {
        DeviceId deviceId = link.src().deviceId();
        PortNumber port = link.src().port();
        return this.mcastNextObjStore.entrySet().stream().filter(entry -> ((McastStoreKey)entry.getKey()).deviceId().equals((Object)deviceId) && this.getPorts(((NextObjective)((Versioned)entry.getValue()).value()).next()).contains(port)).map(Map.Entry::getKey).map(McastStoreKey::mcastIp).collect(Collectors.toSet());
    }

    private VlanId egressVlan() {
        McastConfig mcastConfig = (McastConfig)this.srManager.cfgService.getConfig((Object)this.coreAppId, McastConfig.class);
        return mcastConfig != null ? mcastConfig.egressVlan() : VlanId.NONE;
    }

    private VlanId assignedVlan(ConnectPoint cp) {
        if (!this.egressVlan().equals((Object)VlanId.NONE)) {
            return this.egressVlan();
        }
        if (cp != null) {
            VlanId untaggedVlan = this.srManager.getUntaggedVlanId(cp);
            return untaggedVlan != null ? untaggedVlan : SegmentRoutingManager.INTERNAL_VLAN;
        }
        return SegmentRoutingManager.INTERNAL_VLAN;
    }

    private PortNumber ingressTransitPort(IpAddress mcastIp) {
        DeviceId ingressDevice = this.getDevice(mcastIp, McastRole.INGRESS).stream().findAny().orElse(null);
        if (ingressDevice != null) {
            NextObjective nextObj = (NextObjective)this.mcastNextObjStore.get((Object)new McastStoreKey(mcastIp, ingressDevice)).value();
            Set<PortNumber> ports = this.getPorts(nextObj.next());
            for (PortNumber port : ports) {
                if (this.srManager.deviceConfiguration == null || !this.srManager.deviceConfiguration.getPortSubnets(ingressDevice, port).isEmpty() || this.srManager.xConnectHandler.hasXConnect(new ConnectPoint((ElementId)ingressDevice, port))) continue;
                return port;
            }
        }
        return null;
    }

    private /* synthetic */ void lambda$nextObjBuilder$21(NextObjective.Builder nextObjBuilder, PortNumber port) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        if (this.egressVlan().equals((Object)VlanId.NONE)) {
            tBuilder.popVlan();
        }
        tBuilder.setOutput(port);
        nextObjBuilder.addTreatment(tBuilder.build());
    }

    public static enum McastRole {
        INGRESS,
        TRANSIT,
        EGRESS;

    }
}

