/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpHandler {
    private static Logger log = LoggerFactory.getLogger(IpHandler.class);
    private SegmentRoutingManager srManager;
    private DeviceConfiguration config;
    private ConcurrentHashMap<IpAddress, ConcurrentLinkedQueue<IP>> ipPacketQueue;

    public IpHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.config = (DeviceConfiguration)Preconditions.checkNotNull((Object)srManager.deviceConfiguration);
        this.ipPacketQueue = new ConcurrentHashMap();
    }

    private void enqueuePacket(IP ipPacket, IpAddress destinationAddress) {
        this.ipPacketQueue.computeIfAbsent(destinationAddress, a -> new ConcurrentLinkedQueue()).add(ipPacket);
    }

    public void dequeuePacket(IP ipPacket, IpAddress destinationAddress) {
        if (this.ipPacketQueue.get(destinationAddress) == null) {
            return;
        }
        this.ipPacketQueue.get(destinationAddress).remove(ipPacket);
    }

    private void forwardToHost(DeviceId deviceId, Ethernet eth, Host dest) {
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(dest.location().port()).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(deviceId, treatment, ByteBuffer.wrap(eth.serialize()));
        this.srManager.packetService.emit((OutboundPacket)packet);
    }

    public void processPacketIn(IPv4 pkt, ConnectPoint connectPoint) {
        DeviceId deviceId = connectPoint.deviceId();
        Ip4Address destinationAddress = Ip4Address.valueOf((int)pkt.getDestinationAddress());
        if (!this.srManager.hostService.getHostsByIp((IpAddress)destinationAddress).isEmpty()) {
            this.forwardPackets(deviceId, destinationAddress);
        } else if (this.config.inSameSubnet(deviceId, (IpAddress)destinationAddress)) {
            this.srManager.arpHandler.sendArpRequest(deviceId, (IpAddress)destinationAddress, connectPoint);
        } else {
            log.debug("IPv4 packet for unknown host {} which is not in the subnet", (Object)destinationAddress);
        }
    }

    public void addToPacketBuffer(IPv4 ipPacket) {
        if (ipPacket.getProtocol() == 6) {
            return;
        }
        IpAddress destIpAddress = IpAddress.valueOf((int)ipPacket.getDestinationAddress());
        this.enqueuePacket((IP)ipPacket, destIpAddress);
    }

    public void forwardPackets(DeviceId deviceId, Ip4Address destIpAddress) {
        if (this.ipPacketQueue.get(destIpAddress) == null) {
            return;
        }
        for (IP ipPacket : this.ipPacketQueue.get(destIpAddress)) {
            IPv4 ipv4Packet;
            Ip4Address destAddress;
            if (ipPacket.getVersion() != 4 || !this.config.inSameSubnet(deviceId, (IpAddress)(destAddress = Ip4Address.valueOf((int)(ipv4Packet = (IPv4)ipPacket).getDestinationAddress())))) continue;
            ipv4Packet.setTtl((byte)(ipv4Packet.getTtl() - 1));
            ipv4Packet.setChecksum((short)0);
            for (Host dest : this.srManager.hostService.getHostsByIp((IpAddress)destIpAddress)) {
                Ethernet eth = new Ethernet();
                eth.setDestinationMACAddress(dest.mac());
                try {
                    eth.setSourceMACAddress(this.config.getDeviceMac(deviceId));
                }
                catch (DeviceConfigNotFoundException e) {
                    log.warn(e.getMessage() + " Skipping forwardPackets for this destination.");
                    continue;
                }
                eth.setEtherType(Ethernet.TYPE_IPV4);
                eth.setPayload((IPacket)ipv4Packet);
                this.forwardToHost(deviceId, eth, dest);
                this.ipPacketQueue.get(destIpAddress).remove(ipPacket);
            }
            this.ipPacketQueue.get(destIpAddress).remove(ipPacket);
        }
    }

    public void processPacketIn(IPv6 pkt, ConnectPoint connectPoint) {
        DeviceId deviceId = connectPoint.deviceId();
        Ip6Address destinationAddress = Ip6Address.valueOf((byte[])pkt.getDestinationAddress());
        if (!this.srManager.hostService.getHostsByIp((IpAddress)destinationAddress).isEmpty()) {
            this.forwardPackets(deviceId, destinationAddress);
        } else if (this.config.inSameSubnet(deviceId, (IpAddress)destinationAddress)) {
            this.srManager.icmpHandler.sendNdpRequest(deviceId, (IpAddress)destinationAddress, connectPoint);
        } else {
            log.debug("IPv6 packet for unknown host {} which is not in the subnet", (Object)destinationAddress);
        }
    }

    public void addToPacketBuffer(IPv6 ipPacket) {
        if (ipPacket.getNextHeader() == 6) {
            return;
        }
        IpAddress destIpAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])ipPacket.getDestinationAddress());
        this.enqueuePacket((IP)ipPacket, destIpAddress);
    }

    public void forwardPackets(DeviceId deviceId, Ip6Address destIpAddress) {
        if (this.ipPacketQueue.get(destIpAddress) == null) {
            return;
        }
        for (IP ipPacket : this.ipPacketQueue.get(destIpAddress)) {
            IPv6 ipv6Packet;
            Ip6Address destAddress;
            if (ipPacket.getVersion() == 6 && this.config.inSameSubnet(deviceId, (IpAddress)(destAddress = Ip6Address.valueOf((byte[])(ipv6Packet = (IPv6)ipPacket).getDestinationAddress())))) {
                ipv6Packet.setHopLimit((byte)(ipv6Packet.getHopLimit() - 1));
                for (Host dest : this.srManager.hostService.getHostsByIp((IpAddress)destIpAddress)) {
                    Ethernet eth = new Ethernet();
                    eth.setDestinationMACAddress(dest.mac());
                    try {
                        eth.setSourceMACAddress(this.config.getDeviceMac(deviceId));
                    }
                    catch (DeviceConfigNotFoundException e) {
                        log.warn(e.getMessage() + " Skipping forwardPackets for this destination.");
                        continue;
                    }
                    eth.setEtherType(Ethernet.TYPE_IPV6);
                    eth.setPayload((IPacket)ipv6Packet);
                    this.forwardToHost(deviceId, eth, dest);
                    this.ipPacketQueue.get(destIpAddress).remove(ipPacket);
                }
                this.ipPacketQueue.get(destIpAddress).remove(ipPacket);
            }
            this.ipPacketQueue.get(destIpAddress).remove(ipPacket);
        }
    }
}

