/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MPLS;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborSolicitation;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageType;
import org.onosproject.incubator.net.routing.ResolvedRoute;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.SegmentRoutingNeighbourHandler;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpHandler
extends SegmentRoutingNeighbourHandler {
    private static Logger log = LoggerFactory.getLogger(IcmpHandler.class);

    public IcmpHandler(SegmentRoutingManager srManager) {
        super(srManager);
    }

    private void sendPacketOut(ConnectPoint outport, Ethernet payload, int sid, IpAddress destIpAddress, byte allowedHops) {
        int destSid = destIpAddress.isIp4() ? this.config.getIPv4SegmentId(payload.getDestinationMAC()) : this.config.getIPv6SegmentId(payload.getDestinationMAC());
        if (sid == -1 || destSid == sid || this.config.inSameSubnet(outport.deviceId(), destIpAddress)) {
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outport.port()).build();
            DefaultOutboundPacket packet = new DefaultOutboundPacket(outport.deviceId(), treatment, ByteBuffer.wrap(payload.serialize()));
            this.srManager.packetService.emit((OutboundPacket)packet);
        } else {
            log.debug("Send a MPLS packet as a ICMP response");
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(outport.port()).build();
            payload.setEtherType(Ethernet.MPLS_UNICAST);
            MPLS mplsPkt = new MPLS();
            mplsPkt.setLabel(sid);
            mplsPkt.setTtl(allowedHops);
            mplsPkt.setPayload(payload.getPayload());
            payload.setPayload((IPacket)mplsPkt);
            DefaultOutboundPacket packet = new DefaultOutboundPacket(outport.deviceId(), treatment, ByteBuffer.wrap(payload.serialize()));
            this.srManager.packetService.emit((OutboundPacket)packet);
        }
    }

    public void processIcmp(Ethernet eth, ConnectPoint inPort) {
        Ip4Address routerIp;
        DeviceId deviceId = inPort.deviceId();
        IPv4 ipv4Packet = (IPv4)eth.getPayload();
        Ip4Address destinationAddress = Ip4Address.valueOf((int)ipv4Packet.getDestinationAddress());
        Set<IpAddress> gatewayIpAddresses = this.config.getPortIPs(deviceId);
        try {
            routerIp = this.config.getRouterIpv4(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting processPacketIn.");
            return;
        }
        if (((ICMP)ipv4Packet.getPayload()).getIcmpType() == 8 && (destinationAddress.equals((Object)routerIp.getIp4Address()) || gatewayIpAddresses.contains(destinationAddress))) {
            this.sendIcmpResponse(eth, inPort);
        } else {
            log.trace("Ignore ICMP that targets for {}", (Object)destinationAddress);
        }
        this.srManager.ipHandler.dequeuePacket((IP)ipv4Packet, (IpAddress)destinationAddress);
    }

    private void sendIcmpResponse(Ethernet icmpRequest, ConnectPoint outport) {
        int destSid;
        Optional nexthop;
        Ethernet icmpReplyEth = ICMP.buildIcmpReply((Ethernet)icmpRequest);
        IPv4 icmpRequestIpv4 = (IPv4)icmpRequest.getPayload();
        IPv4 icmpReplyIpv4 = (IPv4)icmpReplyEth.getPayload();
        Ip4Address destIpAddress = Ip4Address.valueOf((int)icmpRequestIpv4.getSourceAddress());
        Ip4Address destRouterAddress = this.config.getRouterIpAddressForASubnetHost(destIpAddress);
        if (destRouterAddress == null && (nexthop = this.srManager.routeService.longestPrefixLookup((IpAddress)destIpAddress)).isPresent()) {
            try {
                destRouterAddress = this.config.getRouterIpv4(((ResolvedRoute)nexthop.get()).location().deviceId());
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn("Device config not found. Abort ICMP processing");
                return;
            }
        }
        if ((destSid = this.config.getIPv4SegmentId(destRouterAddress)) < 0) {
            log.warn("Failed to lookup SID of the switch that {} attaches to. Unable to process ICMP request.", (Object)destIpAddress);
            return;
        }
        this.sendPacketOut(outport, icmpReplyEth, destSid, (IpAddress)destIpAddress, icmpReplyIpv4.getTtl());
    }

    public void processIcmpv6(Ethernet eth, ConnectPoint inPort) {
        Ip6Address routerIp;
        DeviceId deviceId = inPort.deviceId();
        IPv6 ipv6Packet = (IPv6)eth.getPayload();
        Ip6Address destinationAddress = Ip6Address.valueOf((byte[])ipv6Packet.getDestinationAddress());
        Set<IpAddress> gatewayIpAddresses = this.config.getPortIPs(deviceId);
        try {
            routerIp = this.config.getRouterIpv6(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting processPacketIn.");
            return;
        }
        ICMP6 icmp6 = (ICMP6)ipv6Packet.getPayload();
        if (icmp6.getIcmpType() == -128 && (destinationAddress.equals((Object)routerIp.getIp6Address()) || gatewayIpAddresses.contains(destinationAddress))) {
            this.sendIcmpv6Response(eth, inPort);
        } else {
            log.trace("Ignore ICMPv6 that targets for {}", (Object)destinationAddress);
        }
    }

    private void sendIcmpv6Response(Ethernet ethRequest, ConnectPoint outport) {
        int sid;
        Optional nexthop;
        Ethernet ethReply = ICMP6.buildIcmp6Reply((Ethernet)ethRequest);
        IPv6 icmpRequestIpv6 = (IPv6)ethRequest.getPayload();
        IPv6 icmpReplyIpv6 = (IPv6)ethRequest.getPayload();
        Ip6Address destIpAddress = Ip6Address.valueOf((byte[])icmpRequestIpv6.getSourceAddress());
        Ip6Address destRouterAddress = this.config.getRouterIpAddressForASubnetHost(destIpAddress);
        if (destRouterAddress == null && (nexthop = this.srManager.routeService.longestPrefixLookup((IpAddress)destIpAddress)).isPresent()) {
            try {
                destRouterAddress = this.config.getRouterIpv6(((ResolvedRoute)nexthop.get()).location().deviceId());
            }
            catch (DeviceConfigNotFoundException e) {
                log.warn("Device config not found. Abort ICMPv6 processing");
                return;
            }
        }
        if ((sid = this.config.getIPv6SegmentId(destRouterAddress)) < 0) {
            log.warn("Failed to lookup SID of the switch that {} attaches to. Unable to process ICMPv6 request.", (Object)destIpAddress);
            return;
        }
        this.sendPacketOut(outport, ethReply, sid, (IpAddress)destIpAddress, icmpReplyIpv6.getHopLimit());
    }

    public void processPacketIn(NeighbourMessageContext pkt, HostService hostService) {
        SegmentRoutingAppConfig appConfig = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, SegmentRoutingAppConfig.class);
        if (appConfig != null && appConfig.suppressSubnet().contains(pkt.inPort())) {
            pkt.drop();
            return;
        }
        if (pkt.type() == NeighbourMessageType.REQUEST) {
            this.handleNdpRequest(pkt, hostService);
        } else {
            this.handleNdpReply(pkt, hostService);
        }
    }

    private void handleNdpRequest(NeighbourMessageContext pkt, HostService hostService) {
        if (this.isNdpForGateway(pkt)) {
            log.trace("Sending NDP reply on behalf of gateway IP for pkt: {}", (Object)pkt);
            this.sendResponse(pkt, this.config.getRouterMacForAGatewayIp(pkt.target()), hostService);
        }
    }

    private void handleNdpReply(NeighbourMessageContext pkt, HostService hostService) {
        if (this.isNdpForGateway(pkt)) {
            log.debug("Forwarding all the ip packets we stored");
            Ip6Address hostIpAddress = pkt.sender().getIp6Address();
            this.srManager.ipHandler.forwardPackets(pkt.inPort().deviceId(), hostIpAddress);
        }
    }

    private boolean isNdpForGateway(NeighbourMessageContext pkt) {
        DeviceId deviceId = pkt.inPort().deviceId();
        Set<IpAddress> gatewayIpAddresses = null;
        try {
            if (pkt.target().equals((Object)this.config.getRouterIpv6(deviceId))) {
                return true;
            }
            gatewayIpAddresses = this.config.getPortIPs(deviceId);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting check for router IP in processing ndp");
        }
        return gatewayIpAddresses != null && gatewayIpAddresses.stream().filter(IpAddress::isIp6).anyMatch(gatewayIp -> gatewayIp.equals((Object)pkt.target()) || Arrays.equals(IPv6.getSolicitNodeAddress((byte[])gatewayIp.toOctets()), pkt.target().toOctets()));
    }

    public void sendNdpRequest(DeviceId deviceId, IpAddress targetAddress, ConnectPoint inPort) {
        byte[] senderMacAddress = new byte[6];
        byte[] senderIpAddress = new byte[16];
        if (!this.getSenderInfo(senderMacAddress, senderIpAddress, deviceId, targetAddress)) {
            log.warn("Aborting sendNdpRequest, we cannot get all the information needed");
            return;
        }
        byte[] dstIp = IPv6.getSolicitNodeAddress((byte[])targetAddress.toOctets());
        byte[] dstMac = IPv6.getMCastMacAddress((byte[])dstIp);
        Ethernet ndpRequest = NeighborSolicitation.buildNdpSolicit((byte[])targetAddress.toOctets(), (byte[])senderIpAddress, (byte[])dstIp, (byte[])senderMacAddress, (byte[])dstMac, (VlanId)VlanId.NONE);
        this.flood(ndpRequest, inPort, targetAddress);
    }
}

