/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.collect.Sets;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostHandler {
    private static final Logger log = LoggerFactory.getLogger(HostHandler.class);
    private final SegmentRoutingManager srManager;
    private HostService hostService;
    private FlowObjectiveService flowObjectiveService;

    public HostHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.hostService = srManager.hostService;
        this.flowObjectiveService = srManager.flowObjectiveService;
    }

    protected void init(DeviceId devId) {
        this.hostService.getHosts().forEach(host -> {
            DeviceId deviceId = host.location().deviceId();
            if (!deviceId.equals((Object)devId)) {
                return;
            }
            this.processHostAdded((Host)host);
        });
    }

    protected void processHostAddedEvent(HostEvent event) {
        this.processHostAdded((Host)event.subject());
    }

    protected void processHostAdded(Host host) {
        MacAddress mac = host.mac();
        VlanId vlanId = host.vlan();
        HostLocation location = host.location();
        DeviceId deviceId = location.deviceId();
        PortNumber port = location.port();
        Set ips = host.ipAddresses();
        log.info("Host {}/{} is added at {}:{}", new Object[]{mac, vlanId, deviceId, port});
        if (this.accepted(host)) {
            log.debug("Populating bridging entry for host {}/{} at {}:{}", new Object[]{mac, vlanId, deviceId, port});
            ForwardingObjective.Builder fob = this.bridgingFwdObjBuilder(deviceId, mac, vlanId, port, false);
            if (fob == null) {
                log.warn("Fail to create fwd obj for host {}/{}. Abort.", (Object)mac, (Object)vlanId);
                return;
            }
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Brigding rule for {}/{} populated", (Object)mac, (Object)vlanId), (objective, error) -> log.warn("Failed to populate bridging rule for {}/{}: {}", new Object[]{mac, vlanId, error}));
            this.flowObjectiveService.forward(deviceId, fob.add((ObjectiveContext)context));
            ips.forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)location, (IpAddress)ip)) {
                    this.srManager.routingRulePopulator.populateRoute(deviceId, ip.toIpPrefix(), mac, vlanId, port);
                }
            });
        }
    }

    protected void processHostRemoveEvent(HostEvent event) {
        this.processHostRemoved((Host)event.subject());
    }

    protected void processHostRemoved(Host host) {
        MacAddress mac = host.mac();
        VlanId vlanId = host.vlan();
        HostLocation location = host.location();
        DeviceId deviceId = location.deviceId();
        PortNumber port = location.port();
        Set ips = host.ipAddresses();
        log.info("Host {}/{} is removed from {}:{}", new Object[]{mac, vlanId, deviceId, port});
        if (this.accepted(host)) {
            ForwardingObjective.Builder fob = this.bridgingFwdObjBuilder(deviceId, mac, vlanId, port, true);
            if (fob == null) {
                log.warn("Fail to create fwd obj for host {}/{}. Abort.", (Object)mac, (Object)vlanId);
                return;
            }
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("Host rule for {} revoked", (Object)host), (objective, error) -> log.warn("Failed to revoke host rule for {}: {}", (Object)host, error));
            this.flowObjectiveService.forward(deviceId, fob.remove((ObjectiveContext)context));
            ips.forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)location, (IpAddress)ip)) {
                    this.srManager.routingRulePopulator.revokeRoute(deviceId, ip.toIpPrefix(), mac, vlanId, port);
                }
            });
        }
    }

    protected void processHostMovedEvent(HostEvent event) {
        DefaultObjectiveContext context;
        MacAddress mac = ((Host)event.subject()).mac();
        VlanId vlanId = ((Host)event.subject()).vlan();
        HostLocation prevLocation = event.prevSubject().location();
        DeviceId prevDeviceId = prevLocation.deviceId();
        PortNumber prevPort = prevLocation.port();
        Set prevIps = event.prevSubject().ipAddresses();
        HostLocation newLocation = ((Host)event.subject()).location();
        DeviceId newDeviceId = newLocation.deviceId();
        PortNumber newPort = newLocation.port();
        Set newIps = ((Host)event.subject()).ipAddresses();
        log.info("Host {}/{} is moved from {}:{} to {}:{}", new Object[]{mac, vlanId, prevDeviceId, prevPort, newDeviceId, newPort});
        if (this.accepted(event.prevSubject())) {
            ForwardingObjective.Builder prevFob = this.bridgingFwdObjBuilder(prevDeviceId, mac, vlanId, prevPort, true);
            if (prevFob == null) {
                log.warn("Fail to create fwd obj for host {}/{}. Abort.", (Object)mac, (Object)vlanId);
                return;
            }
            context = new DefaultObjectiveContext(objective -> log.debug("Host rule for {} revoked", event.subject()), (objective, error) -> log.warn("Failed to revoke host rule for {}: {}", event.subject(), error));
            this.flowObjectiveService.forward(prevDeviceId, prevFob.remove((ObjectiveContext)context));
            prevIps.forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)prevLocation, (IpAddress)ip)) {
                    this.srManager.routingRulePopulator.revokeRoute(prevDeviceId, ip.toIpPrefix(), mac, vlanId, prevPort);
                }
            });
        }
        if (this.accepted((Host)event.subject())) {
            ForwardingObjective.Builder newFob = this.bridgingFwdObjBuilder(newDeviceId, mac, vlanId, newPort, false);
            if (newFob == null) {
                log.warn("Fail to create fwd obj for host {}/{}. Abort.", (Object)mac, (Object)vlanId);
                return;
            }
            context = new DefaultObjectiveContext(objective -> log.debug("Host rule for {} populated", event.subject()), (objective, error) -> log.warn("Failed to populate host rule for {}: {}", event.subject(), error));
            this.flowObjectiveService.forward(newDeviceId, newFob.add((ObjectiveContext)context));
            newIps.forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)newLocation, (IpAddress)ip)) {
                    this.srManager.routingRulePopulator.populateRoute(newDeviceId, ip.toIpPrefix(), mac, vlanId, newPort);
                }
            });
        }
    }

    protected void processHostUpdatedEvent(HostEvent event) {
        MacAddress mac = ((Host)event.subject()).mac();
        VlanId vlanId = ((Host)event.subject()).vlan();
        HostLocation prevLocation = event.prevSubject().location();
        DeviceId prevDeviceId = prevLocation.deviceId();
        PortNumber prevPort = prevLocation.port();
        Set prevIps = event.prevSubject().ipAddresses();
        HostLocation newLocation = ((Host)event.subject()).location();
        DeviceId newDeviceId = newLocation.deviceId();
        PortNumber newPort = newLocation.port();
        Set newIps = ((Host)event.subject()).ipAddresses();
        log.info("Host {}/{} is updated", (Object)mac, (Object)vlanId);
        if (this.accepted(event.prevSubject())) {
            Sets.difference((Set)prevIps, (Set)newIps).forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)prevLocation, (IpAddress)ip)) {
                    log.info("revoking previous IP rule:{}", ip);
                    this.srManager.routingRulePopulator.revokeRoute(prevDeviceId, ip.toIpPrefix(), mac, vlanId, prevPort);
                }
            });
        }
        if (this.accepted((Host)event.subject())) {
            Sets.difference((Set)newIps, (Set)prevIps).forEach(ip -> {
                if (this.srManager.deviceConfiguration.inSameSubnet((ConnectPoint)newLocation, (IpAddress)ip)) {
                    log.info("populating new IP rule:{}", ip);
                    this.srManager.routingRulePopulator.populateRoute(newDeviceId, ip.toIpPrefix(), mac, vlanId, newPort);
                }
            });
        }
    }

    private ForwardingObjective.Builder bridgingFwdObjBuilder(DeviceId deviceId, MacAddress mac, VlanId hostVlanId, PortNumber outport, boolean revoke) {
        ConnectPoint connectPoint = new ConnectPoint((ElementId)deviceId, outport);
        VlanId untaggedVlan = this.srManager.getUntaggedVlanId(connectPoint);
        Set<VlanId> taggedVlans = this.srManager.getTaggedVlanId(connectPoint);
        VlanId nativeVlan = this.srManager.getNativeVlanId(connectPoint);
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        sbuilder.matchEthDst(mac);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder();
        tbuilder.immediate().setOutput(outport);
        TrafficSelector.Builder mbuilder = DefaultTrafficSelector.builder();
        if (taggedVlans.contains(hostVlanId)) {
            sbuilder.matchVlanId(hostVlanId);
            mbuilder.matchVlanId(hostVlanId);
        } else if (hostVlanId.equals((Object)VlanId.NONE)) {
            if (untaggedVlan != null) {
                sbuilder.matchVlanId(untaggedVlan);
                mbuilder.matchVlanId(untaggedVlan);
                tbuilder.immediate().popVlan();
            } else if (nativeVlan != null) {
                sbuilder.matchVlanId(nativeVlan);
                mbuilder.matchVlanId(nativeVlan);
                tbuilder.immediate().popVlan();
            } else {
                sbuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
                mbuilder.matchVlanId(SegmentRoutingManager.INTERNAL_VLAN);
                tbuilder.immediate().popVlan();
            }
        } else {
            log.warn("Tagged host {}/{} is not allowed on {} without VLAN listed in tagged vlan", new Object[]{mac, hostVlanId, connectPoint});
            return null;
        }
        int portNextObjId = this.srManager.getPortNextObjectiveId(deviceId, outport, tbuilder.build(), mbuilder.build(), !revoke);
        if (portNextObjId == -1) {
            return null;
        }
        return DefaultForwardingObjective.builder().withFlag(ForwardingObjective.Flag.SPECIFIC).withSelector(sbuilder.build()).nextStep(portNextObjId).withPriority(100).fromApp(this.srManager.appId).makePermanent();
    }

    private boolean accepted(Host host) {
        boolean accepted;
        SegmentRoutingAppConfig appConfig = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, SegmentRoutingAppConfig.class);
        boolean bl = accepted = appConfig == null || !appConfig.suppressHostByProvider().contains(host.providerId().id()) && !appConfig.suppressHostByPort().contains(host.location());
        if (!accepted) {
            log.info("Ignore suppressed host {}", (Object)host.id());
        }
        return accepted;
    }
}

