/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcmpShortestPathGraph {
    LinkedList<DeviceId> deviceQueue = new LinkedList();
    LinkedList<Integer> distanceQueue = new LinkedList();
    HashMap<DeviceId, Integer> deviceSearched = new HashMap();
    HashMap<DeviceId, ArrayList<Link>> upstreamLinks = new HashMap();
    HashMap<DeviceId, ArrayList<Path>> paths = new HashMap();
    HashMap<Integer, ArrayList<DeviceId>> distanceDeviceMap = new HashMap();
    DeviceId rootDevice;
    private SegmentRoutingManager srManager;
    private static final Logger log = LoggerFactory.getLogger(EcmpShortestPathGraph.class);

    public EcmpShortestPathGraph(DeviceId rootDevice, List<String> deviceIdListToAvoid, List<Link> linkListToAvoid) {
        this.rootDevice = rootDevice;
        this.calcECMPShortestPathGraph(deviceIdListToAvoid, linkListToAvoid);
    }

    public EcmpShortestPathGraph(DeviceId rootDevice, SegmentRoutingManager srManager) {
        this.rootDevice = rootDevice;
        this.srManager = srManager;
        this.calcECMPShortestPathGraph();
    }

    private void calcECMPShortestPathGraph() {
        this.deviceQueue.add(this.rootDevice);
        int currDistance = 0;
        this.distanceQueue.add(currDistance);
        this.deviceSearched.put(this.rootDevice, currDistance);
        while (!this.deviceQueue.isEmpty()) {
            DeviceId sw = this.deviceQueue.poll();
            DeviceId prevSw = null;
            currDistance = this.distanceQueue.poll();
            for (Link link : this.srManager.linkService.getDeviceEgressLinks(sw)) {
                ArrayList<Object> upstreamLinkArray;
                DeviceId reachedDevice = link.dst().deviceId();
                if (prevSw != null && prevSw.equals((Object)reachedDevice)) continue;
                prevSw = reachedDevice;
                Integer distance = this.deviceSearched.get(reachedDevice);
                if (distance != null && distance < currDistance + 1) continue;
                if (distance == null) {
                    this.deviceQueue.add(reachedDevice);
                    this.distanceQueue.add(currDistance + 1);
                    this.deviceSearched.put(reachedDevice, currDistance + 1);
                    ArrayList<Object> distanceSwArray = this.distanceDeviceMap.get(currDistance + 1);
                    if (distanceSwArray == null) {
                        distanceSwArray = new ArrayList();
                        distanceSwArray.add(reachedDevice);
                        this.distanceDeviceMap.put(currDistance + 1, distanceSwArray);
                    } else {
                        distanceSwArray.add(reachedDevice);
                    }
                }
                if ((upstreamLinkArray = this.upstreamLinks.get(reachedDevice)) == null) {
                    upstreamLinkArray = new ArrayList();
                    upstreamLinkArray.add(this.copyDefaultLink(link));
                    this.upstreamLinks.put(reachedDevice, upstreamLinkArray);
                    continue;
                }
                upstreamLinkArray.add(this.copyDefaultLink(link));
            }
        }
    }

    private void calcECMPShortestPathGraph(List<String> deviceIdListToAvoid, List<Link> linksToAvoid) {
        this.deviceQueue.add(this.rootDevice);
        int currDistance = 0;
        this.distanceQueue.add(currDistance);
        this.deviceSearched.put(this.rootDevice, currDistance);
        boolean foundLinkToAvoid = false;
        while (!this.deviceQueue.isEmpty()) {
            DeviceId sw = this.deviceQueue.poll();
            DeviceId prevSw = null;
            currDistance = this.distanceQueue.poll();
            for (Link link : this.srManager.linkService.getDeviceEgressLinks(sw)) {
                ArrayList<Object> upstreamLinkArray;
                for (Link linkToAvoid : linksToAvoid) {
                    if (!this.linkContains(link, linksToAvoid)) continue;
                    foundLinkToAvoid = true;
                    break;
                }
                if (foundLinkToAvoid) {
                    foundLinkToAvoid = false;
                    continue;
                }
                DeviceId reachedDevice = link.dst().deviceId();
                if (deviceIdListToAvoid.contains(reachedDevice.toString()) || prevSw != null && prevSw.equals((Object)reachedDevice)) continue;
                prevSw = reachedDevice;
                Integer distance = this.deviceSearched.get(reachedDevice);
                if (distance != null && distance < currDistance + 1) continue;
                if (distance == null) {
                    this.deviceQueue.add(reachedDevice);
                    this.distanceQueue.add(currDistance + 1);
                    this.deviceSearched.put(reachedDevice, currDistance + 1);
                    ArrayList<Object> distanceSwArray = this.distanceDeviceMap.get(currDistance + 1);
                    if (distanceSwArray == null) {
                        distanceSwArray = new ArrayList();
                        distanceSwArray.add(reachedDevice);
                        this.distanceDeviceMap.put(currDistance + 1, distanceSwArray);
                    } else {
                        distanceSwArray.add(reachedDevice);
                    }
                }
                if ((upstreamLinkArray = this.upstreamLinks.get(reachedDevice)) == null) {
                    upstreamLinkArray = new ArrayList();
                    upstreamLinkArray.add(this.copyDefaultLink(link));
                    this.upstreamLinks.put(reachedDevice, upstreamLinkArray);
                    continue;
                }
                upstreamLinkArray.add(this.copyDefaultLink(link));
            }
        }
    }

    private boolean linkContains(Link link, List<Link> links) {
        DeviceId srcDevice1 = link.src().deviceId();
        DeviceId dstDevice1 = link.dst().deviceId();
        long srcPort1 = link.src().port().toLong();
        long dstPort1 = link.dst().port().toLong();
        for (Link link2 : links) {
            DeviceId srcDevice2 = link2.src().deviceId();
            DeviceId dstDevice2 = link2.dst().deviceId();
            long srcPort2 = link2.src().port().toLong();
            long dstPort2 = link2.dst().port().toLong();
            if (!srcDevice1.toString().equals(srcDevice2.toString()) || !dstDevice1.toString().equals(dstDevice2.toString()) || srcPort1 != srcPort2 || dstPort1 != dstPort2) continue;
            return true;
        }
        return false;
    }

    private void getDFSPaths(DeviceId dstDeviceDeviceId, Path path, ArrayList<Path> paths) {
        DeviceId rootDeviceDeviceId = this.rootDevice;
        for (Link upstreamLink : this.upstreamLinks.get(dstDeviceDeviceId)) {
            ArrayList<Link> sofarLinks = new ArrayList<Link>();
            if (path != null && !path.links().isEmpty()) {
                sofarLinks.addAll(path.links());
            }
            sofarLinks.add(upstreamLink);
            DefaultPath sofarPath = new DefaultPath(ProviderId.NONE, sofarLinks, 0.0, new Annotations[0]);
            if (upstreamLink.src().deviceId().equals((Object)rootDeviceDeviceId)) {
                paths.add((Path)sofarPath);
                return;
            }
            this.getDFSPaths(upstreamLink.src().deviceId(), (Path)sofarPath, paths);
        }
    }

    public DeviceId getRootDevice() {
        return this.rootDevice;
    }

    public ArrayList<Path> getECMPPaths(DeviceId targetDevice) {
        ArrayList<Object> pathArray = this.paths.get(targetDevice);
        if (pathArray == null && this.deviceSearched.containsKey(targetDevice)) {
            pathArray = new ArrayList();
            DeviceId sw = targetDevice;
            this.getDFSPaths(sw, null, pathArray);
            this.paths.put(targetDevice, pathArray);
        }
        return pathArray;
    }

    public HashMap<Integer, HashMap<DeviceId, ArrayList<Path>>> getCompleteLearnedDeviceesAndPaths() {
        HashMap<Integer, HashMap<DeviceId, ArrayList<Path>>> pathGraph = new HashMap<Integer, HashMap<DeviceId, ArrayList<Path>>>();
        for (Integer itrIndx : this.distanceDeviceMap.keySet()) {
            HashMap<DeviceId, ArrayList<Path>> swMap = new HashMap<DeviceId, ArrayList<Path>>();
            for (DeviceId sw : this.distanceDeviceMap.get(itrIndx)) {
                swMap.put(sw, this.getECMPPaths(sw));
            }
            pathGraph.put(itrIndx, swMap);
        }
        return pathGraph;
    }

    public HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> getAllLearnedSwitchesAndVia() {
        HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> deviceViaMap = new HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>>();
        for (Integer itrIndx : this.distanceDeviceMap.keySet()) {
            HashMap swMap = new HashMap();
            for (DeviceId sw : this.distanceDeviceMap.get(itrIndx)) {
                ArrayList swViaArray = new ArrayList();
                for (Path path : this.getECMPPaths(sw)) {
                    ArrayList<DeviceId> swVia = new ArrayList<DeviceId>();
                    for (Link link : path.links()) {
                        if (link.src().deviceId().equals((Object)this.rootDevice)) continue;
                        swVia.add(link.src().deviceId());
                    }
                    swViaArray.add(swVia);
                }
                swMap.put(sw, swViaArray);
            }
            deviceViaMap.put(itrIndx, swMap);
        }
        return deviceViaMap;
    }

    private Link copyDefaultLink(Link link) {
        DefaultLink src = (DefaultLink)link;
        DefaultLink defaultLink = DefaultLink.builder().providerId(src.providerId()).src(src.src()).dst(src.dst()).type(src.type()).annotations(src.annotations()).build();
        return defaultLink;
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        for (Device device : this.srManager.deviceService.getDevices()) {
            if (device.id() == this.rootDevice) continue;
            sBuilder.append("\r\n Paths from " + this.rootDevice + " to " + device.id() + "\r\n");
            ArrayList<Path> paths = this.getECMPPaths(device.id());
            if (paths == null) continue;
            for (Path path : paths) {
                sBuilder.append("\r\n == ");
                for (Link link : path.links()) {
                    sBuilder.append(" : " + link.src() + " -> " + link.dst());
                }
            }
        }
        return sBuilder.toString();
    }
}

