/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.segmentrouting.Tunnel;

public class DefaultTunnel
implements Tunnel {
    private final String id;
    private final List<Integer> labelIds;
    private int groupId;
    private boolean allowedToRemoveGroup;

    public DefaultTunnel(String tid, List<Integer> labelIds) {
        this.id = (String)Preconditions.checkNotNull((Object)tid);
        this.labelIds = labelIds;
        this.groupId = -1;
    }

    public DefaultTunnel(DefaultTunnel tunnel) {
        this.id = tunnel.id;
        this.labelIds = tunnel.labelIds;
        this.groupId = tunnel.groupId;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public List<Integer> labelIds() {
        return this.labelIds;
    }

    @Override
    public int groupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(int id) {
        this.groupId = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultTunnel) {
            DefaultTunnel tunnel = (DefaultTunnel)o;
            if (tunnel.labelIds.equals(this.labelIds)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.labelIds.hashCode();
    }

    @Override
    public boolean isAllowedToRemoveGroup() {
        return this.allowedToRemoveGroup;
    }

    @Override
    public void allowToRemoveGroup(boolean b) {
        this.allowedToRemoveGroup = b;
    }
}

