/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.segmentrouting.EcmpShortestPathGraph;
import org.onosproject.segmentrouting.RoutingRulePopulator;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.DeviceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutingHandler {
    private static final int MAX_CONSTANT_RETRY_ATTEMPTS = 5;
    private static final int RETRY_INTERVAL_MS = 250;
    private static final int RETRY_INTERVAL_SCALE = 1;
    private static final String ECMPSPG_MISSING = "ECMP shortest path graph not found";
    private static Logger log = LoggerFactory.getLogger(DefaultRoutingHandler.class);
    private SegmentRoutingManager srManager;
    private RoutingRulePopulator rulePopulator;
    private HashMap<DeviceId, EcmpShortestPathGraph> currentEcmpSpgMap;
    private HashMap<DeviceId, EcmpShortestPathGraph> updatedEcmpSpgMap;
    private DeviceConfiguration config;
    private final Lock statusLock = new ReentrantLock();
    private volatile Status populationStatus;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"retryftr", (String)"retry-%d", (Logger)log));

    public DefaultRoutingHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.rulePopulator = (RoutingRulePopulator)Preconditions.checkNotNull((Object)srManager.routingRulePopulator);
        this.config = (DeviceConfiguration)Preconditions.checkNotNull((Object)srManager.deviceConfiguration);
        this.populationStatus = Status.IDLE;
        this.currentEcmpSpgMap = Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateAllRoutingRules() {
        this.statusLock.lock();
        try {
            this.populationStatus = Status.STARTED;
            this.rulePopulator.resetCounter();
            log.info("Starting to populate segment-routing rules");
            log.debug("populateAllRoutingRules: populationStatus is STARTED");
            for (Device sw : this.srManager.deviceService.getDevices()) {
                if (!this.srManager.mastershipService.isLocalMaster(sw.id())) {
                    log.debug("populateAllRoutingRules: skipping device {}...we are not master", (Object)sw.id());
                    continue;
                }
                EcmpShortestPathGraph ecmpSpg = new EcmpShortestPathGraph(sw.id(), this.srManager);
                if (!this.populateEcmpRoutingRules(sw.id(), ecmpSpg, (Set<IpPrefix>)ImmutableSet.of())) {
                    log.debug("populateAllRoutingRules: populationStatus is ABORTED");
                    this.populationStatus = Status.ABORTED;
                    log.debug("Abort routing rule population");
                    boolean bl = false;
                    return bl;
                }
                this.currentEcmpSpgMap.put(sw.id(), ecmpSpg);
            }
            log.debug("populateAllRoutingRules: populationStatus is SUCCEEDED");
            this.populationStatus = Status.SUCCEEDED;
            log.info("Completed routing rule population. Total # of rules pushed : {}", (Object)this.rulePopulator.getCounter());
            boolean bl = true;
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateRoutingRulesForLinkStatusChange(Link failedLink) {
        this.statusLock.lock();
        try {
            if (this.populationStatus == Status.STARTED) {
                log.warn("Previous rule population is not finished.");
                boolean bl = true;
                return bl;
            }
            this.updatedEcmpSpgMap = new HashMap();
            for (Device sw : this.srManager.deviceService.getDevices()) {
                if (!this.srManager.mastershipService.isLocalMaster(sw.id())) continue;
                EcmpShortestPathGraph ecmpSpgUpdated = new EcmpShortestPathGraph(sw.id(), this.srManager);
                this.updatedEcmpSpgMap.put(sw.id(), ecmpSpgUpdated);
            }
            log.info("Starts rule population from link change");
            log.trace("populateRoutingRulesForLinkStatusChange: populationStatus is STARTED");
            this.populationStatus = Status.STARTED;
            Set<ArrayList<DeviceId>> routeChanges = failedLink == null ? this.computeRouteChange() : this.computeDamagedRoutes(failedLink);
            if (routeChanges == null) {
                boolean bl = this.populateAllRoutingRules();
                return bl;
            }
            if (routeChanges.isEmpty()) {
                log.info("No route changes for the link status change");
                log.debug("populateRoutingRulesForLinkStatusChange: populationStatus is SUCCEEDED");
                this.populationStatus = Status.SUCCEEDED;
                boolean bl = true;
                return bl;
            }
            if (this.repopulateRoutingRulesForRoutes(routeChanges)) {
                log.debug("populateRoutingRulesForLinkStatusChange: populationStatus is SUCCEEDED");
                this.populationStatus = Status.SUCCEEDED;
                log.info("Complete to repopulate the rules. # of rules populated : {}", (Object)this.rulePopulator.getCounter());
                boolean bl = true;
                return bl;
            }
            log.debug("populateRoutingRulesForLinkStatusChange: populationStatus is ABORTED");
            this.populationStatus = Status.ABORTED;
            log.warn("Failed to repopulate the rules.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    private boolean repopulateRoutingRulesForRoutes(Set<ArrayList<DeviceId>> routes) {
        ArrayList<ArrayList<DeviceId>> deviceRoutes;
        this.rulePopulator.resetCounter();
        HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> routesBydevice = new HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>();
        for (ArrayList<DeviceId> link : routes) {
            if (link.size() == 1) {
                log.trace("repopulateRoutingRulesForRoutes: running ECMP graph for device {}", (Object)link.get(0));
                EcmpShortestPathGraph ecmpSpg = new EcmpShortestPathGraph(link.get(0), this.srManager);
                if (this.populateEcmpRoutingRules(link.get(0), ecmpSpg, (Set<IpPrefix>)ImmutableSet.of())) {
                    log.debug("Populating flow rules from all to dest:{} is successful", (Object)link.get(0));
                    this.currentEcmpSpgMap.put(link.get(0), ecmpSpg);
                    continue;
                }
                log.warn("Failed to populate the flow rules from all to dest:{}", (Object)link.get(0));
                return false;
            }
            deviceRoutes = (ArrayList<ArrayList<DeviceId>>)routesBydevice.get(link.get(1));
            if (deviceRoutes == null) {
                deviceRoutes = new ArrayList<ArrayList<DeviceId>>();
                routesBydevice.put(link.get(1), deviceRoutes);
            }
            deviceRoutes.add(link);
        }
        for (DeviceId impactedDevice : routesBydevice.keySet()) {
            deviceRoutes = (ArrayList)routesBydevice.get(impactedDevice);
            for (ArrayList arrayList : deviceRoutes) {
                log.debug("repopulate RoutingRules For Routes {} -> {}", arrayList.get(0), arrayList.get(1));
                DeviceId src = (DeviceId)arrayList.get(0);
                DeviceId dst = (DeviceId)arrayList.get(1);
                EcmpShortestPathGraph ecmpSpg = this.updatedEcmpSpgMap.get(dst);
                HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> switchVia = ecmpSpg.getAllLearnedSwitchesAndVia();
                for (Integer itrIdx : switchVia.keySet()) {
                    HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> swViaMap = switchVia.get(itrIdx);
                    for (DeviceId targetSw : swViaMap.keySet()) {
                        if (!targetSw.equals((Object)src)) continue;
                        HashSet<DeviceId> nextHops = new HashSet<DeviceId>();
                        for (ArrayList<DeviceId> via : swViaMap.get(targetSw)) {
                            if (via.isEmpty()) {
                                nextHops.add(dst);
                                continue;
                            }
                            nextHops.add(via.get(0));
                        }
                        if (!this.populateEcmpRoutingRulePartial(targetSw, dst, nextHops, (Set<IpPrefix>)ImmutableSet.of())) {
                            return false;
                        }
                        log.debug("Populating flow rules from {} to {} is successful", (Object)targetSw, (Object)dst);
                    }
                }
            }
            this.currentEcmpSpgMap.put(impactedDevice, this.updatedEcmpSpgMap.get(impactedDevice));
        }
        return true;
    }

    private Set<ArrayList<DeviceId>> computeDamagedRoutes(Link linkFail) {
        HashSet<ArrayList<DeviceId>> routes = new HashSet<ArrayList<DeviceId>>();
        for (Device sw : this.srManager.deviceService.getDevices()) {
            log.debug("Computing the impacted routes for device {} due to link fail", (Object)sw.id());
            if (!this.srManager.mastershipService.isLocalMaster(sw.id())) {
                log.debug("No mastership for {} .. skipping route optimization", (Object)sw.id());
                continue;
            }
            EcmpShortestPathGraph ecmpSpg = this.currentEcmpSpgMap.get(sw.id());
            if (ecmpSpg == null) {
                log.warn("No existing ECMP graph for switch {}. Aborting optimized rerouting and opting for full-reroute", (Object)sw.id());
                return null;
            }
            HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> switchVia = ecmpSpg.getAllLearnedSwitchesAndVia();
            for (Integer itrIdx : switchVia.keySet()) {
                log.trace("Iterindex# {}", (Object)itrIdx);
                HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> swViaMap = switchVia.get(itrIdx);
                block2: for (DeviceId targetSw : swViaMap.keySet()) {
                    DeviceId rootSw = sw.id();
                    if (log.isTraceEnabled()) {
                        log.trace("TargetSwitch {} --> RootSwitch {}", (Object)targetSw, (Object)rootSw);
                        for (ArrayList<DeviceId> via : swViaMap.get(targetSw)) {
                            log.trace(" Via:");
                            via.forEach(e -> log.trace("  {}", e));
                        }
                    }
                    Set<ArrayList<DeviceId>> subLinks = this.computeLinks(targetSw, rootSw, swViaMap);
                    for (ArrayList<DeviceId> alink : subLinks) {
                        if ((!alink.get(0).equals((Object)linkFail.src().deviceId()) || !alink.get(1).equals((Object)linkFail.dst().deviceId())) && (!alink.get(0).equals((Object)linkFail.dst().deviceId()) || !alink.get(1).equals((Object)linkFail.src().deviceId()))) continue;
                        log.debug("Impacted route:{}->{}", (Object)targetSw, (Object)rootSw);
                        ArrayList<DeviceId> aRoute = new ArrayList<DeviceId>();
                        aRoute.add(targetSw);
                        aRoute.add(rootSw);
                        routes.add(aRoute);
                        continue block2;
                    }
                }
            }
        }
        return routes;
    }

    private Set<ArrayList<DeviceId>> computeRouteChange() {
        ImmutableSet.Builder changedRoutesBuilder = ImmutableSet.builder();
        for (Device sw : this.srManager.deviceService.getDevices()) {
            EcmpShortestPathGraph currEcmpSpg;
            DeviceId rootSw = sw.id();
            log.debug("Computing the impacted routes for device {}", (Object)rootSw);
            if (!this.srManager.mastershipService.isLocalMaster(rootSw)) {
                log.debug("No mastership for {} ... skipping route optimization", (Object)rootSw);
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("link of {} - ", (Object)rootSw);
                for (Link link : this.srManager.linkService.getDeviceLinks(rootSw)) {
                    log.trace("{} -> {} ", (Object)link.src().deviceId(), (Object)link.dst().deviceId());
                }
            }
            if ((currEcmpSpg = this.currentEcmpSpgMap.get(rootSw)) == null) {
                log.debug("No existing ECMP graph for device {}", (Object)rootSw);
                changedRoutesBuilder.add((Object)Lists.newArrayList((Object[])new DeviceId[]{rootSw}));
                continue;
            }
            EcmpShortestPathGraph newEcmpSpg = this.updatedEcmpSpgMap.get(rootSw);
            if (log.isTraceEnabled()) {
                log.trace("Root switch: {}", (Object)rootSw);
                log.trace("  Current/Existing SPG: {}", (Object)currEcmpSpg);
                log.trace("       New/Updated SPG: {}", (Object)newEcmpSpg);
            }
            changedRoutesBuilder.addAll(this.compareGraphs(newEcmpSpg, currEcmpSpg, rootSw));
            changedRoutesBuilder.addAll(this.compareGraphs(currEcmpSpg, newEcmpSpg, rootSw));
        }
        ImmutableSet changedRoutes = changedRoutesBuilder.build();
        for (ArrayList route : changedRoutes) {
            log.debug("Route changes Target -> Root");
            if (route.size() == 1) {
                log.debug(" : all -> {}", route.get(0));
                continue;
            }
            log.debug(" : {} -> {}", route.get(0), route.get(1));
        }
        return changedRoutes;
    }

    private Set<ArrayList<DeviceId>> compareGraphs(EcmpShortestPathGraph base, EcmpShortestPathGraph comp, DeviceId rootSw) {
        ImmutableSet.Builder changedRoutesBuilder = ImmutableSet.builder();
        HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> baseMap = base.getAllLearnedSwitchesAndVia();
        HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> compMap = comp.getAllLearnedSwitchesAndVia();
        for (Integer itrIdx : baseMap.keySet()) {
            HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> baseViaMap = baseMap.get(itrIdx);
            for (DeviceId targetSw : baseViaMap.keySet()) {
                ArrayList<ArrayList<DeviceId>> basePath = baseViaMap.get(targetSw);
                ArrayList<ArrayList<DeviceId>> compPath = this.getVia(compMap, targetSw);
                if (compPath != null && basePath.equals(compPath)) continue;
                log.debug("Impacted route:{} -> {}", (Object)targetSw, (Object)rootSw);
                ArrayList<DeviceId> route = new ArrayList<DeviceId>();
                route.add(targetSw);
                route.add(rootSw);
                changedRoutesBuilder.add(route);
            }
        }
        return changedRoutesBuilder.build();
    }

    private ArrayList<ArrayList<DeviceId>> getVia(HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> switchVia, DeviceId targetSw) {
        for (Integer itrIdx : switchVia.keySet()) {
            HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> swViaMap = switchVia.get(itrIdx);
            if (swViaMap.get(targetSw) == null) continue;
            return swViaMap.get(targetSw);
        }
        return null;
    }

    private Set<ArrayList<DeviceId>> computeLinks(DeviceId src, DeviceId dst, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> viaMap) {
        HashSet subLinks = Sets.newHashSet();
        for (ArrayList<DeviceId> via : viaMap.get(src)) {
            DeviceId linkSrc = src;
            DeviceId linkDst = dst;
            for (DeviceId viaDevice : via) {
                ArrayList<DeviceId> link = new ArrayList<DeviceId>();
                linkDst = viaDevice;
                link.add(linkSrc);
                link.add(linkDst);
                subLinks.add(link);
                linkSrc = viaDevice;
            }
            ArrayList<DeviceId> link = new ArrayList<DeviceId>();
            link.add(linkSrc);
            link.add(dst);
            subLinks.add(link);
        }
        return subLinks;
    }

    private boolean populateEcmpRoutingRules(DeviceId destSw, EcmpShortestPathGraph ecmpSPG, Set<IpPrefix> subnets) {
        HashMap<Integer, HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>>> switchVia = ecmpSPG.getAllLearnedSwitchesAndVia();
        for (Integer itrIdx : switchVia.keySet()) {
            HashMap<DeviceId, ArrayList<ArrayList<DeviceId>>> swViaMap = switchVia.get(itrIdx);
            for (DeviceId targetSw : swViaMap.keySet()) {
                HashSet<DeviceId> nextHops = new HashSet<DeviceId>();
                log.debug("** Iter: {} root: {} target: {}", new Object[]{itrIdx, destSw, targetSw});
                for (ArrayList<DeviceId> via : swViaMap.get(targetSw)) {
                    if (via.isEmpty()) {
                        nextHops.add(destSw);
                        continue;
                    }
                    nextHops.add(via.get(0));
                }
                if (this.populateEcmpRoutingRulePartial(targetSw, destSw, nextHops, subnets)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean populateEcmpRoutingRulePartial(DeviceId targetSw, DeviceId destSw, Set<DeviceId> nextHops, Set<IpPrefix> subnets) {
        boolean result;
        Ip6Address destRouterIpv6;
        Ip4Address destRouterIpv4;
        boolean destIsEdge;
        boolean targetIsEdge;
        if (nextHops.isEmpty()) {
            nextHops.add(destSw);
        }
        try {
            targetIsEdge = this.config.isEdgeDevice(targetSw);
            destIsEdge = this.config.isEdgeDevice(destSw);
            destRouterIpv4 = this.config.getRouterIpv4(destSw);
            destRouterIpv6 = this.config.getRouterIpv6(destSw);
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting populateEcmpRoutingRulePartial.");
            return false;
        }
        if (targetIsEdge && destIsEdge) {
            subnets = subnets != null && !subnets.isEmpty() ? subnets : this.config.getSubnets(destSw);
            log.debug("* populateEcmpRoutingRulePartial in device {} towards {} for subnets {}", new Object[]{targetSw, destSw, subnets});
            result = this.rulePopulator.populateIpRuleForSubnet(targetSw, subnets, destSw, nextHops);
            if (!result) {
                return false;
            }
            IpPrefix routerIpPrefix = destRouterIpv4.toIpPrefix();
            log.debug("* populateEcmpRoutingRulePartial in device {} towards {} for router IP {}", new Object[]{targetSw, destSw, routerIpPrefix});
            result = this.rulePopulator.populateIpRuleForRouter(targetSw, routerIpPrefix, destSw, nextHops);
            if (!result) {
                return false;
            }
            if (destRouterIpv6 != null) {
                routerIpPrefix = destRouterIpv6.toIpPrefix();
                log.debug("* populateEcmpRoutingRulePartial in device {} towards {} for v6 router IP {}", new Object[]{targetSw, destSw, routerIpPrefix});
                result = this.rulePopulator.populateIpRuleForRouter(targetSw, routerIpPrefix, destSw, nextHops);
                if (!result) {
                    return false;
                }
            }
        } else if (targetIsEdge) {
            IpPrefix routerIpPrefix = destRouterIpv4.toIpPrefix();
            log.debug("* populateEcmpRoutingRulePartial in device {} towards {} for router IP {}", new Object[]{targetSw, destSw, routerIpPrefix});
            result = this.rulePopulator.populateIpRuleForRouter(targetSw, routerIpPrefix, destSw, nextHops);
            if (!result) {
                return false;
            }
            if (destRouterIpv6 != null) {
                routerIpPrefix = destRouterIpv6.toIpPrefix();
                log.debug("* populateEcmpRoutingRulePartial in device {} towards {} for v6 router IP {}", new Object[]{targetSw, destSw, routerIpPrefix});
                result = this.rulePopulator.populateIpRuleForRouter(targetSw, routerIpPrefix, destSw, nextHops);
                if (!result) {
                    return false;
                }
            }
        }
        log.debug("* populateEcmpRoutingRulePartial in device{} towards {} for all MPLS rules", (Object)targetSw, (Object)destSw);
        result = this.rulePopulator.populateMplsRule(targetSw, destSw, nextHops, (IpAddress)destRouterIpv4);
        if (!result) {
            return false;
        }
        return destRouterIpv6 == null || (result = this.rulePopulator.populateMplsRule(targetSw, destSw, nextHops, (IpAddress)destRouterIpv6));
    }

    public void populatePortAddressingRules(DeviceId deviceId) {
        PortFilterInfo firstRun = this.rulePopulator.populateVlanMacFilters(deviceId);
        if (firstRun == null) {
            firstRun = new PortFilterInfo(0, 0, 0);
        }
        this.executorService.schedule(new RetryFilters(deviceId, firstRun), 250L, TimeUnit.MILLISECONDS);
    }

    public void startPopulationProcess() {
        this.statusLock.lock();
        try {
            if (this.populationStatus == Status.IDLE || this.populationStatus == Status.SUCCEEDED || this.populationStatus == Status.ABORTED) {
                this.populationStatus = Status.STARTED;
                this.populateAllRoutingRules();
            } else {
                log.warn("Not initiating startPopulationProcess as populationStatus is {}", (Object)this.populationStatus);
            }
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void resumePopulationProcess() {
        this.statusLock.lock();
        try {
            if (this.populationStatus == Status.ABORTED) {
                this.populationStatus = Status.STARTED;
                this.populateAllRoutingRules();
            }
        }
        finally {
            this.statusLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean populateSubnet(ConnectPoint cp, Set<IpPrefix> subnets) {
        this.statusLock.lock();
        try {
            EcmpShortestPathGraph ecmpSpg = this.currentEcmpSpgMap.get(cp.deviceId());
            if (ecmpSpg == null) {
                log.warn("Fail to populating subnet {}: {}", subnets, (Object)ECMPSPG_MISSING);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.populateEcmpRoutingRules(cp.deviceId(), ecmpSpg, subnets);
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    protected boolean revokeSubnet(Set<IpPrefix> subnets) {
        this.statusLock.lock();
        try {
            boolean bl = this.srManager.routingRulePopulator.revokeIpRuleForSubnet(subnets);
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    protected void purgeEcmpGraph(DeviceId deviceId) {
        this.currentEcmpSpgMap.remove(deviceId);
        if (this.updatedEcmpSpgMap != null) {
            this.updatedEcmpSpgMap.remove(deviceId);
        }
        this.populateRoutingRulesForLinkStatusChange(null);
    }

    protected final class RetryFilters
    implements Runnable {
        int constantAttempts = 5;
        DeviceId devId;
        int counter;
        PortFilterInfo prevRun;

        private RetryFilters(DeviceId deviceId, PortFilterInfo previousRun) {
            this.devId = deviceId;
            this.prevRun = previousRun;
            this.counter = 0;
        }

        @Override
        public void run() {
            log.debug("RETRY FILTER ATTEMPT {} ** dev:{}", (Object)(++this.counter), (Object)this.devId);
            PortFilterInfo thisRun = DefaultRoutingHandler.this.rulePopulator.populateVlanMacFilters(this.devId);
            boolean sameResult = this.prevRun.equals(thisRun);
            log.debug("dev:{} prevRun:{} thisRun:{} sameResult:{}", new Object[]{this.devId, this.prevRun, thisRun, sameResult});
            if (thisRun == null || !sameResult || sameResult && --this.constantAttempts > 0) {
                DefaultRoutingHandler.this.executorService.schedule(this, (long)(250 * (int)Math.pow(this.counter, 1.0)), TimeUnit.MILLISECONDS);
                if (!sameResult) {
                    this.constantAttempts = 5;
                }
            }
            this.prevRun = thisRun == null ? this.prevRun : thisRun;
        }
    }

    public final class PortFilterInfo {
        int disabledPorts = 0;
        int errorPorts = 0;
        int filteredPorts = 0;

        public PortFilterInfo(int disabledPorts, int errorPorts, int filteredPorts) {
            this.disabledPorts = disabledPorts;
            this.filteredPorts = filteredPorts;
            this.errorPorts = errorPorts;
        }

        public int hashCode() {
            return Objects.hash(this.disabledPorts, this.filteredPorts, this.errorPorts);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof PortFilterInfo)) {
                return false;
            }
            PortFilterInfo other = (PortFilterInfo)obj;
            return this.disabledPorts == other.disabledPorts && this.filteredPorts == other.filteredPorts && this.errorPorts == other.errorPorts;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("disabledPorts", this.disabledPorts).add("errorPorts", this.errorPorts).add("filteredPorts", this.filteredPorts);
            return helper.toString();
        }
    }

    public static enum Status {
        IDLE,
        STARTED,
        ABORTED,
        SUCCEEDED;

    }
}

