/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.ARP;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.host.HostService;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.SegmentRoutingNeighbourHandler;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArpHandler
extends SegmentRoutingNeighbourHandler {
    private static Logger log = LoggerFactory.getLogger(ArpHandler.class);

    public ArpHandler(SegmentRoutingManager srManager) {
        super(srManager);
    }

    public void processPacketIn(NeighbourMessageContext pkt, HostService hostService) {
        SegmentRoutingAppConfig appConfig = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, SegmentRoutingAppConfig.class);
        if (appConfig != null && appConfig.suppressSubnet().contains(pkt.inPort())) {
            pkt.drop();
            return;
        }
        if (!this.validateArpSpa(pkt)) {
            log.debug("Ignore ARP packet discovered on {} with unexpected src protocol address {}.", (Object)pkt.inPort(), (Object)pkt.sender().getIp4Address());
            pkt.drop();
            return;
        }
        if (pkt.type() == NeighbourMessageType.REQUEST) {
            this.handleArpRequest(pkt, hostService);
        } else {
            this.handleArpReply(pkt, hostService);
        }
    }

    private void handleArpRequest(NeighbourMessageContext pkt, HostService hostService) {
        if (this.isArpForRouter(pkt)) {
            MacAddress targetMac = this.config.getRouterMacForAGatewayIp((IpAddress)pkt.target().getIp4Address());
            this.sendResponse(pkt, targetMac, hostService);
        }
    }

    private void handleArpReply(NeighbourMessageContext pkt, HostService hostService) {
        if (this.isArpForRouter(pkt)) {
            Ip4Address hostIpAddress = pkt.sender().getIp4Address();
            this.srManager.ipHandler.forwardPackets(pkt.inPort().deviceId(), hostIpAddress);
        }
    }

    private boolean validateArpSpa(NeighbourMessageContext pkt) {
        Ip4Address spa = pkt.sender().getIp4Address();
        Set subnet = this.config.getPortSubnets(pkt.inPort().deviceId(), pkt.inPort().port()).stream().filter(ipPrefix -> ipPrefix.isIp4() && ipPrefix.contains((IpAddress)spa)).collect(Collectors.toSet());
        return !subnet.isEmpty();
    }

    private boolean isArpForRouter(NeighbourMessageContext pkt) {
        Ip4Address targetProtocolAddress = pkt.target().getIp4Address();
        Set<IpAddress> gatewayIpAddresses = null;
        try {
            if (targetProtocolAddress.equals((Object)this.config.getRouterIpv4(pkt.inPort().deviceId()))) {
                return true;
            }
            gatewayIpAddresses = this.config.getPortIPs(pkt.inPort().deviceId());
        }
        catch (DeviceConfigNotFoundException e) {
            log.warn(e.getMessage() + " Aborting check for router IP in processing arp");
        }
        return gatewayIpAddresses != null && gatewayIpAddresses.contains(targetProtocolAddress);
    }

    public void sendArpRequest(DeviceId deviceId, IpAddress targetAddress, ConnectPoint inPort) {
        byte[] senderMacAddress = new byte[6];
        byte[] senderIpAddress = new byte[4];
        if (!this.getSenderInfo(senderMacAddress, senderIpAddress, deviceId, targetAddress)) {
            log.warn("Aborting sendArpRequest, we cannot get all the information needed");
            return;
        }
        Ethernet arpRequest = ARP.buildArpRequest((byte[])senderMacAddress, (byte[])senderIpAddress, (byte[])targetAddress.toOctets(), (short)0);
        this.flood(arpRequest, inPort, targetAddress);
    }
}

