/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.segmentrouting;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultObjectiveContext;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.segmentrouting.SegmentRoutingManager;
import org.onosproject.segmentrouting.config.DeviceConfigNotFoundException;
import org.onosproject.segmentrouting.config.SegmentRoutingAppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(AppConfigHandler.class);
    private final SegmentRoutingManager srManager;
    private final DeviceService deviceService;

    public AppConfigHandler(SegmentRoutingManager srManager) {
        this.srManager = srManager;
        this.deviceService = srManager.deviceService;
    }

    protected void processAppConfigAdded(NetworkConfigEvent event) {
        log.info("Processing AppConfig CONFIG_ADDED");
        SegmentRoutingAppConfig config = (SegmentRoutingAppConfig)((Object)event.config().get());
        this.deviceService.getAvailableDevices().forEach(device -> this.populateVRouter(device.id(), this.getMacAddresses(config)));
    }

    protected void processAppConfigUpdated(NetworkConfigEvent event) {
        log.info("Processing AppConfig CONFIG_UPDATED");
        SegmentRoutingAppConfig config = (SegmentRoutingAppConfig)((Object)event.config().get());
        SegmentRoutingAppConfig prevConfig = (SegmentRoutingAppConfig)((Object)event.prevConfig().get());
        this.deviceService.getAvailableDevices().forEach(device -> {
            HashSet<MacAddress> macAddresses = new HashSet<MacAddress>(this.getMacAddresses(config));
            HashSet<MacAddress> prevMacAddresses = new HashSet<MacAddress>(this.getMacAddresses(prevConfig));
            HashSet<MacAddress> sameMacAddresses = new HashSet<MacAddress>(macAddresses);
            sameMacAddresses.retainAll(prevMacAddresses);
            macAddresses.removeAll(sameMacAddresses);
            prevMacAddresses.removeAll(sameMacAddresses);
            this.revokeVRouter(device.id(), prevMacAddresses);
            this.populateVRouter(device.id(), macAddresses);
        });
    }

    protected void processAppConfigRemoved(NetworkConfigEvent event) {
        log.info("Processing AppConfig CONFIG_REMOVED");
        SegmentRoutingAppConfig prevConfig = (SegmentRoutingAppConfig)((Object)event.prevConfig().get());
        this.deviceService.getAvailableDevices().forEach(device -> this.revokeVRouter(device.id(), this.getMacAddresses(prevConfig)));
    }

    public void init(DeviceId deviceId) {
        SegmentRoutingAppConfig config = (SegmentRoutingAppConfig)this.srManager.cfgService.getConfig((Object)this.srManager.appId, SegmentRoutingAppConfig.class);
        this.populateVRouter(deviceId, this.getMacAddresses(config));
    }

    private void populateVRouter(DeviceId deviceId, Set<MacAddress> pendingAdd) {
        if (!this.isEdge(deviceId)) {
            return;
        }
        this.getVRouterFlowObjBuilders(pendingAdd).forEach(foBuilder -> {
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("vRouterMac filter for {} populated", (Object)pendingAdd), (objective, error) -> log.warn("Failed to populate vRouterMac filter for {}: {}", (Object)pendingAdd, error));
            this.srManager.flowObjectiveService.filter(deviceId, foBuilder.add((ObjectiveContext)context));
        });
    }

    private void revokeVRouter(DeviceId deviceId, Set<MacAddress> pendingRemove) {
        if (!this.isEdge(deviceId)) {
            return;
        }
        this.getVRouterFlowObjBuilders(pendingRemove).forEach(foBuilder -> {
            DefaultObjectiveContext context = new DefaultObjectiveContext(objective -> log.debug("vRouterMac filter for {} revoked", (Object)pendingRemove), (objective, error) -> log.warn("Failed to revoke vRouterMac filter for {}: {}", (Object)pendingRemove, error));
            this.srManager.flowObjectiveService.filter(deviceId, foBuilder.remove((ObjectiveContext)context));
        });
    }

    private Set<FilteringObjective.Builder> getVRouterFlowObjBuilders(Set<MacAddress> macAddresses) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        macAddresses.forEach(macAddress -> {
            DefaultFilteringObjective.Builder fobuilder = DefaultFilteringObjective.builder();
            fobuilder.withKey(Criteria.matchInPort((PortNumber)PortNumber.ANY)).addCondition(Criteria.matchEthDst((MacAddress)macAddress)).permit().withPriority(100).fromApp(this.srManager.appId);
            setBuilder.add((Object)fobuilder);
        });
        return setBuilder.build();
    }

    private Set<MacAddress> getMacAddresses(SegmentRoutingAppConfig config) {
        if (config == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(config.vRouterMacs());
    }

    private boolean isEdge(DeviceId deviceId) {
        try {
            if (this.srManager.deviceConfiguration.isEdgeDevice(deviceId)) {
                return true;
            }
        }
        catch (DeviceConfigNotFoundException deviceConfigNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

