/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.dhcp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.onlab.packet.Ip4Address;

public final class IpAssignment {
    private final Ip4Address ipAddress;
    private final Date timestamp;
    private final long leasePeriod;
    private final Ip4Address subnetMask;
    private final Ip4Address broadcast;
    private final Ip4Address dhcpServer;
    private final Ip4Address routerAddress;
    private final Ip4Address domainServer;
    private final AssignmentStatus assignmentStatus;

    private IpAssignment(Ip4Address ipAddress, long leasePeriod, Date timestamp, AssignmentStatus assignmentStatus, Ip4Address subnetMask, Ip4Address broadcast, Ip4Address dhcpServer, Ip4Address routerAddress, Ip4Address domainServer) {
        this.ipAddress = ipAddress;
        this.leasePeriod = leasePeriod;
        this.timestamp = timestamp;
        this.assignmentStatus = assignmentStatus;
        this.subnetMask = subnetMask;
        this.broadcast = broadcast;
        this.dhcpServer = dhcpServer;
        this.routerAddress = routerAddress;
        this.domainServer = domainServer;
    }

    public Ip4Address ipAddress() {
        return this.ipAddress;
    }

    public Date timestamp() {
        return this.timestamp;
    }

    public AssignmentStatus assignmentStatus() {
        return this.assignmentStatus;
    }

    public int leasePeriod() {
        return (int)this.leasePeriod;
    }

    public int leasePeriodMs() {
        return (int)this.leasePeriod * 1000;
    }

    public Ip4Address subnetMask() {
        return this.subnetMask;
    }

    public Ip4Address broadcast() {
        return this.broadcast;
    }

    public Ip4Address dhcpServer() {
        return this.dhcpServer;
    }

    public Ip4Address routerAddress() {
        return this.routerAddress;
    }

    public Ip4Address domainServer() {
        return this.domainServer;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ip", (Object)this.ipAddress).add("timestamp", (Object)this.timestamp).add("lease", this.leasePeriod).add("assignmentStatus", (Object)this.assignmentStatus).add("subnetMask", (Object)this.subnetMask).add("broadcast", (Object)this.broadcast).add("dhcpServer", (Object)this.dhcpServer).add("routerAddress", (Object)this.routerAddress).add("domainServer", (Object)this.domainServer).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IpAssignment assignment) {
        return new Builder(assignment);
    }

    public static final class Builder {
        private Ip4Address ipAddress;
        private Date timeStamp;
        private long leasePeriod;
        private AssignmentStatus assignmentStatus;
        private Ip4Address subnetMask;
        private Ip4Address broadcast;
        private Ip4Address dhcpServer;
        private Ip4Address routerAddress;
        private Ip4Address domainServer;

        private Builder() {
        }

        private Builder(IpAssignment ipAssignment) {
            this.ipAddress = ipAssignment.ipAddress();
            this.timeStamp = ipAssignment.timestamp();
            this.leasePeriod = ipAssignment.leasePeriod();
            this.assignmentStatus = ipAssignment.assignmentStatus();
            this.subnetMask = ipAssignment.subnetMask();
            this.broadcast = ipAssignment.broadcast();
            this.dhcpServer = ipAssignment.dhcpServer();
            this.routerAddress = ipAssignment.routerAddress();
            this.domainServer = ipAssignment.domainServer();
        }

        public IpAssignment build() {
            this.validateInputs();
            return new IpAssignment(this.ipAddress, this.leasePeriod, this.timeStamp, this.assignmentStatus, this.subnetMask, this.broadcast, this.dhcpServer, this.routerAddress, this.domainServer);
        }

        public Builder ipAddress(Ip4Address addr) {
            this.ipAddress = addr;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timeStamp = timestamp;
            return this;
        }

        public Builder leasePeriod(int leasePeriodinSeconds) {
            this.leasePeriod = leasePeriodinSeconds;
            return this;
        }

        public Builder assignmentStatus(AssignmentStatus status) {
            this.assignmentStatus = status;
            return this;
        }

        public Builder subnetMask(Ip4Address subnetMask) {
            this.subnetMask = subnetMask;
            return this;
        }

        public Builder broadcast(Ip4Address broadcast) {
            this.broadcast = broadcast;
            return this;
        }

        public Builder dhcpServer(Ip4Address dhcpServer) {
            this.dhcpServer = dhcpServer;
            return this;
        }

        public Builder domainServer(Ip4Address domainServer) {
            this.domainServer = domainServer;
            return this;
        }

        public Builder routerAddress(Ip4Address routerAddress) {
            this.routerAddress = routerAddress;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)this.ipAddress, (Object)"IP Address must be specified");
            Preconditions.checkNotNull((Object)((Object)this.assignmentStatus), (Object)"Assignment Status must be specified");
            Preconditions.checkNotNull((Object)this.leasePeriod, (Object)"Lease Period must be specified");
            Preconditions.checkNotNull((Object)this.timeStamp, (Object)"Timestamp must be specified");
            switch (this.assignmentStatus) {
                case Option_Requested: 
                case Option_RangeNotEnforced: 
                case Option_Assigned: 
                case Option_Expired: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown assignment status");
                }
            }
        }
    }

    public static enum AssignmentStatus {
        Option_Requested,
        Option_RangeNotEnforced,
        Option_Assigned,
        Option_Expired;

    }
}

