/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.isis.topology.impl;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Bandwidth;
import org.onosproject.isis.controller.IsisController;
import org.onosproject.isis.controller.topology.IsisLink;
import org.onosproject.isis.controller.topology.IsisLinkListener;
import org.onosproject.isis.controller.topology.IsisLinkTed;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.controller.topology.IsisRouterId;
import org.onosproject.isis.controller.topology.IsisRouterListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class IsisTopologyProvider
extends AbstractProvider
implements DeviceProvider,
LinkProvider {
    public static final long PSEUDO_PORT = -1L;
    public static final String ADMINISTRATIVEGROUP = "administrativeGroup";
    public static final String TE_METRIC = "teMetric";
    public static final String MAXRESERVABLEBANDWIDTH = "maxReservableBandwidth";
    public static final String ROUTERID = "routerId";
    public static final String NEIGHBORID = "neighborId";
    private static final Logger log = LoggerFactory.getLogger(IsisTopologyProvider.class);
    private static final String UNKNOWN = "unknown";
    final InternalTopologyProvider listener = new InternalTopologyProvider();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IsisController controller;
    private LinkProviderService linkProviderService;
    private DeviceProviderService deviceProviderService;
    private HashMap<DeviceId, List<PortDescription>> portMap = new HashMap();

    public IsisTopologyProvider() {
        super(new ProviderId("l3", "org.onosproject.provider.isis"));
    }

    @Activate
    public void activate() {
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.controller.addRouterListener((IsisRouterListener)this.listener);
        this.controller.addLinkListener((IsisLinkListener)this.listener);
        log.debug("IsisDeviceProvider::activate...!!!!");
    }

    @Deactivate
    public void deactivate() {
        log.debug("IsisDeviceProvider::deactivate...!!!!");
        this.deviceProviderRegistry.unregister((Provider)this);
        this.deviceProviderService = null;
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeRouterListener((IsisRouterListener)this.listener);
        this.controller.removeLinkListener((IsisLinkListener)this.listener);
    }

    public void triggerProbe(DeviceId deviceId) {
        log.debug("IsisDeviceProvider::triggerProbe...!!!!");
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        log.debug("IsisDeviceProvider::roleChanged...!!!!");
    }

    public boolean isReachable(DeviceId deviceId) {
        log.debug("IsisDeviceProvider::isReachable...!!!!");
        return true;
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        log.debug("IsisDeviceProvider::changePortState...!!!!");
    }

    private LinkDescription buildLinkDes(IsisLink isisLink) {
        Preconditions.checkNotNull((Object)isisLink);
        long srcAddress = 0L;
        long dstAddress = 0L;
        boolean localPseduo = false;
        boolean remotePseduo = false;
        String localSystemId = isisLink.localSystemId();
        String remoteSystemId = isisLink.remoteSystemId();
        if (isisLink.interfaceIp() != null) {
            srcAddress = Long.parseUnsignedLong(Integer.toBinaryString(isisLink.interfaceIp().toInt()), 2);
        }
        if (isisLink.neighborIp() != null) {
            dstAddress = Long.parseUnsignedLong(Integer.toBinaryString(isisLink.neighborIp().toInt()), 2);
        }
        DeviceId srcId = DeviceId.deviceId((URI)IsisRouterId.uri((String)localSystemId));
        DeviceId dstId = DeviceId.deviceId((URI)IsisRouterId.uri((String)remoteSystemId));
        if (IsisTopologyProvider.checkIsDis(isisLink.localSystemId())) {
            localPseduo = true;
        } else if (IsisTopologyProvider.checkIsDis(isisLink.remoteSystemId())) {
            remotePseduo = true;
        } else {
            log.debug("IsisDeviceProvider::buildLinkDes : unknown type.!");
        }
        if (localPseduo && srcAddress == 0L) {
            srcAddress = -1L;
        } else if (remotePseduo && dstAddress == 0L) {
            dstAddress = -1L;
        }
        ConnectPoint src = new ConnectPoint((ElementId)srcId, PortNumber.portNumber((long)srcAddress));
        ConnectPoint dst = new ConnectPoint((ElementId)dstId, PortNumber.portNumber((long)dstAddress));
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        annotationBuilder = this.buildAnnotations(annotationBuilder, isisLink);
        return new DefaultLinkDescription(src, dst, Link.Type.DIRECT, false, new SparseAnnotations[]{annotationBuilder.build()});
    }

    public static boolean checkIsDis(String systemId) {
        StringTokenizer stringTokenizer = new StringTokenizer(systemId, ".-");
        int count = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int x;
            String str = stringTokenizer.nextToken();
            if (count == 3 && (x = Integer.parseInt(str)) > 0) {
                return true;
            }
            ++count;
        }
        return false;
    }

    private List<PortDescription> buildPortDescriptions(DeviceId deviceId, PortNumber portNumber) {
        List<Object> portList = this.portMap.containsKey(deviceId) ? this.portMap.get(deviceId) : new ArrayList();
        if (portNumber != null) {
            DefaultPortDescription portDescriptions = new DefaultPortDescription(portNumber, true, new SparseAnnotations[0]);
            portList.add((PortDescription)portDescriptions);
        }
        this.portMap.put(deviceId, portList);
        return portList;
    }

    private DefaultAnnotations.Builder buildAnnotations(DefaultAnnotations.Builder annotationBuilder, IsisLink isisLink) {
        int administrativeGroup = 0;
        long teMetric = 0L;
        Bandwidth maxReservableBandwidth = Bandwidth.bps((long)0L);
        String routerId = null;
        String neighborId = null;
        IsisLinkTed isisLinkTed = isisLink.linkTed();
        log.info("Ted Information:  {}", (Object)isisLinkTed.toString());
        administrativeGroup = isisLinkTed.administrativeGroup();
        teMetric = isisLinkTed.teDefaultMetric();
        maxReservableBandwidth = isisLinkTed.maximumReservableLinkBandwidth();
        routerId = isisLink.localSystemId();
        neighborId = isisLink.remoteSystemId();
        annotationBuilder.set(ADMINISTRATIVEGROUP, String.valueOf(administrativeGroup));
        annotationBuilder.set(TE_METRIC, String.valueOf(teMetric));
        annotationBuilder.set(MAXRESERVABLEBANDWIDTH, String.valueOf(maxReservableBandwidth));
        annotationBuilder.set(ROUTERID, String.valueOf(routerId));
        annotationBuilder.set(NEIGHBORID, String.valueOf(neighborId));
        return annotationBuilder;
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindController(IsisController isisController) {
        this.controller = isisController;
    }

    protected void unbindController(IsisController isisController) {
        if (this.controller == isisController) {
            this.controller = null;
        }
    }

    private class InternalTopologyProvider
    implements IsisRouterListener,
    IsisLinkListener {
        private InternalTopologyProvider() {
        }

        public void routerAdded(IsisRouter isisRouter) {
            String systemId = isisRouter.systemId();
            log.info("Added device {}", (Object)systemId);
            DeviceId deviceId = DeviceId.deviceId((URI)IsisRouterId.uri((String)systemId));
            Device.Type deviceType = Device.Type.ROUTER;
            deviceType = isisRouter.isDis() ? Device.Type.ROUTER : Device.Type.VIRTUAL;
            ChassisId cId = new ChassisId();
            DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
            newBuilder.set("type", "L3");
            newBuilder.set("RouterId", systemId);
            DefaultDeviceDescription description = new DefaultDeviceDescription(IsisRouterId.uri((String)systemId), deviceType, IsisTopologyProvider.UNKNOWN, IsisTopologyProvider.UNKNOWN, IsisTopologyProvider.UNKNOWN, IsisTopologyProvider.UNKNOWN, cId, new SparseAnnotations[]{newBuilder.build()});
            IsisTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
            System.out.println("Device added: " + systemId);
        }

        public void routerRemoved(IsisRouter isisRouter) {
            String systemId = isisRouter.systemId();
            log.info("Delete device {}", (Object)systemId);
            DeviceId deviceId = DeviceId.deviceId((URI)IsisRouterId.uri((String)systemId));
            if (IsisTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            IsisTopologyProvider.this.deviceProviderService.deviceDisconnected(deviceId);
            log.info("delete device {}", (Object)systemId);
        }

        public void addLink(IsisLink isisLink) {
            log.debug("Addlink {}", (Object)isisLink.localSystemId());
            LinkDescription linkDes = IsisTopologyProvider.this.buildLinkDes(isisLink);
            if (IsisTopologyProvider.this.linkService.getLink(linkDes.src(), linkDes.dst()) != null || IsisTopologyProvider.this.linkProviderService == null) {
                return;
            }
            ConnectPoint destconnectPoint = linkDes.dst();
            PortNumber destport = destconnectPoint.port();
            if (destport.toLong() != 0L) {
                IsisTopologyProvider.this.deviceProviderService.updatePorts(linkDes.src().deviceId(), IsisTopologyProvider.this.buildPortDescriptions(linkDes.src().deviceId(), linkDes.src().port()));
                IsisTopologyProvider.this.deviceProviderService.updatePorts(linkDes.dst().deviceId(), IsisTopologyProvider.this.buildPortDescriptions(linkDes.dst().deviceId(), linkDes.dst().port()));
                this.registerBandwidth(linkDes, isisLink);
                IsisTopologyProvider.this.linkProviderService.linkDetected(linkDes);
                System.out.println("link desc " + linkDes.toString());
            }
        }

        public void deleteLink(IsisLink isisLink) {
            log.debug("Delete link {}", (Object)isisLink.localSystemId());
            if (IsisTopologyProvider.this.linkProviderService == null) {
                return;
            }
            LinkDescription linkDes = IsisTopologyProvider.this.buildLinkDes(isisLink);
            IsisTopologyProvider.this.linkProviderService.linkVanished(linkDes);
        }

        private void registerBandwidth(LinkDescription linkDes, IsisLink isisLink) {
            if (isisLink == null) {
                log.error("Could not able to register bandwidth ");
                return;
            }
            IsisLinkTed isisLinkTed = isisLink.linkTed();
            Bandwidth maxReservableBw = isisLinkTed.maximumReservableLinkBandwidth();
            if (maxReservableBw != null) {
                if (maxReservableBw.compareTo(Bandwidth.bps((long)0L)) == 0) {
                    return;
                }
                BandwidthCapacity config = (BandwidthCapacity)IsisTopologyProvider.this.networkConfigService.addConfig((Object)linkDes.src(), BandwidthCapacity.class);
                config.capacity(maxReservableBw).apply();
                config = (BandwidthCapacity)IsisTopologyProvider.this.networkConfigService.addConfig((Object)linkDes.dst(), BandwidthCapacity.class);
                config.capacity(maxReservableBw).apply();
            }
        }
    }
}

