/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.net;

import java.util.Collections;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteAdminService;

@Command(scope="onos", name="route-remove", description="Removes a route from the route table")
public class RouteRemoveCommand
extends AbstractShellCommand {
    @Argument(index=0, name="prefix", description="IP prefix of the route", required=true)
    String prefixString = null;
    @Argument(index=1, name="nextHop", description="IP address of the next hop", required=true)
    String nextHopString = null;

    @Override
    protected void execute() {
        RouteAdminService service = AbstractShellCommand.get(RouteAdminService.class);
        IpPrefix prefix = IpPrefix.valueOf((String)this.prefixString);
        IpAddress nextHop = IpAddress.valueOf((String)this.nextHopString);
        service.withdraw(Collections.singleton(new Route(Route.Source.STATIC, prefix, nextHop)));
    }
}

