/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cli.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.onosproject.cli.AbstractChoicesCompleter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.SubjectFactory;

public class ConfigKeyCompleter
extends AbstractChoicesCompleter {
    @Override
    protected List<String> choices() {
        NetworkConfigRegistry service = AbstractShellCommand.get(NetworkConfigRegistry.class);
        ArgumentCompleter.ArgumentList args = this.getArgumentList();
        Preconditions.checkArgument((args.getCursorArgumentIndex() >= 2 ? 1 : 0) != 0);
        String subjectClassKey = args.getArguments()[args.getCursorArgumentIndex() - 2];
        SubjectFactory subjectFactory = service.getSubjectFactory(subjectClassKey);
        if (subjectFactory == null) {
            return ImmutableList.of();
        }
        String subjectKey = args.getArguments()[args.getCursorArgumentIndex() - 1];
        Object subject = subjectFactory.createSubject(subjectKey);
        Set configs = service.getConfigs(subject);
        return configs.stream().map(Config::key).collect(Collectors.toList());
    }
}

