/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.client.impl;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class Utils {
    private static final String XMLNS_STRING = "xmlns=\"ne-l3vpn-api\"";
    private static final String XMLNS_HUA_STRING = "xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"";

    private Utils() {
    }

    private static String formatMessage(String request) {
        if (request.contains(XMLNS_STRING)) {
            request = request.replaceFirst(XMLNS_STRING, XMLNS_HUA_STRING);
        }
        return request;
    }

    static String editConfig(String encodedString) {
        StringBuilder rpc = new StringBuilder("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\" message-id=\"1\">");
        rpc.append("<edit-config>");
        rpc.append("<target>");
        rpc.append("<running/>");
        rpc.append("</target>");
        encodedString = Utils.formatMessage(encodedString);
        rpc.append(encodedString);
        rpc.append("</edit-config>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    static String prettyFormat(String input) {
        StreamSource xmlInput = new StreamSource(new StringReader(input));
        StringWriter stringWriter = new StringWriter();
        StreamResult xmlOutput = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        if (transformer != null) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            try {
                transformer.transform(xmlInput, xmlOutput);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return xmlOutput.getWriter().toString();
    }
}

