/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.client.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.DeviceId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.onosproject.netconf.TargetConfig;
import org.onosproject.netconf.client.NetconfTranslator;
import org.onosproject.netconf.client.impl.Utils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaContextProvider;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.Annotation;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.DefaultAnnotatedNodeInfo;
import org.onosproject.yang.runtime.DefaultAnnotation;
import org.onosproject.yang.runtime.DefaultCompositeData;
import org.onosproject.yang.runtime.DefaultCompositeStream;
import org.onosproject.yang.runtime.DefaultRuntimeContext;
import org.onosproject.yang.runtime.DefaultYangSerializerContext;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.YangRuntimeService;
import org.onosproject.yang.runtime.YangSerializerContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Service
@Component(immediate=true)
public class NetconfTranslatorImpl
implements NetconfTranslator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private NodeId localNodeId;
    private static final String GET_CONFIG_MESSAGE_REGEX = "<data>\n?\\s*(.*?)\n?\\s*</data>";
    private static final int GET_CONFIG_CORE_MESSAGE_GROUP = 1;
    private static final Pattern GET_CONFIG_CORE_MESSAGE_PATTERN = Pattern.compile("<data>\n?\\s*(.*?)\n?\\s*</data>", 32);
    private static final String GET_CORE_MESSAGE_REGEX = "<data>\n?\\s*(.*?)\n?\\s*</data>";
    private static final int GET_CORE_MESSAGE_GROUP = 1;
    private static final Pattern GET_CORE_MESSAGE_PATTERN = Pattern.compile("<data>\n?\\s*(.*?)\n?\\s*</data>", 32);
    private static final String NETCONF_1_0_BASE_NAMESPACE = "urn:ietf:params:xml:ns:netconf:base:1.0";
    private static final String GET_URI = "urn:ietf:params:xml:ns:yang:yrt-ietf-network:networks/network/node";
    private static final String XML_ENCODING_SPECIFIER = "xml";
    private static final String OP_SPECIFIER = "xc:operation";
    private static final String REPLACE_OP_SPECIFIER = "replace";
    private static final String DELETE_OP_SPECIFIER = "delete";
    private static final String XMLNS_XC_SPECIFIER = "xmlns:xc";
    private static final String XMLNS_SPECIFIER = "xmlns";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetconfController netconfController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected YangRuntimeService yangRuntimeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SchemaContextProvider schemaContextProvider;

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public ResourceData getDeviceConfig(DeviceId deviceId) throws IOException {
        NetconfSession session = this.getNetconfSession(deviceId);
        String reply = session.getConfig(TargetConfig.RUNNING);
        Matcher protocolStripper = GET_CONFIG_CORE_MESSAGE_PATTERN.matcher(reply);
        reply = protocolStripper.group(1);
        return this.yangRuntimeService.decode((CompositeStream)new DefaultCompositeStream(null, (InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))), new DefaultRuntimeContext.Builder().setDataFormat(XML_ENCODING_SPECIFIER).addAnnotation((Annotation)new DefaultAnnotation(XMLNS_SPECIFIER, NETCONF_1_0_BASE_NAMESPACE)).build()).resourceData();
    }

    @Override
    public boolean editDeviceConfig(DeviceId deviceId, ResourceData resourceData, NetconfTranslator.OperationType operationType) throws IOException {
        NetconfSession session = this.getNetconfSession(deviceId);
        SchemaContext context = this.schemaContextProvider.getSchemaContext(ResourceId.builder().addBranchPointSchema("/", null).build());
        ResourceData modifiedPathResourceData = NetconfTranslatorImpl.getResourceData(resourceData.resourceId(), resourceData.dataNodes(), (YangSerializerContext)new DefaultYangSerializerContext(context, null));
        DefaultCompositeData.Builder compositeDataBuilder = DefaultCompositeData.builder().resourceData(modifiedPathResourceData);
        for (Object node : resourceData.dataNodes()) {
            ResourceId resourceId = resourceData.resourceId();
            if (operationType != NetconfTranslator.OperationType.DELETE) {
                resourceId = NetconfTranslatorImpl.getAnnotatedNodeResourceId(resourceData.resourceId(), node);
            }
            if (resourceId == null) continue;
            DefaultAnnotatedNodeInfo.Builder annotatedNodeInfo = DefaultAnnotatedNodeInfo.builder();
            annotatedNodeInfo.resourceId(resourceId);
            annotatedNodeInfo.addAnnotation((Annotation)new DefaultAnnotation(OP_SPECIFIER, operationType == NetconfTranslator.OperationType.DELETE ? DELETE_OP_SPECIFIER : REPLACE_OP_SPECIFIER));
            compositeDataBuilder.addAnnotatedNodeInfo(annotatedNodeInfo.build());
        }
        CompositeStream config = this.yangRuntimeService.encode(compositeDataBuilder.build(), new DefaultRuntimeContext.Builder().setDataFormat(XML_ENCODING_SPECIFIER).addAnnotation((Annotation)new DefaultAnnotation(XMLNS_XC_SPECIFIER, NETCONF_1_0_BASE_NAMESPACE)).build());
        try {
            Object node;
            node = session.requestSync(Utils.editConfig(this.streamToString(config.resourceData())));
        }
        catch (NetconfException e) {
            this.log.error("failed to send a request sync", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public ResourceData getDeviceState(DeviceId deviceId) throws IOException {
        NetconfSession session = this.getNetconfSession(deviceId);
        String reply = session.get(null, null);
        Matcher protocolStripper = GET_CORE_MESSAGE_PATTERN.matcher(reply);
        reply = protocolStripper.group(1);
        return this.yangRuntimeService.decode((CompositeStream)new DefaultCompositeStream(null, (InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))), new DefaultRuntimeContext.Builder().setDataFormat(XML_ENCODING_SPECIFIER).addAnnotation((Annotation)new DefaultAnnotation(XMLNS_SPECIFIER, NETCONF_1_0_BASE_NAMESPACE)).build()).resourceData();
    }

    private NetconfSession getNetconfSession(DeviceId deviceId) {
        NetconfDevice device = this.netconfController.getNetconfDevice(deviceId);
        Preconditions.checkNotNull((Object)device, (Object)"The specified deviceId could not be found by the NETCONF controller.");
        NetconfSession session = device.getSession();
        Preconditions.checkNotNull((Object)session, (Object)"A session could not be retrieved for the specified deviceId.");
        return session;
    }

    private String streamToString(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        String nextLine = reader.readLine();
        while (nextLine != null) {
            builder.append(nextLine);
            nextLine = reader.readLine();
        }
        return builder.toString();
    }

    public static ResourceData getResourceData(ResourceId rid, List<DataNode> nodes, YangSerializerContext cont) {
        if (rid == null) {
            DefaultResourceData.Builder resData = DefaultResourceData.builder();
            for (DataNode node : nodes) {
                resData.addDataNode(node);
            }
            return resData.build();
        }
        List keys = rid.nodeKeys();
        Iterator it = keys.iterator();
        DataNode.Builder dbr = SerializerHelper.initializeDataNode((YangSerializerContext)cont);
        while (it.hasNext()) {
            NodeKey nodekey = (NodeKey)it.next();
            SchemaId sid = nodekey.schemaId();
            dbr = SerializerHelper.addDataNode((DataNode.Builder)dbr, (String)sid.name(), (String)sid.namespace(), null, null);
            if (!(nodekey instanceof ListKey)) continue;
            for (KeyLeaf keyLeaf : ((ListKey)nodekey).keyLeafs()) {
                String val = keyLeaf.leafValue() == null ? null : keyLeaf.leafValAsString();
                dbr = SerializerHelper.addDataNode((DataNode.Builder)dbr, (String)keyLeaf.leafSchema().name(), (String)sid.namespace(), (String)val, (DataNode.Type)DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE);
            }
        }
        if (!(dbr instanceof LeafNode.Builder) || nodes != null || !nodes.isEmpty()) {
            // empty if block
        }
        if (nodes != null && !nodes.isEmpty()) {
            for (DataNode node : nodes) {
                dbr = ((InnerNode.Builder)dbr).addNode(node);
            }
        }
        DefaultResourceData.Builder resData = DefaultResourceData.builder();
        resData.addDataNode(dbr.build());
        resData.resourceId(null);
        return resData.build();
    }

    public static ResourceId getAnnotatedNodeResourceId(ResourceId rid, DataNode node) {
        ResourceId.Builder rIdBldr = ResourceId.builder();
        if (rid != null) {
            try {
                rIdBldr = rid.copyBuilder();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            rIdBldr.addBranchPointSchema("/", null);
        }
        DataNode.Type type = node.type();
        NodeKey k = node.key();
        SchemaId sid = k.schemaId();
        switch (type) {
            case MULTI_INSTANCE_LEAF_VALUE_NODE: {
                String val = ((LeafListKey)k).value().toString();
                rIdBldr.addLeafListBranchPoint(sid.name(), sid.namespace(), (Object)val);
                break;
            }
            case MULTI_INSTANCE_NODE: {
                rIdBldr.addBranchPointSchema(sid.name(), sid.namespace());
                for (KeyLeaf keyLeaf : ((ListKey)node.key()).keyLeafs()) {
                    String val = keyLeaf.leafValAsString();
                    rIdBldr.addKeyLeaf(keyLeaf.leafSchema().name(), sid.namespace(), (Object)val);
                }
                break;
            }
            case SINGLE_INSTANCE_LEAF_VALUE_NODE: 
            case SINGLE_INSTANCE_NODE: {
                rIdBldr.addBranchPointSchema(sid.name(), sid.namespace());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return rIdBldr.build();
    }

    protected void bindNetconfController(NetconfController netconfController) {
        this.netconfController = netconfController;
    }

    protected void unbindNetconfController(NetconfController netconfController) {
        if (this.netconfController == netconfController) {
            this.netconfController = null;
        }
    }

    protected void bindYangRuntimeService(YangRuntimeService yangRuntimeService) {
        this.yangRuntimeService = yangRuntimeService;
    }

    protected void unbindYangRuntimeService(YangRuntimeService yangRuntimeService) {
        if (this.yangRuntimeService == yangRuntimeService) {
            this.yangRuntimeService = null;
        }
    }

    protected void bindSchemaContextProvider(SchemaContextProvider schemaContextProvider) {
        this.schemaContextProvider = schemaContextProvider;
    }

    protected void unbindSchemaContextProvider(SchemaContextProvider schemaContextProvider) {
        if (this.schemaContextProvider == schemaContextProvider) {
            this.schemaContextProvider = null;
        }
    }
}

