/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.client.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onosproject.config.DynamicConfigEvent;
import org.onosproject.config.DynamicConfigListener;
import org.onosproject.config.DynamicConfigService;
import org.onosproject.config.Filter;
import org.onosproject.config.ResourceIdParser;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.client.NetconfTranslator;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.KeyLeaf;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public class NetconfActiveComponent
implements DynamicConfigListener {
    private static final Logger log = LoggerFactory.getLogger(NetconfActiveComponent.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DynamicConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetconfTranslator netconfTranslator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetconfController controller;
    private final Accumulator<DynamicConfigEvent> accumulator = new InternalEventAccummulator();
    private static final String DEVNMSPACE = "ne-l3vpn-api";
    private static final String DEVICES = "devices";
    private static final String DEVICE = "device";
    private static final String DEVICE_ID = "deviceid";
    private static final String DEF_IP = "0:0:0";
    private static final int MAX_EVENTS = 1000;
    private static final int MAX_BATCH_MS = 5000;
    private static final int MAX_IDLE_MS = 1000;
    private ResourceId defParent = new ResourceId.Builder().addBranchPointSchema("devices", "ne-l3vpn-api").addBranchPointSchema("device", "ne-l3vpn-api").addKeyLeaf("deviceid", "ne-l3vpn-api", (Object)"0:0:0").build();
    private static final String EXCPATH = "root|devices#ne-l3vpn-api|device#ne-l3vpn-api$deviceid#ne-l3vpn-api#netconf:172.16.5.11:22|l3vpn#ne-l3vpn-api|l3vpncomm#ne-l3vpn-api|l3vpnInstances#ne-l3vpn-api|l3vpnInstance#ne-l3vpn-api$vrfName#ne-l3vpn-api#vrf2|l3vpnIfs#ne-l3vpn-api";

    @Activate
    protected void activate() {
        this.cfgService.addListener((EventListener)this);
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.removeListener((EventListener)this);
        log.info("Stopped");
    }

    public boolean isRelevant(DynamicConfigEvent event) {
        String resId = ResourceIdParser.parseResId((ResourceId)((ResourceId)event.subject()));
        String refId = ResourceIdParser.parseResId((ResourceId)this.defParent);
        if (!resId.contains(refId = refId.substring(0, refId.length() - (DEF_IP.length() + 1)))) {
            return false;
        }
        if (resId.length() < refId.length()) {
            return false;
        }
        return resId.substring(0, refId.length()).compareTo(refId) == 0;
    }

    public boolean isMaster(DeviceId deviceId) {
        return this.mastershipService.isLocalMaster(deviceId);
    }

    public void event(DynamicConfigEvent event) {
        this.accumulator.add((Object)event);
    }

    private boolean configDelete(DataNode node, DeviceId deviceId, ResourceId resourceId) {
        return this.parseAndEdit(node, deviceId, resourceId, NetconfTranslator.OperationType.DELETE);
    }

    private boolean configUpdate(DataNode node, DeviceId deviceId, ResourceId resourceId) {
        return this.parseAndEdit(node, deviceId, resourceId, NetconfTranslator.OperationType.REPLACE);
    }

    private boolean parseAndEdit(DataNode node, DeviceId deviceId, ResourceId resourceId, NetconfTranslator.OperationType operationType) {
        DefaultResourceData.Builder builder = DefaultResourceData.builder();
        if (node != null) {
            Iterator it = ((InnerNode)node).childNodes().entrySet().iterator();
            while (it.hasNext()) {
                DataNode n = (DataNode)it.next().getValue();
                if (n.key().schemaId().name().equals(DEVICE_ID)) continue;
                builder.addDataNode(n);
            }
        }
        try {
            return this.netconfTranslator.editDeviceConfig(deviceId, builder.build(), operationType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Beta
    public DeviceId getDeviceId(DataNode node) {
        String port;
        String ip;
        if (node.type() == DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE) {
            String[] temp = ((LeafNode)node).asString().split("\\:");
            if (temp.length != 3) {
                throw new RuntimeException((Throwable)new NetconfException("Invalid device id form, cannot apply"));
            }
            ip = temp[1];
            port = temp[2];
        } else if (node.type() == DataNode.Type.MULTI_INSTANCE_NODE) {
            ListKey key = (ListKey)node.key();
            String[] temp = ((KeyLeaf)key.keyLeafs().get(0)).leafValAsString().split("\\:");
            if (temp.length != 3) {
                throw new RuntimeException((Throwable)new NetconfException("Invalid device id form, cannot apply"));
            }
            ip = temp[1];
            port = temp[2];
        } else {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id type, cannot apply"));
        }
        try {
            return DeviceId.deviceId((URI)new URI("netconf", ip + ":" + port, null));
        }
        catch (URISyntaxException var4) {
            throw new IllegalArgumentException("Unable to build deviceID for device " + ip + ":" + port, var4);
        }
    }

    private void initiateConnection(DeviceId deviceId) {
        if (this.controller.getNetconfDevice(deviceId) == null) {
            try {
                this.controller.connectDevice(deviceId);
            }
            catch (Exception ex) {
                throw new RuntimeException((Throwable)new NetconfException("Unable to connect to NETCONF device on " + deviceId, (Throwable)ex));
            }
        }
    }

    @Beta
    public ResourceId getDeviceKey(ResourceId path) {
        String resId = ResourceIdParser.parseResId((ResourceId)path);
        String[] el = resId.split("\\|");
        if (el.length < 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid resource id, cannot apply"));
        }
        if (!el[2].contains("$")) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        String[] keys = el[2].split("\\$");
        if (keys.length < 2) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        String[] parts = keys[1].split("\\#");
        if (parts.length < 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        if (parts[2].split("\\:").length != 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id form, cannot apply"));
        }
        return new ResourceId.Builder().addBranchPointSchema(el[1].split("\\#")[0], el[1].split("\\#")[1]).addBranchPointSchema(keys[0].split("\\#")[0], keys[0].split("\\#")[1]).addKeyLeaf(parts[0], parts[1], (Object)parts[2]).build();
    }

    @Beta
    public DeviceId getDeviceId(ResourceId path) {
        String resId = ResourceIdParser.parseResId((ResourceId)path);
        String[] el = resId.split("\\|");
        if (el.length < 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid resource id, cannot apply"));
        }
        if (!el[2].contains("$")) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        String[] keys = el[2].split("\\$");
        if (keys.length < 2) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        String[] parts = keys[1].split("\\#");
        if (parts.length < 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id key, cannot apply"));
        }
        String[] temp = parts[2].split("\\:");
        if (temp.length != 3) {
            throw new RuntimeException((Throwable)new NetconfException("Invalid device id form, cannot apply"));
        }
        String ip = temp[1];
        String port = temp[2];
        try {
            return DeviceId.deviceId((URI)new URI("netconf", ip + ":" + port, null));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unable to build deviceID for device " + ip + ":" + port, ex);
        }
    }

    protected void bindCfgService(DynamicConfigService dynamicConfigService) {
        this.cfgService = dynamicConfigService;
    }

    protected void unbindCfgService(DynamicConfigService dynamicConfigService) {
        if (this.cfgService == dynamicConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindNetconfTranslator(NetconfTranslator netconfTranslator) {
        this.netconfTranslator = netconfTranslator;
    }

    protected void unbindNetconfTranslator(NetconfTranslator netconfTranslator) {
        if (this.netconfTranslator == netconfTranslator) {
            this.netconfTranslator = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindController(NetconfController netconfController) {
        this.controller = netconfController;
    }

    protected void unbindController(NetconfController netconfController) {
        if (this.controller == netconfController) {
            this.controller = null;
        }
    }

    private class InternalEventAccummulator
    extends AbstractAccumulator<DynamicConfigEvent> {
        protected InternalEventAccummulator() {
            super(new Timer("dyncfgevt-timer"), 1000, 5000, 1000);
        }

        public void processItems(List<DynamicConfigEvent> events) {
            LinkedHashMap<ResourceId, List> evtmap = new LinkedHashMap<ResourceId, List>();
            Boolean handleEx = false;
            ResourceId exId = null;
            for (DynamicConfigEvent e : events) {
                Preconditions.checkNotNull((Object)e, (Object)"process:Event cannot be null");
                ResourceId cur = (ResourceId)e.subject();
                String expat = ResourceIdParser.parseResId((ResourceId)cur);
                if (expat.compareTo(NetconfActiveComponent.EXCPATH) == 0 && e.type() == DynamicConfigEvent.Type.NODE_ADDED) {
                    handleEx = true;
                    exId = cur;
                    continue;
                }
                ResourceId key = NetconfActiveComponent.this.getDeviceKey((ResourceId)e.subject());
                ArrayList<DynamicConfigEvent> el = (ArrayList<DynamicConfigEvent>)evtmap.get(key);
                if (el == null) {
                    el = new ArrayList<DynamicConfigEvent>();
                }
                el.add(e);
                evtmap.put(key, el);
            }
            evtmap.forEach((k, v) -> {
                DeviceId curDevice = NetconfActiveComponent.this.getDeviceId((ResourceId)k);
                if (!NetconfActiveComponent.this.isMaster(curDevice)) {
                    log.info("NetConfListener: not master, ignoring config for device {}", k);
                    return;
                }
                NetconfActiveComponent.this.initiateConnection(curDevice);
                block4: for (DynamicConfigEvent curEvt : v) {
                    switch ((DynamicConfigEvent.Type)curEvt.type()) {
                        case NODE_ADDED: 
                        case NODE_UPDATED: 
                        case NODE_REPLACED: {
                            Filter filt = new Filter();
                            DataNode node = NetconfActiveComponent.this.cfgService.readNode(k, filt);
                            NetconfActiveComponent.this.configUpdate(node, curDevice, k);
                            continue block4;
                        }
                        case NODE_DELETED: {
                            NetconfActiveComponent.this.configDelete(null, curDevice, k);
                            continue block4;
                        }
                    }
                    log.warn("NetConfListener: unknown event: {}", (Object)curEvt.type());
                }
            });
            if (handleEx.booleanValue()) {
                DeviceId exDevice = NetconfActiveComponent.this.getDeviceId(exId);
                if (!NetconfActiveComponent.this.isMaster(exDevice)) {
                    log.info("NetConfListener: not master, ignoring config for expath {}", exId);
                    return;
                }
                NetconfActiveComponent.this.initiateConnection(exDevice);
                Filter filt = new Filter();
                DataNode exnode = NetconfActiveComponent.this.cfgService.readNode(exId, filt);
                NetconfActiveComponent.this.configUpdate(exnode, exDevice, exId);
            }
        }
    }
}

