/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetunnel.api.tunnel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TtpKey;
import org.onosproject.tetunnel.api.tunnel.TeTunnel;
import org.onosproject.tetunnel.api.tunnel.TeTunnelKey;
import org.onosproject.tetunnel.api.tunnel.path.TePath;

public class DefaultTeTunnel
implements TeTunnel {
    private final TeTunnelKey teTunnelKey;
    private final String name;
    private final TeTunnel.Type type;
    private final TeTunnel.LspProtectionType lspProtectionType;
    private final TeTunnel.State adminState;
    private final TeNodeKey srcNode;
    private final TeNodeKey dstNode;
    private final TtpKey srcTp;
    private final TtpKey dstTp;
    private final List<TePath> primaryPaths;
    private List<TeTunnelKey> segmentTunnels = null;
    private TeTunnelKey e2eTunnel = null;

    protected DefaultTeTunnel(TeTunnelKey teTunnelKey, String name, TeTunnel.Type type, TeTunnel.LspProtectionType lspProtectionType, TeTunnel.State adminState, TeNodeKey srcNode, TeNodeKey dstNode, TtpKey srcTp, TtpKey dstTp, List<TePath> primaryPaths) {
        this.teTunnelKey = teTunnelKey;
        this.name = name;
        this.type = type;
        this.lspProtectionType = lspProtectionType;
        this.adminState = adminState;
        this.srcNode = srcNode;
        this.dstNode = dstNode;
        this.srcTp = srcTp;
        this.dstTp = dstTp;
        this.primaryPaths = Lists.newArrayList(primaryPaths);
    }

    @Override
    public TeTunnelKey teTunnelKey() {
        return this.teTunnelKey;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TeTunnel.Type type() {
        return this.type;
    }

    @Override
    public TeTunnel.LspProtectionType lspProtectionType() {
        return this.lspProtectionType;
    }

    @Override
    public TeTunnel.State adminStatus() {
        return this.adminState;
    }

    @Override
    public TeNodeKey srcNode() {
        return this.srcNode;
    }

    @Override
    public TeNodeKey dstNode() {
        return this.dstNode;
    }

    @Override
    public List<TePath> primaryPaths() {
        return ImmutableList.copyOf(this.primaryPaths);
    }

    @Override
    public List<TeTunnelKey> segmentTunnels() {
        return ImmutableList.copyOf(this.segmentTunnels);
    }

    @Override
    public void segmentTunnels(List<TeTunnelKey> segmentTunnels) {
        this.segmentTunnels = Lists.newArrayList(segmentTunnels);
    }

    @Override
    public TeTunnelKey e2eTunnelKey() {
        return this.e2eTunnel;
    }

    @Override
    public void e2eTunnelKey(TeTunnelKey e2eTunnelKey) {
        this.e2eTunnel = e2eTunnelKey;
    }

    @Override
    public TtpKey srcTp() {
        return this.srcTp;
    }

    @Override
    public TtpKey dstTp() {
        return this.dstTp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TeTunnelKey teTunnelKey = null;
        private String name = "";
        private TeTunnel.Type type = null;
        private TeTunnel.LspProtectionType lspProtectionType = null;
        private TeTunnel.State adminState = TeTunnel.State.UP;
        private TeNodeKey srcNode = null;
        private TeNodeKey dstNode = null;
        private TtpKey srcTp = null;
        private TtpKey dstTp = null;
        private List<TePath> primaryPaths = Lists.newArrayList();

        public DefaultTeTunnel build() {
            return new DefaultTeTunnel(this.teTunnelKey, this.name, this.type, this.lspProtectionType, this.adminState, this.srcNode, this.dstNode, this.srcTp, this.dstTp, this.primaryPaths);
        }

        public Builder teTunnelKey(TeTunnelKey teTunnelKey) {
            this.teTunnelKey = teTunnelKey;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(TeTunnel.Type type) {
            this.type = type;
            return this;
        }

        public Builder lspProtectionType(TeTunnel.LspProtectionType lspProtectionType) {
            this.lspProtectionType = lspProtectionType;
            return this;
        }

        public Builder adminState(TeTunnel.State adminState) {
            this.adminState = adminState;
            return this;
        }

        public Builder srcNode(TeNodeKey srcNode) {
            this.srcNode = srcNode;
            return this;
        }

        public Builder dstNode(TeNodeKey dstNode) {
            this.dstNode = dstNode;
            return this;
        }

        public Builder srcTp(TtpKey srcTp) {
            this.srcTp = srcTp;
            return this;
        }

        public Builder dstTp(TtpKey dstTp) {
            this.dstTp = dstTp;
            return this;
        }

        public Builder primaryPaths(List<TePath> primaryPaths) {
            if (primaryPaths != null) {
                this.primaryPaths = primaryPaths;
            }
            return this;
        }
    }
}

