/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tetunnel.api.lsp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.tetopology.management.api.node.TeNodeKey;
import org.onosproject.tetopology.management.api.node.TtpKey;
import org.onosproject.tetunnel.api.lsp.TeLsp;
import org.onosproject.tetunnel.api.lsp.TeLspKey;
import org.onosproject.tetunnel.api.tunnel.TeTunnel;
import org.onosproject.tetunnel.api.tunnel.TeTunnelKey;
import org.onosproject.tetunnel.api.tunnel.path.TeRouteSubobject;

public class DefaultTeLsp
implements TeLsp {
    private final TeLspKey teLspKey;
    private final TeNodeKey srcNode;
    private final TeNodeKey dstNode;
    private final TtpKey srcTp;
    private final TtpKey dstTp;
    private final TeTunnelKey teTunnelKey;
    private final TeTunnel.Type tunnelType;
    private final TeTunnel.State operStatus;
    private final TeLsp.LspProtectionRole lspProtectionRole;
    private final TeLsp.OriginType originType;
    private final List<TeRouteSubobject> lspRecordRoutes;

    protected DefaultTeLsp(TeLspKey teLspKey, TeNodeKey srcNode, TeNodeKey dstNode, TtpKey srcTp, TtpKey dstTp, TeTunnelKey teTunnelKey, TeTunnel.Type tunnelType, TeTunnel.State operStatus, TeLsp.LspProtectionRole lspProtectionRole, TeLsp.OriginType originType, List<TeRouteSubobject> lspRecordRoutes) {
        this.srcNode = srcNode;
        this.dstNode = dstNode;
        this.srcTp = srcTp;
        this.dstTp = dstTp;
        this.teTunnelKey = teTunnelKey;
        this.tunnelType = tunnelType;
        this.operStatus = operStatus;
        this.lspProtectionRole = lspProtectionRole;
        this.originType = originType;
        this.lspRecordRoutes = Lists.newArrayList(lspRecordRoutes);
        this.teLspKey = teLspKey;
    }

    @Override
    public TeLspKey teLspKey() {
        return this.teLspKey;
    }

    @Override
    public TeNodeKey srcNode() {
        return this.srcNode;
    }

    @Override
    public TeNodeKey dstNode() {
        return this.dstNode;
    }

    @Override
    public TtpKey srcTp() {
        return this.srcTp;
    }

    @Override
    public TtpKey dstTp() {
        return this.dstTp;
    }

    @Override
    public TeTunnelKey teTunnelKey() {
        return this.teTunnelKey;
    }

    @Override
    public TeTunnel.Type tunnelType() {
        return this.tunnelType;
    }

    @Override
    public TeTunnel.State operStatus() {
        return this.operStatus;
    }

    @Override
    public TeLsp.LspProtectionRole lspProtectionRole() {
        return this.lspProtectionRole;
    }

    @Override
    public TeLsp.OriginType originType() {
        return this.originType;
    }

    @Override
    public List<TeRouteSubobject> lspRecordRoutes() {
        return ImmutableList.copyOf(this.lspRecordRoutes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TeLspKey teLspKey = null;
        private TeNodeKey srcNode = null;
        private TeNodeKey dstNode = null;
        private TtpKey srcTp = null;
        private TtpKey dstTp = null;
        private TeTunnelKey teTunnelKey = null;
        private TeTunnel.Type tunnelType = null;
        private TeTunnel.State operStatus = null;
        private TeLsp.LspProtectionRole lspProtectionRole = null;
        private TeLsp.OriginType originType = null;
        private List<TeRouteSubobject> lspRecordRoutes = Lists.newArrayList();

        public DefaultTeLsp build() {
            return new DefaultTeLsp(this.teLspKey, this.srcNode, this.dstNode, this.srcTp, this.dstTp, this.teTunnelKey, this.tunnelType, this.operStatus, this.lspProtectionRole, this.originType, this.lspRecordRoutes);
        }

        public Builder teLspKey(TeLspKey teLspKey) {
            this.teLspKey = teLspKey;
            return this;
        }

        public Builder srcNode(TeNodeKey srcNode) {
            this.srcNode = srcNode;
            return this;
        }

        public Builder dstNode(TeNodeKey dstNode) {
            this.dstNode = dstNode;
            return this;
        }

        public Builder srcTp(TtpKey srcTp) {
            this.srcTp = srcTp;
            return this;
        }

        public Builder dstTp(TtpKey dstTp) {
            this.dstTp = dstTp;
            return this;
        }

        public Builder teTunnelKey(TeTunnelKey teTunnelKey) {
            this.teTunnelKey = teTunnelKey;
            return this;
        }

        public Builder tunnelType(TeTunnel.Type tunnelType) {
            this.tunnelType = tunnelType;
            return this;
        }

        public Builder operStatus(TeTunnel.State operStatus) {
            this.operStatus = operStatus;
            return this;
        }

        public Builder lspProtectionRole(TeLsp.LspProtectionRole lspProtectionRole) {
            this.lspProtectionRole = lspProtectionRole;
            return this;
        }

        public Builder originType(TeLsp.OriginType originType) {
            this.originType = originType;
            return this;
        }

        public Builder lspRecordRoutes(List<TeRouteSubobject> lspRecordRoutes) {
            if (lspRecordRoutes != null) {
                this.lspRecordRoutes = lspRecordRoutes;
            }
            return this;
        }
    }
}

