/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.mapping.util;

import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.mapping.DefaultMappingKey;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.provider.lisp.mapping.util.MappingAddressBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingKeyBuilder {
    private static final Logger log = LoggerFactory.getLogger(MappingKeyBuilder.class);
    private final LispAfiAddress address;
    private final DeviceId deviceId;
    private final DeviceService deviceService;

    public MappingKeyBuilder(DeviceService deviceService, DeviceId deviceId, LispAfiAddress afiAddress) {
        this.deviceId = deviceId;
        this.address = afiAddress;
        this.deviceService = deviceService;
    }

    public MappingKey build() {
        MappingAddress mappingAddress = MappingAddressBuilder.getAddress(this.deviceService, this.deviceId, this.address);
        return DefaultMappingKey.builder().withAddress(mappingAddress).build();
    }
}

