/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.mapping.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.lisp.msg.protocols.LispLocator;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.mapping.DefaultMapping;
import org.onosproject.mapping.DefaultMappingEntry;
import org.onosproject.mapping.DefaultMappingKey;
import org.onosproject.mapping.DefaultMappingTreatment;
import org.onosproject.mapping.DefaultMappingValue;
import org.onosproject.mapping.Mapping;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.actions.MappingActions;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.provider.lisp.mapping.util.MappingAddressBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEntryBuilder {
    private static final Logger log = LoggerFactory.getLogger(MappingEntryBuilder.class);
    private final DeviceId deviceId;
    private final MappingAddress address;
    private final MappingAction action;
    private final List<MappingTreatment> treatments;
    private final DeviceService deviceService;

    public MappingEntryBuilder(DeviceId deviceId, LispMapRecord record, DeviceService deviceService) {
        this.deviceId = deviceId;
        this.address = this.buildAddress(record);
        this.action = this.buildAction(record);
        this.treatments = this.buildTreatments(record);
        this.deviceService = deviceService;
    }

    public MappingEntryBuilder(DeviceId deviceId, LispMapRecord record) {
        this.deviceId = deviceId;
        this.address = this.buildAddress(record);
        this.action = this.buildAction(record);
        this.treatments = this.buildTreatments(record);
        this.deviceService = null;
    }

    public MappingEntry build() {
        Mapping.Builder builder = DefaultMapping.builder().withId((long)this.buildKey().hashCode()).forDevice(this.deviceId).withKey(this.buildKey()).withValue(this.buildValue());
        return new DefaultMappingEntry(builder.build(), MappingEntry.MappingEntryState.ADDED);
    }

    private MappingKey buildKey() {
        MappingKey.Builder builder = DefaultMappingKey.builder();
        builder.withAddress(this.address);
        return builder.build();
    }

    private MappingValue buildValue() {
        MappingValue.Builder builder = DefaultMappingValue.builder();
        builder.withAction(this.action);
        this.treatments.forEach(arg_0 -> ((MappingValue.Builder)builder).add(arg_0));
        return builder.build();
    }

    private MappingAction buildAction(LispMapRecord record) {
        if (record == null) {
            return MappingActions.noAction();
        }
        switch (record.getAction()) {
            case NoAction: {
                return MappingActions.noAction();
            }
            case SendMapRequest: {
                return MappingActions.forward();
            }
            case NativelyForward: {
                return MappingActions.nativeForward();
            }
            case Drop: {
                return MappingActions.drop();
            }
        }
        log.warn("Unsupported action type {}", (Object)record.getAction());
        return MappingActions.noAction();
    }

    private MappingAddress buildAddress(LispMapRecord record) {
        return record == null ? null : MappingAddressBuilder.getAddress(this.deviceService, this.deviceId, record.getEidPrefixAfi());
    }

    private List<MappingTreatment> buildTreatments(LispMapRecord record) {
        List locators = record.getLocators();
        ArrayList treatments = Lists.newArrayList();
        for (LispLocator locator : locators) {
            DefaultMappingTreatment.Builder builder = DefaultMappingTreatment.builder();
            LispAfiAddress address = locator.getLocatorAfi();
            MappingAddress mappingAddress = MappingAddressBuilder.getAddress(this.deviceService, this.deviceId, address);
            if (mappingAddress != null) {
                builder.withAddress(mappingAddress);
            }
            builder.setUnicastWeight((int)locator.getWeight()).setUnicastPriority((int)locator.getPriority()).setMulticastWeight((int)locator.getMulticastWeight()).setMulticastPriority((int)locator.getMulticastPriority());
            treatments.add(builder.build());
        }
        return treatments;
    }
}

