/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.mapping.util;

import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.lisp.ctl.ExtensionMappingAddressInterpreter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispAsAddress;
import org.onosproject.lisp.msg.types.LispDistinguishedNameAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispMacAddress;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressType;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.addresses.MappingAddresses;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingAddressBuilder {
    private static final Logger log = LoggerFactory.getLogger(MappingAddressBuilder.class);
    private static final int IPV4_PREFIX_LENGTH = 32;
    private static final int IPV6_PREFIX_LENGTH = 128;

    private MappingAddressBuilder() {
    }

    protected static MappingAddress getAddress(DeviceService deviceService, DeviceId deviceId, LispAfiAddress address) {
        if (address == null) {
            log.warn("Address is not specified.");
            return null;
        }
        switch (address.getAfi()) {
            case IP4: {
                return MappingAddressBuilder.afi2mapping(address);
            }
            case IP6: {
                return MappingAddressBuilder.afi2mapping(address);
            }
            case AS: {
                int asNum = ((LispAsAddress)address).getASNum();
                return MappingAddresses.asMappingAddress((String)String.valueOf(asNum));
            }
            case DISTINGUISHED_NAME: {
                String dn = ((LispDistinguishedNameAddress)address).getDistinguishedName();
                return MappingAddresses.dnMappingAddress((String)dn);
            }
            case MAC: {
                MacAddress macAddress = ((LispMacAddress)address).getAddress();
                return MappingAddresses.ethMappingAddress((MacAddress)macAddress);
            }
            case LCAF: {
                return deviceService == null ? null : MappingAddressBuilder.lcaf2extension(deviceService, deviceId, (LispLcafAddress)address);
            }
        }
        log.warn("Unsupported address type {}", (Object)address.getAfi());
        return null;
    }

    private static MappingAddress afi2mapping(LispAfiAddress afiAddress) {
        switch (afiAddress.getAfi()) {
            case IP4: {
                IpAddress ipv4Address = ((LispIpv4Address)afiAddress).getAddress();
                IpPrefix ipv4Prefix = IpPrefix.valueOf((IpAddress)ipv4Address, (int)32);
                return MappingAddresses.ipv4MappingAddress((IpPrefix)ipv4Prefix);
            }
            case IP6: {
                IpAddress ipv6Address = ((LispIpv6Address)afiAddress).getAddress();
                IpPrefix ipv6Prefix = IpPrefix.valueOf((IpAddress)ipv6Address, (int)128);
                return MappingAddresses.ipv6MappingAddress((IpPrefix)ipv6Prefix);
            }
        }
        log.warn("Only support to convert IP address type");
        return null;
    }

    private static MappingAddress lcaf2extension(DeviceService deviceService, DeviceId deviceId, LispLcafAddress lcaf) {
        Device device = deviceService.getDevice(deviceId);
        ExtensionMappingAddress mappingAddress = null;
        ExtensionMappingAddressInterpreter addressInterpreter = device.is(ExtensionMappingAddressInterpreter.class) ? (ExtensionMappingAddressInterpreter)device.as(ExtensionMappingAddressInterpreter.class) : null;
        switch (lcaf.getType()) {
            case LIST: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.LIST_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case SEGMENT: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.SEGMENT_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case AS: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.AS_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case APPLICATION_DATA: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.APPLICATION_DATA_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case GEO_COORDINATE: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.GEO_COORDINATE_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case NAT: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.NAT_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case NONCE: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.NONCE_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case MULTICAST: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.MULTICAST_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case TRAFFIC_ENGINEERING: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.TRAFFIC_ENGINEERING_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            case SOURCE_DEST: {
                if (addressInterpreter == null || !addressInterpreter.supported(ExtensionMappingAddressType.ExtensionMappingAddressTypes.SOURCE_DEST_ADDRESS.type())) break;
                mappingAddress = addressInterpreter.mapLcafAddress(lcaf);
                break;
            }
            default: {
                log.warn("Unsupported extension mapping address type {}", (Object)lcaf.getType());
            }
        }
        return mappingAddress != null ? MappingAddresses.extensionMappingAddressWrapper(mappingAddress, (DeviceId)deviceId) : null;
    }
}

