/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.lisp.mapping.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.lisp.ctl.LispController;
import org.onosproject.lisp.ctl.LispMessageListener;
import org.onosproject.lisp.ctl.LispRouterId;
import org.onosproject.lisp.ctl.LispRouterListener;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMapReply;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingProvider;
import org.onosproject.mapping.MappingProviderRegistry;
import org.onosproject.mapping.MappingProviderService;
import org.onosproject.mapping.MappingStore;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.lisp.mapping.util.MappingEntryBuilder;
import org.onosproject.provider.lisp.mapping.util.MappingKeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LispMappingProvider
extends AbstractProvider
implements MappingProvider {
    private static final Logger log = LoggerFactory.getLogger(LispMappingProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LispController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MappingProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    protected MappingProviderService providerService;
    private static final String SCHEME_NAME = "lisp";
    private static final String MAPPING_PROVIDER_PACKAGE = "org.onosproject.lisp.provider.mapping";
    private final InternalMappingProvider listener = new InternalMappingProvider();

    public LispMappingProvider() {
        super(new ProviderId(SCHEME_NAME, MAPPING_PROVIDER_PACKAGE));
    }

    @Activate
    public void activate() {
        this.providerService = (MappingProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addRouterListener((LispRouterListener)this.listener);
        this.controller.addMessageListener((LispMessageListener)this.listener);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.controller.removeRouterListener((LispRouterListener)this.listener);
        this.controller.removeMessageListener((LispMessageListener)this.listener);
        this.providerService = null;
        log.info("Stopped");
    }

    private DeviceId getDeviceId(String ip) {
        try {
            return DeviceId.deviceId((URI)new URI(SCHEME_NAME, ip, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to build deviceID for device " + ip, e);
        }
    }

    protected void bindController(LispController lispController) {
        this.controller = lispController;
    }

    protected void unbindController(LispController lispController) {
        if (this.controller == lispController) {
            this.controller = null;
        }
    }

    protected void bindProviderRegistry(MappingProviderRegistry mappingProviderRegistry) {
        this.providerRegistry = mappingProviderRegistry;
    }

    protected void unbindProviderRegistry(MappingProviderRegistry mappingProviderRegistry) {
        if (this.providerRegistry == mappingProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private class InternalMappingProvider
    implements LispRouterListener,
    LispMessageListener {
        private InternalMappingProvider() {
        }

        public void routerAdded(LispRouterId routerId) {
        }

        public void routerRemoved(LispRouterId routerId) {
        }

        public void routerChanged(LispRouterId routerId) {
        }

        public void handleIncomingMessage(LispRouterId routerId, LispMessage msg) {
            if (LispMappingProvider.this.providerService == null) {
                log.warn("provider service has not been initialized");
                return;
            }
            DeviceId deviceId = LispMappingProvider.this.getDeviceId(routerId.toString());
            switch (msg.getType()) {
                case LISP_MAP_REQUEST: {
                    LispMapRequest request = (LispMapRequest)msg;
                    List records = request.getEids();
                    ArrayList keys = Lists.newArrayList();
                    records.forEach(r -> keys.add(new MappingKeyBuilder(LispMappingProvider.this.deviceService, deviceId, r.getPrefix()).build()));
                    LispMappingProvider.this.providerService.mappingQueried((List)keys);
                    break;
                }
                case LISP_MAP_REGISTER: {
                    LispMapRegister register = (LispMapRegister)msg;
                    this.processMappings(deviceId, register.getMapRecords(), MappingStore.Type.MAP_DATABASE);
                    break;
                }
                default: {
                    log.warn("Unhandled message type: {}", (Object)msg.getType());
                }
            }
        }

        public void handleOutgoingMessage(LispRouterId routerId, LispMessage msg) {
            if (LispMappingProvider.this.providerService == null) {
                log.warn("provider service has not been initialized");
                return;
            }
            DeviceId deviceId = LispMappingProvider.this.getDeviceId(routerId.toString());
            switch (msg.getType()) {
                case LISP_MAP_REPLY: {
                    LispMapReply reply = (LispMapReply)msg;
                    this.processMappings(deviceId, reply.getMapRecords(), MappingStore.Type.MAP_CACHE);
                    break;
                }
                case LISP_MAP_NOTIFY: {
                    break;
                }
                default: {
                    log.warn("Unhandled message type: {}", (Object)msg.getType());
                }
            }
        }

        private void processMappings(DeviceId deviceId, List<LispMapRecord> records, MappingStore.Type type) {
            records.forEach(r -> {
                MappingEntry me = new MappingEntryBuilder(deviceId, (LispMapRecord)r, LispMappingProvider.this.deviceService).build();
                LispMappingProvider.this.providerService.mappingAdded(me, type);
            });
        }
    }
}

