/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetailsLocalRib;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IPv4AddressTlv;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIgpMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMaxLinkBandwidth;
import org.onosproject.bgpio.types.attr.BgpLinkAttrTeDefaultMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrUnRsrvdLinkBandwidth;
import org.onosproject.cli.AbstractShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="bgp-rib", description="lists RIB configuration")
public class BgpLocalRibDisplay
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(BgpLocalRibDisplay.class);
    private static final String NODETREE = "nodes";
    private static final String LINKTREE = "links";
    private static final String PREFIXTREE = "prefix";
    private static final String VPNNODETREE = "vpnnodes";
    private static final String VPNLINKTREE = "vpnlinkS";
    private static final String VPNPREFIXTREE = "vpnprefix";
    protected Origin origin;
    protected LocalPref localPref;
    protected BgpAttrRouterIdV4 bgpAttrRouterIdV4;
    protected IsIsNonPseudonode isIsNonPseudonode;
    protected AutonomousSystemTlv autonomousSystemTlv;
    protected IPv4AddressTlv iPv4AddressTlv;
    protected BgpLinkAttrMaxLinkBandwidth bgpLinkAttrMaxLinkBandwidth;
    protected BgpLinkAttrUnRsrvdLinkBandwidth bgpLinkAttrUnRsrvdLinkBandwidth;
    protected BgpLinkAttrTeDefaultMetric bgpLinkAttrTeDefaultMetric;
    protected BgpLinkAttrIgpMetric bgpLinkAttrIgpMetric;
    protected PathAttrNlriDetailsLocalRib pathAttrNlriDetailsLocalRib;
    protected MpReachNlri mpReachNlri;
    protected PathAttrNlriDetails pathAttrNlriDetails;
    protected BgpNodeLSNlriVer4.ProtocolType protocolType;
    protected BgpController bgpController = (BgpController)BgpLocalRibDisplay.get(BgpController.class);
    protected BgpLocalRib bgpLocalRib = this.bgpController.bgpLocalRib();
    Map<BgpNodeLSIdentifier, PathAttrNlriDetailsLocalRib> nodeTreeMap = this.bgpLocalRib.nodeTree();
    Set<BgpNodeLSIdentifier> nodekeySet = this.nodeTreeMap.keySet();
    Map<BgpLinkLSIdentifier, PathAttrNlriDetailsLocalRib> linkTreeMap = this.bgpLocalRib.linkTree();
    Set<BgpLinkLSIdentifier> linkkeySet = this.linkTreeMap.keySet();
    @Argument(index=0, name="name", description="nodetree\nlinktree\nprefixtree\nvpnnodetree\nvpnlinktree\nvpnprefixtree", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="numberofentries", description="numberofentries", required=false, multiValued=false)
    int numberofentries;
    @Argument(index=2, name="vpnId", description="vpnId", required=false, multiValued=false)
    String vpnId = null;
    private int count = 0;

    protected void execute() {
        switch (this.name) {
            case "nodes": {
                this.displayNodes();
                break;
            }
            case "links": {
                this.displayLinks();
                break;
            }
            case "prefix": {
                this.displayPrefix();
                break;
            }
            case "vpnnodes": {
                this.displayVpnNodes();
                break;
            }
            case "vpnlinkS": {
                this.displayVpnLinks();
                break;
            }
            case "vpnprefix": {
                this.displayVpnPrefix();
                break;
            }
            default: {
                System.out.print("Unknown Command");
            }
        }
    }

    private void displayNodes() {
        try {
            int counter = 0;
            this.print("Total number of entries = %s", new Object[]{this.nodeTreeMap.size()});
            for (BgpNodeLSIdentifier nodes : this.nodekeySet) {
                if (this.numberofentries > this.nodeTreeMap.size() || this.numberofentries < 0) {
                    System.out.print("Wrong Argument");
                    break;
                }
                if (counter < this.numberofentries) {
                    this.pathAttrNlriDetailsLocalRib = this.nodeTreeMap.get(nodes);
                    this.displayNode();
                    ++counter;
                    continue;
                }
                if (counter != 0) continue;
                this.pathAttrNlriDetailsLocalRib = this.nodeTreeMap.get(nodes);
                this.displayNode();
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP nodes: {}", (Object)e.getMessage());
        }
    }

    private void displayLinks() {
        try {
            int counter = 0;
            this.print("Total Number of entries = %d", new Object[]{this.linkTreeMap.size()});
            for (BgpLinkLSIdentifier links : this.linkkeySet) {
                if (this.numberofentries > this.linkTreeMap.size() || this.numberofentries < 0) {
                    System.out.print("Wrong Argument");
                    break;
                }
                if (counter < this.numberofentries) {
                    this.pathAttrNlriDetailsLocalRib = this.linkTreeMap.get(links);
                    this.print("Total number of entries = %d", new Object[]{this.linkTreeMap.size()});
                    this.displayLink();
                    ++counter;
                    continue;
                }
                if (counter != 0) continue;
                this.pathAttrNlriDetailsLocalRib = this.linkTreeMap.get(links);
                this.displayLink();
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP links: {}", (Object)e.getMessage());
        }
    }

    private void displayPrefix() {
        try {
            this.bgpController = (BgpController)BgpLocalRibDisplay.get(BgpController.class);
            this.bgpLocalRib = this.bgpController.bgpLocalRib();
            Map prefixmap = this.bgpLocalRib.prefixTree();
            Set prefixkeySet = prefixmap.keySet();
            for (BgpPrefixLSIdentifier prefix : prefixkeySet) {
                this.pathAttrNlriDetailsLocalRib = (PathAttrNlriDetailsLocalRib)prefixmap.get(prefix);
                this.pathAttrNlriDetails = this.pathAttrNlriDetailsLocalRib.localRibNlridetails();
                this.print("No of entries = %d", new Object[]{prefixmap.size()});
                System.out.print(this.pathAttrNlriDetailsLocalRib.toString());
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP prefixes: {}", (Object)e.getMessage());
        }
    }

    private void displayVpnNodes() {
        try {
            this.bgpController = (BgpController)BgpLocalRibDisplay.get(BgpController.class);
            this.bgpLocalRib = this.bgpController.bgpLocalRib();
            Map vpnNode = this.bgpLocalRib.vpnNodeTree();
            Set vpnNodekeySet = vpnNode.keySet();
            for (RouteDistinguisher vpnNodes : vpnNodekeySet) {
                boolean invalidProcess = true;
                if (this.vpnId != null && Integer.parseInt(this.vpnId.trim()) == vpnNodes.hashCode()) {
                    invalidProcess = false;
                    this.displayNodes();
                }
                if (!invalidProcess) continue;
                this.print("%s\n", new Object[]{"Id " + this.vpnId + "does not exist...!!!"});
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP nodes based on VPN : {}", (Object)e.getMessage());
        }
    }

    private void displayVpnLinks() {
        try {
            this.bgpController = (BgpController)BgpLocalRibDisplay.get(BgpController.class);
            this.bgpLocalRib = this.bgpController.bgpLocalRib();
            Map vpnLink = this.bgpLocalRib.vpnLinkTree();
            Set vpnLinkkeySet = vpnLink.keySet();
            for (RouteDistinguisher vpnLinks : vpnLinkkeySet) {
                boolean invalidProcess = true;
                if (this.vpnId != null && Integer.parseInt(this.vpnId.trim()) == vpnLinks.hashCode()) {
                    invalidProcess = false;
                    this.displayLinks();
                }
                if (!invalidProcess) continue;
                this.print("%s\n", new Object[]{"Id " + this.vpnId + "does not exist...!!!"});
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP links based on VPN : {}", (Object)e.getMessage());
        }
    }

    private void displayVpnPrefix() {
        try {
            this.bgpController = (BgpController)BgpLocalRibDisplay.get(BgpController.class);
            this.bgpLocalRib = this.bgpController.bgpLocalRib();
            Map vpnPrefix = this.bgpLocalRib.vpnPrefixTree();
            Set vpnPrefixkeySet = vpnPrefix.keySet();
            for (RouteDistinguisher vpnprefixId : vpnPrefixkeySet) {
                boolean invalidProcess = true;
                if (this.vpnId != null && Integer.parseInt(this.vpnId.trim()) == vpnprefixId.hashCode()) {
                    invalidProcess = false;
                    this.displayPrefix();
                }
                if (!invalidProcess) continue;
                this.print("%s\n", new Object[]{"Id " + this.vpnId + "does not exist...!!!"});
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP prefixes based on VPN : {}", (Object)e.getMessage());
        }
    }

    private void displayNode() {
        this.pathAttrNlriDetails = this.pathAttrNlriDetailsLocalRib.localRibNlridetails();
        List bgpValueTypeList = this.pathAttrNlriDetails.pathAttributes();
        this.protocolType = this.pathAttrNlriDetails.protocolID();
        for (BgpValueType bgpValueType : bgpValueTypeList) {
            if (bgpValueType instanceof Origin) {
                this.origin = (Origin)bgpValueType;
                continue;
            }
            if (bgpValueType instanceof LocalPref) {
                this.localPref = (LocalPref)bgpValueType;
                continue;
            }
            if (bgpValueType instanceof LinkStateAttributes) {
                LinkStateAttributes linkStateAttributes = (LinkStateAttributes)bgpValueType;
                List linkStateAttribiuteList = linkStateAttributes.linkStateAttributes();
                for (BgpValueType bgpValueType1 : linkStateAttribiuteList) {
                    if (!(bgpValueType1 instanceof BgpAttrRouterIdV4)) continue;
                    this.bgpAttrRouterIdV4 = (BgpAttrRouterIdV4)bgpValueType1;
                }
                continue;
            }
            if (!(bgpValueType instanceof MpReachNlri)) continue;
            this.mpReachNlri = (MpReachNlri)bgpValueType;
            List bgpLSNlris = this.mpReachNlri.mpReachNlri();
            for (BgpLSNlri bgpLSNlri : bgpLSNlris) {
                if (!(bgpLSNlri instanceof BgpNodeLSNlriVer4)) continue;
                BgpNodeLSNlriVer4 bgpNodeLSNlriVer4 = (BgpNodeLSNlriVer4)bgpLSNlri;
                BgpNodeLSIdentifier bgpNodeLSIdentifier = bgpNodeLSNlriVer4.getLocalNodeDescriptors();
                NodeDescriptors nodeDescriptors = bgpNodeLSIdentifier.getNodedescriptors();
                List bgpvalueTypesList = nodeDescriptors.getSubTlvs();
                for (BgpValueType valueType : bgpvalueTypesList) {
                    if (!(valueType instanceof IsIsNonPseudonode)) continue;
                    this.isIsNonPseudonode = (IsIsNonPseudonode)valueType;
                }
            }
        }
        this.print("RibAsNumber = %s,PeerIdentifier = %s,RibIpAddress = %s,ProtocolType = %s,Origin = %s,LocalPref = %s,RouterID = %s,IsoNodeID = %s,NextHop = %s", new Object[]{this.pathAttrNlriDetailsLocalRib.localRibAsNum(), this.pathAttrNlriDetailsLocalRib.localRibIdentifier(), this.pathAttrNlriDetailsLocalRib.localRibIpAddress(), this.protocolType.toString(), this.origin.origin(), this.localPref.localPref(), this.bgpAttrRouterIdV4.attrRouterId(), Arrays.toString(this.isIsNonPseudonode.getIsoNodeId()), this.mpReachNlri.nexthop4()});
    }

    private void displayLink() {
        this.pathAttrNlriDetails = this.pathAttrNlriDetailsLocalRib.localRibNlridetails();
        List valueTypes = this.pathAttrNlriDetails.pathAttributes();
        for (BgpValueType bgpValueType : valueTypes) {
            if (bgpValueType instanceof Origin) {
                this.origin = (Origin)bgpValueType;
                continue;
            }
            if (bgpValueType instanceof LocalPref) {
                this.localPref = (LocalPref)bgpValueType;
                continue;
            }
            if (bgpValueType instanceof LinkStateAttributes) {
                LinkStateAttributes linkStateAttributes = (LinkStateAttributes)bgpValueType;
                List linkStateAttributelist = linkStateAttributes.linkStateAttributes();
                for (BgpValueType bgpValueType1 : linkStateAttributelist) {
                    if (bgpValueType1 instanceof BgpAttrRouterIdV4) {
                        this.bgpAttrRouterIdV4 = (BgpAttrRouterIdV4)bgpValueType1;
                        continue;
                    }
                    if (bgpValueType1 instanceof BgpLinkAttrMaxLinkBandwidth) {
                        this.bgpLinkAttrMaxLinkBandwidth = (BgpLinkAttrMaxLinkBandwidth)bgpValueType1;
                        continue;
                    }
                    if (bgpValueType1 instanceof BgpLinkAttrUnRsrvdLinkBandwidth) {
                        this.bgpLinkAttrUnRsrvdLinkBandwidth = (BgpLinkAttrUnRsrvdLinkBandwidth)bgpValueType1;
                        continue;
                    }
                    if (bgpValueType1 instanceof BgpLinkAttrTeDefaultMetric) {
                        this.bgpLinkAttrTeDefaultMetric = (BgpLinkAttrTeDefaultMetric)bgpValueType1;
                        continue;
                    }
                    if (!(bgpValueType1 instanceof BgpLinkAttrIgpMetric)) continue;
                    this.bgpLinkAttrIgpMetric = (BgpLinkAttrIgpMetric)bgpValueType1;
                }
                continue;
            }
            if (!(bgpValueType instanceof MpReachNlri)) continue;
            this.mpReachNlri = (MpReachNlri)bgpValueType;
            List bgpLSNlris = this.mpReachNlri.mpReachNlri();
            for (BgpLSNlri bgpLSNlri : bgpLSNlris) {
                if (!(bgpLSNlri instanceof BgpLinkLsNlriVer4)) continue;
                BgpLinkLsNlriVer4 bgpLinkLsNlriVer4 = (BgpLinkLsNlriVer4)bgpLSNlri;
                BgpLinkLSIdentifier bgpLinkLSIdentifier = bgpLinkLsNlriVer4.getLinkIdentifier();
                NodeDescriptors localnodeDescriptors = bgpLinkLSIdentifier.localNodeDescriptors();
                NodeDescriptors remotenodeDescriptors = bgpLinkLSIdentifier.remoteNodeDescriptors();
                List linkDescriptors = bgpLinkLSIdentifier.linkDescriptors();
                List subTlvList = localnodeDescriptors.getSubTlvs();
                for (BgpValueType valueType : subTlvList) {
                    if (valueType instanceof IsIsNonPseudonode) {
                        this.isIsNonPseudonode = (IsIsNonPseudonode)valueType;
                        continue;
                    }
                    if (!(valueType instanceof AutonomousSystemTlv)) continue;
                    this.autonomousSystemTlv = (AutonomousSystemTlv)valueType;
                }
                List remotevalueTypes = remotenodeDescriptors.getSubTlvs();
                for (BgpValueType valueType : remotevalueTypes) {
                    if (valueType instanceof IsIsNonPseudonode) {
                        this.isIsNonPseudonode = (IsIsNonPseudonode)valueType;
                        continue;
                    }
                    if (!(valueType instanceof AutonomousSystemTlv)) continue;
                    this.autonomousSystemTlv = (AutonomousSystemTlv)valueType;
                }
                for (BgpValueType valueType : linkDescriptors) {
                    if (!(valueType instanceof IPv4AddressTlv)) continue;
                    this.iPv4AddressTlv = (IPv4AddressTlv)valueType;
                }
            }
        }
        this.print("PeerIdentifier = %s,Origin = %s,LocalPref = %s,RouterID = %s,MaxBandwidth = %s,UnreservedBandwidth = %s,DefaultMetric = %s,IGPMetric = %s,IsoNodeID = %s,ASNum = %s,IPAddress = %s,NextHop = %s", new Object[]{this.pathAttrNlriDetailsLocalRib.localRibIdentifier(), this.origin.origin(), this.localPref.localPref(), this.bgpAttrRouterIdV4.attrRouterId(), Float.valueOf(this.bgpLinkAttrMaxLinkBandwidth.linkAttrMaxLinkBandwidth()), this.bgpLinkAttrUnRsrvdLinkBandwidth.getLinkAttrUnRsrvdLinkBandwidth().toString(), this.bgpLinkAttrTeDefaultMetric.attrLinkDefTeMetric(), this.bgpLinkAttrIgpMetric.attrLinkIgpMetric(), Arrays.toString(this.isIsNonPseudonode.getIsoNodeId()), this.autonomousSystemTlv.getAsNum(), this.iPv4AddressTlv.address(), this.mpReachNlri.nexthop4().toString(), this.pathAttrNlriDetailsLocalRib.localRibIpAddress(), this.origin.origin(), this.localPref.localPref(), this.bgpAttrRouterIdV4.attrRouterId()});
    }
}

