/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.cli;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.cli.AbstractShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="bgp-exception", description="Displays Exceptions")
public class BgpExceptions
extends AbstractShellCommand {
    public static final String ACTIVESESSION = "activesession";
    public static final String CLOSEDSESSION = "closedsession";
    private static final Logger log = LoggerFactory.getLogger(BgpExceptions.class);
    protected BgpController bgpController;
    @Argument(index=0, name="name", description="activesession\nclosedsession", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="peerIp", description="peerId", required=false, multiValued=false)
    String peerId = null;
    private Set<String> activeSessionExceptionkeySet;
    private Set<String> closedSessionExceptionKeySet;

    protected void execute() {
        switch (this.name) {
            case "activesession": {
                this.displayActiveSessionException();
                break;
            }
            case "closedsession": {
                this.displayClosedSessionException();
                break;
            }
            default: {
                System.out.print("Unknown Command");
            }
        }
    }

    private void displayActiveSessionException() {
        try {
            this.bgpController = (BgpController)BgpExceptions.get(BgpController.class);
            Map activeSessionExceptionMap = this.bgpController.activeSessionMap();
            this.activeSessionExceptionkeySet = activeSessionExceptionMap.keySet();
            if (!this.activeSessionExceptionkeySet.isEmpty()) {
                if (this.peerId != null) {
                    if (this.activeSessionExceptionkeySet.contains(this.peerId)) {
                        for (String peerIdKey : this.activeSessionExceptionkeySet) {
                            List activeSessionExceptionlist = (List)activeSessionExceptionMap.get(peerIdKey);
                            System.out.println(activeSessionExceptionlist);
                        }
                    } else {
                        System.out.print("Wrong argument");
                    }
                } else {
                    this.activeSessionExceptionkeySet = activeSessionExceptionMap.keySet();
                    if (!this.activeSessionExceptionkeySet.isEmpty()) {
                        for (String peerId : this.activeSessionExceptionkeySet) {
                            this.print("PeerId = %s, Exception = %s ", new Object[]{peerId, activeSessionExceptionMap.get(peerId)});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP exceptions: {}", (Object)e.getMessage());
        }
    }

    private void displayClosedSessionException() {
        try {
            this.bgpController = (BgpController)BgpExceptions.get(BgpController.class);
            Map closedSessionExceptionMap = this.bgpController.closedSessionMap();
            this.closedSessionExceptionKeySet = closedSessionExceptionMap.keySet();
            if (!this.closedSessionExceptionKeySet.isEmpty()) {
                if (this.peerId != null) {
                    if (this.closedSessionExceptionKeySet.contains(this.peerId)) {
                        for (String peerIdKey : this.closedSessionExceptionKeySet) {
                            List closedSessionExceptionlist = (List)closedSessionExceptionMap.get(peerIdKey);
                            this.print("Exceptions = %s", new Object[]{closedSessionExceptionlist});
                        }
                    } else {
                        System.out.print("Wrong argument");
                    }
                } else {
                    this.closedSessionExceptionKeySet = closedSessionExceptionMap.keySet();
                    if (!this.closedSessionExceptionKeySet.isEmpty()) {
                        for (String peerId : this.closedSessionExceptionKeySet) {
                            this.print("PeerId = %s, Exception = %s", new Object[]{peerId, closedSessionExceptionMap.get(peerId)});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying resons for session closure: {}", (Object)e.getMessage());
        }
    }
}

