/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.cli;

import java.util.Set;
import java.util.TreeMap;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpConnectPeer;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpPeerCfg;
import org.onosproject.cli.AbstractShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="bgp", description="lists configuration")
public class BgpConfiguration
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(BgpConfiguration.class);
    private static final String CONFIGURATION = "configuration";
    private static final String PEER = "peer";
    protected BgpController bgpController;
    protected BgpConnectPeer bgpConnectPeer;
    protected BgpPeerCfg bgpPeerCfg;
    protected BgpCfg bgpCfg;
    @Argument(index=0, name="name", description="configuration\npeer", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="peer", description="peerIp", required=false, multiValued=false)
    String peer = null;

    protected void execute() {
        switch (this.name) {
            case "configuration": {
                this.displayBgpConfiguration();
                break;
            }
            case "peer": {
                this.displayBgpPeerConfiguration();
                break;
            }
            default: {
                System.out.print("Unknown command...!!");
            }
        }
    }

    private void displayBgpConfiguration() {
        try {
            this.bgpController = (BgpController)BgpConfiguration.get(BgpController.class);
            this.bgpCfg = this.bgpController.getConfig();
            this.print("RouterID = %s, ASNumber = %s, MaxSession = %s, HoldingTime = %s, LsCapabality = %s, LargeAsCapabality = %s, FlowSpecCapabality = %s", new Object[]{this.bgpCfg.getRouterId(), this.bgpCfg.getAsNumber(), this.bgpCfg.getMaxSession(), this.bgpCfg.getHoldTime(), this.bgpCfg.getLsCapability(), this.bgpCfg.getLargeASCapability(), this.bgpCfg.flowSpecCapability()});
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP configuration: {}", (Object)e.getMessage());
        }
    }

    private void displayBgpPeerConfiguration() {
        try {
            this.bgpController = (BgpController)BgpConfiguration.get(BgpController.class);
            BgpCfg bgpCfg = this.bgpController.getConfig();
            if (bgpCfg == null) {
                return;
            }
            TreeMap displayPeerTree = bgpCfg.getPeerTree();
            Set peerKey = displayPeerTree.keySet();
            if (this.peer != null) {
                if (!peerKey.isEmpty()) {
                    for (String peerIdKey : peerKey) {
                        this.bgpPeerCfg = (BgpPeerCfg)displayPeerTree.get(peerIdKey);
                        this.bgpConnectPeer = this.bgpPeerCfg.connectPeer();
                        if (!peerIdKey.equals(this.peer)) continue;
                        this.print("PeerRouterID = %s, PeerHoldingTime = %s, ASNumber = %s, PeerState = %s, PeerPort = %s, ConnectRetryCounter = %s", new Object[]{this.peer, this.bgpPeerCfg.getHoldtime(), this.bgpPeerCfg.getAsNumber(), this.bgpPeerCfg.getState(), this.bgpConnectPeer.getPeerPort(), this.bgpConnectPeer.getConnectRetryCounter()});
                    }
                }
            } else if (!peerKey.isEmpty()) {
                for (String peerIdKey : peerKey) {
                    this.bgpPeerCfg = (BgpPeerCfg)displayPeerTree.get(peerIdKey);
                    this.bgpConnectPeer = this.bgpPeerCfg.connectPeer();
                    this.print("PeerRouterID = %s, PeerHoldingTime = %s, ASNumber = %s, PeerState = %s, PeerPort = %s, ConnectRetryCounter = %s", new Object[]{this.bgpPeerCfg.getPeerRouterId(), this.bgpPeerCfg.getHoldtime(), this.bgpPeerCfg.getAsNumber(), this.bgpPeerCfg.getState(), this.bgpConnectPeer.getPeerPort(), this.bgpConnectPeer.getConnectRetryCounter()});
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying BGP peer configuration: {}", (Object)e.getMessage());
        }
    }
}

