/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.cpr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.routing.InterfaceProvisionRequest;
import org.onosproject.routing.Router;
import org.onosproject.routing.RouterInfo;
import org.onosproject.routing.RoutingService;
import org.onosproject.routing.config.RouterConfigHelper;
import org.onosproject.routing.config.RoutersConfig;
import org.onosproject.routing.config.RoutingConfigurationService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ControlPlaneRedirectManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final short ASSIGNED_VLAN = 4094;
    private static final int MIN_IP_PRIORITY = 10;
    private static final int IPV4_PRIORITY = 2000;
    private static final int IPV6_PRIORITY = 500;
    static final int ACL_PRIORITY = 40001;
    private static final int OSPF_IP_PROTO = 89;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService applicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoutingConfigurationService rs;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="forceUnprovision", boolValue={false}, label="Force unprovision when the device goes offline")
    private boolean forceUnprovision = false;
    private static final String APP_NAME = "org.onosproject.cpr";
    private ApplicationId appId;
    private Map<Host, Set<Integer>> peerNextId = Maps.newConcurrentMap();
    private Map<DeviceId, Router> routers = new ConcurrentHashMap<DeviceId, Router>();
    private final InternalNetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();

    @Activate
    protected void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.cfgService.registerProperties(this.getClass());
        this.modified(context);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.processRouterConfig();
        this.applicationService.registerDeactivateHook(this.appId, () -> this.routers.forEach((d, r) -> r.cleanup()));
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
    }

    @Modified
    protected void modified(ComponentContext context) {
        if (context != null) {
            this.readComponentConfiguration(context);
            this.processRouterConfig();
        }
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"forceUnprovision");
        if (flag == null) {
            this.log.info("ForceUnprovision is not configured, using current value of {}", (Object)this.forceUnprovision);
        } else {
            this.forceUnprovision = flag;
            this.log.info("Configured. ForceUnprovision is {}", (Object)(this.forceUnprovision ? "enabled" : "disabled"));
        }
    }

    private void processRouterConfig() {
        ApplicationId routingAppId = this.coreService.registerApplication("org.onosproject.router");
        Set routerConfigs = RouterConfigHelper.getRouterConfigurations((NetworkConfigService)this.networkConfigService, (ApplicationId)routingAppId);
        for (RoutersConfig.Router router : routerConfigs) {
            DeviceId deviceId = router.controlPlaneConnectPoint().deviceId();
            this.routers.compute(deviceId, (d, r) -> {
                if (r == null) {
                    return this.createRouter(RouterInfo.from((RoutersConfig.Router)router));
                }
                r.changeConfiguration(RouterInfo.from((RoutersConfig.Router)router), this.forceUnprovision);
                return r;
            });
        }
        for (DeviceId deviceId : this.routers.keySet()) {
            if (this.configExists(deviceId, routerConfigs)) continue;
            Router router = this.routers.remove(deviceId);
            router.cleanup();
        }
    }

    private boolean configExists(DeviceId deviceId, Set<RoutersConfig.Router> config) {
        return config.stream().anyMatch(r -> r.controlPlaneConnectPoint().deviceId().equals((Object)deviceId));
    }

    private Router createRouter(RouterInfo info) {
        return new Router(info, this.interfaceService, this.deviceService, this::provisionInterface, this::unprovisionInterface, this.forceUnprovision);
    }

    private void provisionInterface(InterfaceProvisionRequest intf) {
        this.updateInterfaceObjectives(intf, true);
    }

    private void unprovisionInterface(InterfaceProvisionRequest intf) {
        this.updateInterfaceObjectives(intf, false);
    }

    private void updateInterfaceObjectives(InterfaceProvisionRequest intf, boolean install) {
        this.updateInterfaceForwarding(intf, install);
        this.updateOspfForwarding(intf, install);
    }

    private void updateInterfaceForwarding(InterfaceProvisionRequest request, boolean install) {
        Interface intf = request.intf();
        this.log.debug("{} interface objectives for {}", (Object)this.operation(install), (Object)intf);
        DeviceId deviceId = intf.connectPoint().deviceId();
        PortNumber controlPlanePort = request.controlPlaneConnectPoint().port();
        for (InterfaceIpAddress ip : intf.ipAddresses()) {
            int intfNextId;
            int cpNextId;
            if (intf.vlan() == VlanId.NONE) {
                cpNextId = this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install);
                intfNextId = this.modifyNextObjective(deviceId, intf.connectPoint().port(), VlanId.vlanId((short)4094), true, install);
            } else {
                cpNextId = this.modifyNextObjective(deviceId, controlPlanePort, intf.vlan(), false, install);
                intfNextId = this.modifyNextObjective(deviceId, intf.connectPoint().port(), intf.vlan(), false, install);
            }
            ArrayList fwdToSend = Lists.newArrayList();
            TrafficSelector selector = ControlPlaneRedirectManager.buildIPDstSelector(ip.ipAddress().toIpPrefix(), intf.connectPoint().port(), null, intf.mac(), intf.vlan());
            fwdToSend.add(this.buildForwardingObjective(selector, null, cpNextId, install, 40001));
            selector = ControlPlaneRedirectManager.buildIPSrcSelector(ip.ipAddress().toIpPrefix(), controlPlanePort, intf.mac(), null, intf.vlan());
            fwdToSend.add(this.buildForwardingObjective(selector, null, intfNextId, install, 40001));
            TrafficTreatment treatment = DefaultTrafficTreatment.builder().punt().build();
            if (ip.ipAddress().isIp4()) {
                selector = ControlPlaneRedirectManager.buildArpSelector(intf.connectPoint().port(), intf.vlan(), null, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildArpSelector(controlPlanePort, intf.vlan(), ip.ipAddress().getIp4Address(), intf.mac());
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, intfNextId, install, 40002));
            } else {
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, ip.ipAddress().toIpPrefix(), (byte)-121, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])intf.mac().toBytes())).toIpPrefix(), (byte)-121, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, Ip6Address.valueOf((byte[])IPv6.getSolicitNodeAddress((byte[])ip.ipAddress().toOctets())).toIpPrefix(), (byte)-121, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, Ip6Address.valueOf((byte[])IPv6.getSolicitNodeAddress((byte[])IPv6.getLinkLocalAddress((byte[])intf.mac().toBytes()))).toIpPrefix(), (byte)-121, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(controlPlanePort, intf.vlan(), ip.ipAddress().toIpPrefix(), null, (byte)-121, intf.mac());
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, intfNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(controlPlanePort, intf.vlan(), Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])intf.mac().toBytes())).toIpPrefix(), null, (byte)-121, intf.mac());
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, intfNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, ip.ipAddress().toIpPrefix(), (byte)-120, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(intf.connectPoint().port(), intf.vlan(), null, Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])intf.mac().toBytes())).toIpPrefix(), (byte)-120, null);
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, cpNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(controlPlanePort, intf.vlan(), ip.ipAddress().toIpPrefix(), null, (byte)-120, intf.mac());
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, intfNextId, install, 40002));
                selector = ControlPlaneRedirectManager.buildNdpSelector(controlPlanePort, intf.vlan(), Ip6Address.valueOf((byte[])IPv6.getLinkLocalAddress((byte[])intf.mac().toBytes())).toIpPrefix(), null, (byte)-120, intf.mac());
                fwdToSend.add(this.buildForwardingObjective(selector, treatment, intfNextId, install, 40002));
            }
            fwdToSend.stream().forEach(forwardingObjective -> this.flowObjectiveService.forward(deviceId, forwardingObjective));
        }
    }

    private void updateOspfForwarding(InterfaceProvisionRequest request, boolean install) {
        Interface intf = request.intf();
        this.log.debug("{} OSPF flows for {}", (Object)this.operation(install), (Object)intf);
        TrafficSelector toSelector = DefaultTrafficSelector.builder().matchInPort(intf.connectPoint().port()).matchEthType(EthType.EtherType.IPV4.ethType().toShort()).matchVlanId(intf.vlan()).matchIPProtocol((byte)89).build();
        DeviceId deviceId = intf.connectPoint().deviceId();
        PortNumber controlPlanePort = request.controlPlaneConnectPoint().port();
        int cpNextId = intf.vlan() == VlanId.NONE ? this.modifyNextObjective(deviceId, controlPlanePort, VlanId.vlanId((short)4094), true, install) : this.modifyNextObjective(deviceId, controlPlanePort, intf.vlan(), false, install);
        this.flowObjectiveService.forward(intf.connectPoint().deviceId(), this.buildForwardingObjective(toSelector, null, cpNextId, install ? request.info().ospfEnabled() : install, 40001));
    }

    private int modifyNextObjective(DeviceId deviceId, PortNumber portNumber, VlanId vlanId, boolean popVlan, boolean install) {
        int nextId = this.flowObjectiveService.allocateNextId();
        DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextId).withType(NextObjective.Type.SIMPLE).fromApp(this.appId);
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (popVlan) {
            ttBuilder.popVlan();
        }
        ttBuilder.setOutput(portNumber);
        TrafficSelector.Builder metabuilder = DefaultTrafficSelector.builder();
        metabuilder.matchVlanId(vlanId);
        nextObjBuilder.withMeta(metabuilder.build());
        nextObjBuilder.addTreatment(ttBuilder.build());
        this.log.debug("Submitted next objective {} in device {} for port/vlan {}/{}", new Object[]{nextId, deviceId, portNumber, vlanId});
        if (install) {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.add());
        } else {
            this.flowObjectiveService.next(deviceId, nextObjBuilder.remove());
        }
        return nextId;
    }

    private ForwardingObjective buildForwardingObjective(TrafficSelector selector, TrafficTreatment treatment, int nextId, boolean add, int priority) {
        DefaultForwardingObjective.Builder fobBuilder = DefaultForwardingObjective.builder();
        fobBuilder.withSelector(selector);
        if (treatment != null) {
            fobBuilder.withTreatment(treatment);
        }
        if (nextId != -1) {
            fobBuilder.nextStep(nextId);
        }
        fobBuilder.fromApp(this.appId).withPriority(priority).withFlag(ForwardingObjective.Flag.VERSATILE);
        return add ? fobBuilder.add() : fobBuilder.remove();
    }

    static TrafficSelector.Builder buildBaseSelectorBuilder(PortNumber inPort, MacAddress srcMac, MacAddress dstMac, VlanId vlanId) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (inPort != null) {
            selectorBuilder.matchInPort(inPort);
        }
        if (srcMac != null) {
            selectorBuilder.matchEthSrc(srcMac);
        }
        if (dstMac != null) {
            selectorBuilder.matchEthDst(dstMac);
        }
        if (vlanId != null) {
            selectorBuilder.matchVlanId(vlanId);
        }
        return selectorBuilder;
    }

    static TrafficSelector buildIPDstSelector(IpPrefix dstIp, PortNumber inPort, MacAddress srcMac, MacAddress dstMac, VlanId vlanId) {
        TrafficSelector.Builder selector = ControlPlaneRedirectManager.buildBaseSelectorBuilder(inPort, srcMac, dstMac, vlanId);
        if (dstIp.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(dstIp);
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchIPv6Dst(dstIp);
        }
        return selector.build();
    }

    static TrafficSelector buildIPSrcSelector(IpPrefix srcIp, PortNumber inPort, MacAddress srcMac, MacAddress dstMac, VlanId vlanId) {
        TrafficSelector.Builder selector = ControlPlaneRedirectManager.buildBaseSelectorBuilder(inPort, srcMac, dstMac, vlanId);
        if (srcIp.isIp4()) {
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPSrc(srcIp);
        } else {
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchIPv6Src(srcIp);
        }
        return selector.build();
    }

    static TrafficSelector buildArpSelector(PortNumber inPort, VlanId vlanId, Ip4Address arpSpa, MacAddress srcMac) {
        TrafficSelector.Builder selector = ControlPlaneRedirectManager.buildBaseSelectorBuilder(inPort, null, null, vlanId);
        selector.matchEthType(Ethernet.TYPE_ARP);
        if (arpSpa != null) {
            selector.matchArpSpa(arpSpa);
        }
        if (srcMac != null) {
            selector.matchEthSrc(srcMac);
        }
        return selector.build();
    }

    static TrafficSelector buildNdpSelector(PortNumber inPort, VlanId vlanId, IpPrefix srcIp, IpPrefix dstIp, byte subProto, MacAddress srcMac) {
        TrafficSelector.Builder selector = ControlPlaneRedirectManager.buildBaseSelectorBuilder(inPort, null, null, vlanId);
        selector.matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58).matchIcmpv6Type(subProto);
        if (srcIp != null) {
            selector.matchIPv6Src(srcIp);
        }
        if (dstIp != null) {
            selector.matchIPv6Dst(dstIp);
        }
        if (srcMac != null) {
            selector.matchEthSrc(srcMac);
        }
        return selector.build();
    }

    private String operation(boolean install) {
        return install ? "Installing" : "Removing";
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    protected void unbindApplicationService(ApplicationService applicationService) {
        if (this.applicationService == applicationService) {
            this.applicationService = null;
        }
    }

    protected void bindRs(RoutingConfigurationService routingConfigurationService) {
        this.rs = routingConfigurationService;
    }

    protected void unbindRs(RoutingConfigurationService routingConfigurationService) {
        if (this.rs == routingConfigurationService) {
            this.rs = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(RoutingService.ROUTER_CONFIG_CLASS) || event.configClass().equals(RoutersConfig.class)) {
                switch ((NetworkConfigEvent.Type)event.type()) {
                    case CONFIG_ADDED: 
                    case CONFIG_UPDATED: 
                    case CONFIG_REMOVED: {
                        ControlPlaneRedirectManager.this.processRouterConfig();
                        break;
                    }
                    case CONFIG_REGISTERED: 
                    case CONFIG_UNREGISTERED: {
                        break;
                    }
                }
            }
        }
    }
}

