/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.topology.AdapterLinkWeigher;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyProvider;
import org.onosproject.net.topology.TopologyProviderRegistry;
import org.onosproject.net.topology.TopologyProviderService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyStore;
import org.onosproject.net.topology.TopologyStoreDelegate;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TopologyManager
extends AbstractListenerProviderRegistry<TopologyEvent, TopologyListener, TopologyProvider, TopologyProviderService>
implements TopologyService,
TopologyProviderRegistry {
    private static final String TOPOLOGY_NULL = "Topology cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String CLUSTER_ID_NULL = "Cluster ID cannot be null";
    private static final String CLUSTER_NULL = "Topology cluster cannot be null";
    private static final String CONNECTION_POINT_NULL = "Connection point cannot be null";
    private static final String LINK_WEIGHT_NULL = "Link weight cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TopologyStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyStore store;

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(TopologyEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(TopologyEvent.class);
        this.log.info("Stopped");
    }

    public Topology currentTopology() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return this.store.currentTopology();
    }

    public boolean isLatest(Topology topology) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        return this.store.isLatest(topology);
    }

    public Set<TopologyCluster> getClusters(Topology topology) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        return this.store.getClusters(topology);
    }

    public TopologyCluster getCluster(Topology topology, ClusterId clusterId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)topology, (Object)CLUSTER_ID_NULL);
        return this.store.getCluster(topology, clusterId);
    }

    public Set<DeviceId> getClusterDevices(Topology topology, TopologyCluster cluster) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)topology, (Object)CLUSTER_NULL);
        return this.store.getClusterDevices(topology, cluster);
    }

    public Set<Link> getClusterLinks(Topology topology, TopologyCluster cluster) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)topology, (Object)CLUSTER_NULL);
        return this.store.getClusterLinks(topology, cluster);
    }

    public TopologyGraph getGraph(Topology topology) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        return this.store.getGraph(topology);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.store.getPaths(topology, src, dst);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.getPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight));
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.store.getPaths(topology, src, dst, weigher);
    }

    public Set<Path> getKShortestPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher, int maxPaths) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.store.getKShortestPaths(topology, src, dst, weigher, maxPaths);
    }

    public Stream<Path> getKShortestPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.store.getKShortestPaths(topology, src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.store.getDisjointPaths(topology, src, dst);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.getDisjointPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight));
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.store.getDisjointPaths(topology, src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, Map<Link, Object> riskProfile) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        return this.store.getDisjointPaths(topology, src, dst, riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        return this.getDisjointPaths(topology, src, dst, AdapterLinkWeigher.adapt((LinkWeight)weight), riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)src, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)weigher, (Object)LINK_WEIGHT_NULL);
        return this.store.getDisjointPaths(topology, src, dst, weigher, riskProfile);
    }

    public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECTION_POINT_NULL);
        return this.store.isInfrastructure(topology, connectPoint);
    }

    public boolean isBroadcastPoint(Topology topology, ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Preconditions.checkNotNull((Object)topology, (Object)TOPOLOGY_NULL);
        Preconditions.checkNotNull((Object)connectPoint, (Object)CONNECTION_POINT_NULL);
        return this.store.isBroadcastPoint(topology, connectPoint);
    }

    protected TopologyProviderService createProviderService(TopologyProvider provider) {
        return new InternalTopologyProviderService(provider);
    }

    protected void bindStore(TopologyStore topologyStore) {
        this.store = topologyStore;
    }

    protected void unbindStore(TopologyStore topologyStore) {
        if (this.store == topologyStore) {
            this.store = null;
        }
    }

    private class InternalStoreDelegate
    implements TopologyStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(TopologyEvent event) {
            TopologyManager.this.post((Event)event);
        }
    }

    private class InternalTopologyProviderService
    extends AbstractProviderService<TopologyProvider>
    implements TopologyProviderService {
        InternalTopologyProviderService(TopologyProvider provider) {
            super((Provider)provider);
        }

        public void topologyChanged(GraphDescription topoDescription, List<Event> reasons) {
            Preconditions.checkNotNull((Object)topoDescription, (Object)"Topology description cannot be null");
            TopologyEvent event = TopologyManager.this.store.updateTopology(((TopologyProvider)this.provider()).id(), topoDescription, reasons);
            if (event != null) {
                TopologyManager.this.log.info("Topology {} changed", event.subject());
                TopologyManager.this.post((Event)event);
            }
        }
    }
}

