/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology.impl;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.host.HostService;
import org.onosproject.net.topology.AbstractPathService;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PathManager
extends AbstractPathService
implements PathService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;

    @Activate
    public void activate() {
        ((AbstractPathService)this).topologyService = this.topologyService;
        ((AbstractPathService)this).hostService = this.hostService;
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Set<Path> getPaths(ElementId src, ElementId dst) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return this.getPaths(src, dst, (LinkWeigher)null);
    }

    public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getPaths(src, dst, weight);
    }

    public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getPaths(src, dst, weigher);
    }

    public Stream<Path> getKShortestPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getKShortestPaths(src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return this.getDisjointPaths(src, dst, (LinkWeigher)null);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getDisjointPaths(src, dst, weight);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getDisjointPaths(src, dst, weigher);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, Map<Link, Object> riskProfile) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return this.getDisjointPaths(src, dst, (LinkWeigher)null, riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getDisjointPaths(src, dst, weight, riskProfile);
    }

    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        return super.getDisjointPaths(src, dst, weigher, riskProfile);
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }
}

