/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.topology.DefaultGraphDescription;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.TopologyProvider;
import org.onosproject.net.topology.TopologyProviderRegistry;
import org.onosproject.net.topology.TopologyProviderService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DefaultTopologyProvider
extends AbstractProvider
implements TopologyProvider {
    private static final int MAX_THREADS = 8;
    private static final int DEFAULT_MAX_EVENTS = 1000;
    private static final int DEFAULT_MAX_IDLE_MS = 10;
    private static final int DEFAULT_MAX_BATCH_MS = 50;
    private static final Timer TIMER = new Timer("onos-topo-event-batching");
    @Property(name="maxEvents", intValue={1000}, label="Maximum number of events to accumulate")
    private int maxEvents = 1000;
    @Property(name="maxIdleMs", intValue={10}, label="Maximum number of millis between events")
    private int maxIdleMs = 10;
    @Property(name="maxBatchMs", intValue={50}, label="Maximum number of millis for whole batch")
    private int maxBatchMs = 50;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private volatile boolean isStarted = false;
    private TopologyProviderService providerService;
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final LinkListener linkListener = new InternalLinkListener();
    private Accumulator<Event> accumulator;
    private ExecutorService executor;

    public DefaultTopologyProvider() {
        super(CoreService.CORE_PROVIDER_ID);
    }

    @Activate
    public synchronized void activate(ComponentContext context) {
        this.cfgService.registerProperties(DefaultTopologyProvider.class);
        this.executor = Executors.newFixedThreadPool(8, Tools.groupedThreads((String)"onos/topo", (String)"build-%d", (Logger)this.log));
        this.accumulator = new TopologyChangeAccumulator();
        this.logConfig("Configured");
        this.modified(context);
        this.providerService = (TopologyProviderService)this.providerRegistry.register((Provider)this);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.isStarted = true;
        this.triggerRecompute();
        this.log.info("Started");
    }

    @Deactivate
    public synchronized void deactivate(ComponentContext context) {
        this.cfgService.unregisterProperties(DefaultTopologyProvider.class, false);
        this.isStarted = false;
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.executor.shutdownNow();
        this.executor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newMaxIdleMs;
        int newMaxBatchMs;
        int newMaxEvents;
        if (context == null) {
            this.accumulator = new TopologyChangeAccumulator();
            this.logConfig("Reconfigured");
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"maxEvents");
            newMaxEvents = Strings.isNullOrEmpty((String)s) ? this.maxEvents : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"maxBatchMs");
            newMaxBatchMs = Strings.isNullOrEmpty((String)s) ? this.maxBatchMs : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"maxIdleMs");
            newMaxIdleMs = Strings.isNullOrEmpty((String)s) ? this.maxIdleMs : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newMaxEvents = 1000;
            newMaxBatchMs = 50;
            newMaxIdleMs = 10;
        }
        if (newMaxEvents != this.maxEvents || newMaxBatchMs != this.maxBatchMs || newMaxIdleMs != this.maxIdleMs) {
            this.maxEvents = newMaxEvents;
            this.maxBatchMs = newMaxBatchMs;
            this.maxIdleMs = newMaxIdleMs;
            this.accumulator = this.maxEvents > 1 ? new TopologyChangeAccumulator() : null;
            this.logConfig("Reconfigured");
        }
    }

    private void logConfig(String prefix) {
        this.log.info("{} with maxEvents = {}; maxBatchMs = {}; maxIdleMs = {}; accumulator={}", new Object[]{prefix, this.maxEvents, this.maxBatchMs, this.maxIdleMs, this.accumulator != null});
    }

    public void triggerRecompute() {
        this.triggerTopologyBuild(Collections.emptyList());
    }

    private synchronized void triggerTopologyBuild(List<Event> reasons) {
        if (this.executor != null) {
            this.executor.execute(new TopologyBuilderTask(reasons));
        }
    }

    private void buildTopology(List<Event> reasons) {
        if (this.isStarted) {
            DefaultGraphDescription desc = new DefaultGraphDescription(System.nanoTime(), System.currentTimeMillis(), this.deviceService.getAvailableDevices(), this.linkService.getActiveLinks(), new SparseAnnotations[0]);
            this.providerService.topologyChanged((GraphDescription)desc, reasons);
        }
    }

    private void processEvent(Event event) {
        if (this.accumulator != null) {
            this.accumulator.add((Object)event);
        } else {
            this.triggerTopologyBuild((List<Event>)ImmutableList.of((Object)event));
        }
    }

    protected void bindProviderRegistry(TopologyProviderRegistry topologyProviderRegistry) {
        this.providerRegistry = topologyProviderRegistry;
    }

    protected void unbindProviderRegistry(TopologyProviderRegistry topologyProviderRegistry) {
        if (this.providerRegistry == topologyProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class TopologyBuilderTask
    implements Runnable {
        private final List<Event> reasons;

        public TopologyBuilderTask(List<Event> reasons) {
            this.reasons = reasons;
        }

        @Override
        public void run() {
            try {
                DefaultTopologyProvider.this.buildTopology(this.reasons);
            }
            catch (Exception e) {
                DefaultTopologyProvider.this.log.warn("Unable to compute topology", (Throwable)e);
            }
        }
    }

    private class TopologyChangeAccumulator
    extends AbstractAccumulator<Event> {
        TopologyChangeAccumulator() {
            super(TIMER, DefaultTopologyProvider.this.maxEvents, DefaultTopologyProvider.this.maxBatchMs, DefaultTopologyProvider.this.maxIdleMs);
        }

        public void processItems(List<Event> items) {
            DefaultTopologyProvider.this.triggerTopologyBuild(items);
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            DefaultTopologyProvider.this.processEvent((Event)event);
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            DeviceEvent.Type type = (DeviceEvent.Type)event.type();
            if (type == DeviceEvent.Type.DEVICE_ADDED || type == DeviceEvent.Type.DEVICE_REMOVED || type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED) {
                DefaultTopologyProvider.this.processEvent((Event)event);
            }
        }
    }
}

