/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.statistic.StatisticStore;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class StatisticManager
implements StatisticService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StatisticStore statisticStore;
    private final InternalFlowRuleListener listener = new InternalFlowRuleListener();

    @Activate
    public void activate() {
        this.flowRuleService.addListener((EventListener)this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.flowRuleService.removeListener((EventListener)this.listener);
        this.log.info("Stopped");
    }

    public Load load(Link link) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        return this.load(link.src());
    }

    public Load load(Link link, ApplicationId appId, Optional<GroupId> groupId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        Statistics stats = this.getStatistics(link.src());
        if (!stats.isValid()) {
            return new DefaultLoad();
        }
        ImmutableSet current = FluentIterable.from(stats.current()).filter(StatisticManager.hasApplicationId(appId)).filter(StatisticManager.hasGroupId(groupId)).toSet();
        ImmutableSet previous = FluentIterable.from(stats.previous()).filter(StatisticManager.hasApplicationId(appId)).filter(StatisticManager.hasGroupId(groupId)).toSet();
        return new DefaultLoad(this.aggregate((Set<FlowEntry>)current), this.aggregate((Set<FlowEntry>)previous));
    }

    public Load load(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        return this.loadInternal(connectPoint);
    }

    public Link max(Path path) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        if (path.links().isEmpty()) {
            return null;
        }
        DefaultLoad maxLoad = new DefaultLoad();
        Link maxLink = null;
        for (Link link : path.links()) {
            Load load = this.loadInternal(link.src());
            if (load.rate() <= maxLoad.rate()) continue;
            maxLoad = load;
            maxLink = link;
        }
        return maxLink;
    }

    public Link min(Path path) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        if (path.links().isEmpty()) {
            return null;
        }
        DefaultLoad minLoad = new DefaultLoad();
        Link minLink = null;
        for (Link link : path.links()) {
            Load load = this.loadInternal(link.src());
            if (load.rate() >= minLoad.rate()) continue;
            minLoad = load;
            minLink = link;
        }
        return minLink;
    }

    public FlowRule highestHitter(ConnectPoint connectPoint) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        Set hitters = this.statisticStore.getCurrentStatistic(connectPoint);
        if (hitters.isEmpty()) {
            return null;
        }
        FlowEntry max = (FlowEntry)hitters.iterator().next();
        for (FlowEntry entry : hitters) {
            if (entry.bytes() <= max.bytes()) continue;
            max = entry;
        }
        return max;
    }

    private Load loadInternal(ConnectPoint connectPoint) {
        Statistics stats = this.getStatistics(connectPoint);
        if (!stats.isValid()) {
            return new DefaultLoad();
        }
        return new DefaultLoad(this.aggregate((Set<FlowEntry>)stats.current), this.aggregate((Set<FlowEntry>)stats.previous));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics getStatistics(ConnectPoint connectPoint) {
        Set<FlowEntry> previous;
        Set<FlowEntry> current;
        StatisticStore statisticStore = this.statisticStore;
        synchronized (statisticStore) {
            current = this.getCurrentStatistic(connectPoint);
            previous = this.getPreviousStatistic(connectPoint);
        }
        return new Statistics(current, previous);
    }

    private Set<FlowEntry> getCurrentStatistic(ConnectPoint connectPoint) {
        Set stats = this.statisticStore.getCurrentStatistic(connectPoint);
        if (stats == null) {
            return Collections.emptySet();
        }
        return stats;
    }

    private Set<FlowEntry> getPreviousStatistic(ConnectPoint connectPoint) {
        Set stats = this.statisticStore.getPreviousStatistic(connectPoint);
        if (stats == null) {
            return Collections.emptySet();
        }
        return stats;
    }

    private long aggregate(Set<FlowEntry> values) {
        long sum = 0L;
        for (FlowEntry f : values) {
            sum += f.bytes();
        }
        return sum;
    }

    private static Predicate<FlowEntry> hasApplicationId(ApplicationId appId) {
        return flowEntry -> flowEntry.appId() == appId.id();
    }

    private static Predicate<FlowEntry> hasGroupId(Optional<GroupId> groupId) {
        return flowEntry -> {
            if (!groupId.isPresent()) {
                return false;
            }
            return flowEntry.groupId().equals(groupId.get());
        };
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindStatisticStore(StatisticStore statisticStore) {
        this.statisticStore = statisticStore;
    }

    protected void unbindStatisticStore(StatisticStore statisticStore) {
        if (this.statisticStore == statisticStore) {
            this.statisticStore = null;
        }
    }

    private static class Statistics {
        private final ImmutableSet<FlowEntry> current;
        private final ImmutableSet<FlowEntry> previous;

        public Statistics(Set<FlowEntry> current, Set<FlowEntry> previous) {
            this.current = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(current)));
            this.previous = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(previous)));
        }

        public ImmutableSet<FlowEntry> current() {
            return this.current;
        }

        public ImmutableSet<FlowEntry> previous() {
            return this.previous;
        }

        public boolean isValid() {
            return !this.current.isEmpty() && !this.previous.isEmpty();
        }

        public int hashCode() {
            return Objects.hash(this.current, this.previous);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Statistics)) {
                return false;
            }
            Statistics other = (Statistics)obj;
            return Objects.equals(this.current, other.current) && Objects.equals(this.previous, other.previous);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("current", this.current).add("previous", this.previous).toString();
        }
    }

    private class InternalFlowRuleListener
    implements FlowRuleListener {
        private InternalFlowRuleListener() {
        }

        public void event(FlowRuleEvent event) {
            FlowRule rule = (FlowRule)event.subject();
            switch ((FlowRuleEvent.Type)event.type()) {
                case RULE_ADDED: 
                case RULE_UPDATED: {
                    if (!(rule instanceof FlowEntry)) break;
                    StatisticManager.this.statisticStore.addOrUpdateStatistic((FlowEntry)rule);
                    break;
                }
                case RULE_ADD_REQUESTED: {
                    StatisticManager.this.statisticStore.prepareForStatistics(rule);
                    break;
                }
                case RULE_REMOVE_REQUESTED: {
                    StatisticManager.this.statisticStore.removeFromStatistics(rule);
                    break;
                }
                case RULE_REMOVED: {
                    break;
                }
                default: {
                    StatisticManager.this.log.warn("Unknown flow rule event {}", (Object)event);
                }
            }
        }
    }
}

