/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.DefaultTypedFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TypedStoredFlowEntry;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.FlowEntryWithLoad;
import org.onosproject.net.statistic.FlowStatisticService;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.PollInterval;
import org.onosproject.net.statistic.StatisticStore;
import org.onosproject.net.statistic.SummaryFlowEntryWithLoad;
import org.onosproject.net.statistic.TypedFlowEntryWithLoad;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.utils.Comparators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class FlowStatisticManager
implements FlowStatisticService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StatisticStore statisticStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Map<ConnectPoint, SummaryFlowEntryWithLoad> loadSummary(Device device) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        TreeMap<ConnectPoint, SummaryFlowEntryWithLoad> summaryLoad = new TreeMap<ConnectPoint, SummaryFlowEntryWithLoad>(Comparators.CONNECT_POINT_COMPARATOR);
        if (device == null) {
            return summaryLoad;
        }
        ArrayList ports = new ArrayList(this.deviceService.getPorts(device.id()));
        for (Port port : ports) {
            ConnectPoint cp = new ConnectPoint((ElementId)device.id(), port.number());
            SummaryFlowEntryWithLoad sfe = this.loadSummaryPortInternal(cp);
            summaryLoad.put(cp, sfe);
        }
        return summaryLoad;
    }

    public SummaryFlowEntryWithLoad loadSummary(Device device, PortNumber pNumber) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        ConnectPoint cp = new ConnectPoint((ElementId)device.id(), pNumber);
        return this.loadSummaryPortInternal(cp);
    }

    public Map<ConnectPoint, List<FlowEntryWithLoad>> loadAllByType(Device device, FlowEntry.FlowLiveType liveType, Instruction.Type instType) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        TreeMap<ConnectPoint, List<FlowEntryWithLoad>> allLoad = new TreeMap<ConnectPoint, List<FlowEntryWithLoad>>(Comparators.CONNECT_POINT_COMPARATOR);
        if (device == null) {
            return allLoad;
        }
        ArrayList ports = new ArrayList(this.deviceService.getPorts(device.id()));
        for (Port port : ports) {
            ConnectPoint cp = new ConnectPoint((ElementId)device.id(), port.number());
            List<FlowEntryWithLoad> fel = this.loadAllPortInternal(cp, liveType, instType);
            allLoad.put(cp, fel);
        }
        return allLoad;
    }

    public List<FlowEntryWithLoad> loadAllByType(Device device, PortNumber pNumber, FlowEntry.FlowLiveType liveType, Instruction.Type instType) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        ConnectPoint cp = new ConnectPoint((ElementId)device.id(), pNumber);
        return this.loadAllPortInternal(cp, liveType, instType);
    }

    public Map<ConnectPoint, List<FlowEntryWithLoad>> loadTopnByType(Device device, FlowEntry.FlowLiveType liveType, Instruction.Type instType, int topn) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        TreeMap<ConnectPoint, List<FlowEntryWithLoad>> allLoad = new TreeMap<ConnectPoint, List<FlowEntryWithLoad>>(Comparators.CONNECT_POINT_COMPARATOR);
        if (device == null) {
            return allLoad;
        }
        ArrayList ports = new ArrayList(this.deviceService.getPorts(device.id()));
        for (Port port : ports) {
            ConnectPoint cp = new ConnectPoint((ElementId)device.id(), port.number());
            List<FlowEntryWithLoad> fel = this.loadTopnPortInternal(cp, liveType, instType, topn);
            allLoad.put(cp, fel);
        }
        return allLoad;
    }

    public List<FlowEntryWithLoad> loadTopnByType(Device device, PortNumber pNumber, FlowEntry.FlowLiveType liveType, Instruction.Type instType, int topn) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        ConnectPoint cp = new ConnectPoint((ElementId)device.id(), pNumber);
        return this.loadTopnPortInternal(cp, liveType, instType, topn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SummaryFlowEntryWithLoad loadSummaryPortInternal(ConnectPoint cp) {
        TypedStatistics typedStatistics;
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        StatisticStore statisticStore = this.statisticStore;
        synchronized (statisticStore) {
            Set currentStats = this.statisticStore.getCurrentStatistic(cp);
            if (currentStats == null) {
                return new SummaryFlowEntryWithLoad(cp, (Load)new DefaultLoad());
            }
            Set previousStats = this.statisticStore.getPreviousStatistic(cp);
            if (previousStats == null) {
                return new SummaryFlowEntryWithLoad(cp, (Load)new DefaultLoad());
            }
            typedStatistics = new TypedStatistics(currentStats, previousStats);
            this.checkLoadValidity(currentStats, previousStats);
        }
        ImmutableSet<FlowEntry> currentSet = typedStatistics.current();
        ImmutableSet<FlowEntry> previousSet = typedStatistics.previous();
        PollInterval pollIntervalInstance = PollInterval.getInstance();
        DefaultLoad totalLoad = new DefaultLoad(this.aggregateBytesSet((Set<FlowEntry>)currentSet), this.aggregateBytesSet((Set<FlowEntry>)previousSet), pollIntervalInstance.getPollInterval());
        Map<FlowRule, FlowEntry> currentMap = typedStatistics.currentImmediate();
        Map<FlowRule, FlowEntry> previousMap = typedStatistics.previousImmediate();
        DefaultLoad immediateLoad = new DefaultLoad(this.aggregateBytesMap(currentMap), this.aggregateBytesMap(previousMap), pollIntervalInstance.getPollInterval());
        currentMap = typedStatistics.currentShort();
        previousMap = typedStatistics.previousShort();
        DefaultLoad shortLoad = new DefaultLoad(this.aggregateBytesMap(currentMap), this.aggregateBytesMap(previousMap), pollIntervalInstance.getPollInterval());
        currentMap = typedStatistics.currentMid();
        previousMap = typedStatistics.previousMid();
        DefaultLoad midLoad = new DefaultLoad(this.aggregateBytesMap(currentMap), this.aggregateBytesMap(previousMap), pollIntervalInstance.getMidPollInterval());
        currentMap = typedStatistics.currentLong();
        previousMap = typedStatistics.previousLong();
        DefaultLoad longLoad = new DefaultLoad(this.aggregateBytesMap(currentMap), this.aggregateBytesMap(previousMap), pollIntervalInstance.getLongPollInterval());
        currentMap = typedStatistics.currentUnknown();
        previousMap = typedStatistics.previousUnknown();
        DefaultLoad unknownLoad = new DefaultLoad(this.aggregateBytesMap(currentMap), this.aggregateBytesMap(previousMap), pollIntervalInstance.getPollInterval());
        return new SummaryFlowEntryWithLoad(cp, (Load)totalLoad, (Load)immediateLoad, (Load)shortLoad, (Load)midLoad, (Load)longLoad, (Load)unknownLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FlowEntryWithLoad> loadAllPortInternal(ConnectPoint cp, FlowEntry.FlowLiveType liveType, Instruction.Type instType) {
        Map<FlowRule, FlowEntry> previousMap;
        Map<FlowRule, FlowEntry> currentMap;
        boolean isAllLiveType;
        TypedStatistics typedStatistics;
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STATISTIC_READ);
        ArrayList<FlowEntryWithLoad> retFel = new ArrayList<FlowEntryWithLoad>();
        StatisticStore statisticStore = this.statisticStore;
        synchronized (statisticStore) {
            Set currentStats = this.statisticStore.getCurrentStatistic(cp);
            if (currentStats == null) {
                return retFel;
            }
            Set previousStats = this.statisticStore.getPreviousStatistic(cp);
            if (previousStats == null) {
                return retFel;
            }
            typedStatistics = new TypedStatistics(currentStats, previousStats);
            this.checkLoadValidity(currentStats, previousStats);
        }
        boolean isAllInstType = instType == null;
        boolean bl = isAllLiveType = liveType == null;
        if (isAllLiveType) {
            currentMap = typedStatistics.currentAll();
            previousMap = typedStatistics.previousAll();
        } else {
            switch (liveType) {
                case IMMEDIATE: {
                    currentMap = typedStatistics.currentImmediate();
                    previousMap = typedStatistics.previousImmediate();
                    break;
                }
                case SHORT: {
                    currentMap = typedStatistics.currentShort();
                    previousMap = typedStatistics.previousShort();
                    break;
                }
                case MID: {
                    currentMap = typedStatistics.currentMid();
                    previousMap = typedStatistics.previousMid();
                    break;
                }
                case LONG: {
                    currentMap = typedStatistics.currentLong();
                    previousMap = typedStatistics.previousLong();
                    break;
                }
                case UNKNOWN: {
                    currentMap = typedStatistics.currentUnknown();
                    previousMap = typedStatistics.previousUnknown();
                    break;
                }
                default: {
                    currentMap = new HashMap<FlowRule, FlowEntry>();
                    previousMap = new HashMap<FlowRule, FlowEntry>();
                }
            }
        }
        return this.typedFlowEntryLoadByInstInternal(cp, currentMap, previousMap, isAllInstType, instType);
    }

    private List<FlowEntryWithLoad> typedFlowEntryLoadByInstInternal(ConnectPoint cp, Map<FlowRule, FlowEntry> currentMap, Map<FlowRule, FlowEntry> previousMap, boolean isAllInstType, Instruction.Type instType) {
        ArrayList<FlowEntryWithLoad> fel = new ArrayList<FlowEntryWithLoad>();
        currentMap.values().forEach(fe -> {
            if (isAllInstType || fe.treatment().allInstructions().stream().filter(i -> i.type() == instType).findAny().isPresent()) {
                long currentBytes = fe.bytes();
                long previousBytes = ((FlowEntry)previousMap.getOrDefault(fe, (FlowEntry)new DefaultFlowEntry((FlowRule)fe))).bytes();
                long liveTypePollInterval = this.getLiveTypePollInterval(fe.liveType());
                DefaultLoad fLoad = new DefaultLoad(currentBytes, previousBytes, liveTypePollInterval);
                fel.add(new FlowEntryWithLoad(cp, fe, (Load)fLoad));
            }
        });
        return fel;
    }

    private List<FlowEntryWithLoad> loadTopnPortInternal(ConnectPoint cp, FlowEntry.FlowLiveType liveType, Instruction.Type instType, int topn) {
        List<FlowEntryWithLoad> fel = this.loadAllPortInternal(cp, liveType, instType);
        List<FlowEntryWithLoad> retFel = fel.stream().sorted(Comparators.FLOWENTRY_WITHLOAD_COMPARATOR).limit(topn).collect(Collectors.toList());
        return retFel;
    }

    private long aggregateBytesSet(Set<FlowEntry> setFE) {
        return setFE.stream().mapToLong(FlowEntry::bytes).sum();
    }

    private long aggregateBytesMap(Map<FlowRule, FlowEntry> mapFE) {
        return mapFE.values().stream().mapToLong(FlowEntry::bytes).sum();
    }

    private long getLiveTypePollInterval(FlowEntry.FlowLiveType liveType) {
        PollInterval pollIntervalInstance = PollInterval.getInstance();
        switch (liveType) {
            case LONG: {
                return pollIntervalInstance.getLongPollInterval();
            }
            case MID: {
                return pollIntervalInstance.getMidPollInterval();
            }
        }
        return pollIntervalInstance.getPollInterval();
    }

    public Map<ConnectPoint, List<TypedFlowEntryWithLoad>> loadAllByType(Device device, TypedStoredFlowEntry.FlowLiveType liveType, Instruction.Type instType) {
        FlowEntry.FlowLiveType type = this.toFlowEntryLiveType(liveType);
        Map<ConnectPoint, List<FlowEntryWithLoad>> loadMap = this.loadAllByType(device, type, instType);
        return this.toFlowEntryWithLoadMap(loadMap);
    }

    public List<TypedFlowEntryWithLoad> loadAllByType(Device device, PortNumber pNumber, TypedStoredFlowEntry.FlowLiveType liveType, Instruction.Type instType) {
        FlowEntry.FlowLiveType type = this.toFlowEntryLiveType(liveType);
        List<FlowEntryWithLoad> loadList = this.loadAllByType(device, pNumber, type, instType);
        return this.toFlowEntryWithLoad(loadList);
    }

    public Map<ConnectPoint, List<TypedFlowEntryWithLoad>> loadTopnByType(Device device, TypedStoredFlowEntry.FlowLiveType liveType, Instruction.Type instType, int topn) {
        FlowEntry.FlowLiveType type = this.toFlowEntryLiveType(liveType);
        Map<ConnectPoint, List<FlowEntryWithLoad>> loadMap = this.loadTopnByType(device, type, instType, topn);
        return this.toFlowEntryWithLoadMap(loadMap);
    }

    public List<TypedFlowEntryWithLoad> loadTopnByType(Device device, PortNumber pNumber, TypedStoredFlowEntry.FlowLiveType liveType, Instruction.Type instType, int topn) {
        FlowEntry.FlowLiveType type = this.toFlowEntryLiveType(liveType);
        List<FlowEntryWithLoad> loadList = this.loadTopnByType(device, pNumber, type, instType, topn);
        return this.toFlowEntryWithLoad(loadList);
    }

    private FlowEntry.FlowLiveType toFlowEntryLiveType(TypedStoredFlowEntry.FlowLiveType liveType) {
        if (liveType == null) {
            return null;
        }
        switch (liveType) {
            case IMMEDIATE_FLOW: {
                return FlowEntry.FlowLiveType.IMMEDIATE;
            }
            case SHORT_FLOW: {
                return FlowEntry.FlowLiveType.SHORT;
            }
            case MID_FLOW: {
                return FlowEntry.FlowLiveType.MID;
            }
            case LONG_FLOW: {
                return FlowEntry.FlowLiveType.LONG;
            }
        }
        return FlowEntry.FlowLiveType.UNKNOWN;
    }

    private TypedStoredFlowEntry.FlowLiveType toTypedStoredFlowEntryLiveType(FlowEntry.FlowLiveType liveType) {
        if (liveType == null) {
            return null;
        }
        switch (liveType) {
            case IMMEDIATE: {
                return TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW;
            }
            case SHORT: {
                return TypedStoredFlowEntry.FlowLiveType.SHORT_FLOW;
            }
            case MID: {
                return TypedStoredFlowEntry.FlowLiveType.MID_FLOW;
            }
            case LONG: {
                return TypedStoredFlowEntry.FlowLiveType.LONG_FLOW;
            }
        }
        return TypedStoredFlowEntry.FlowLiveType.UNKNOWN_FLOW;
    }

    private Map<ConnectPoint, List<TypedFlowEntryWithLoad>> toFlowEntryWithLoadMap(Map<ConnectPoint, List<FlowEntryWithLoad>> loadMap) {
        TreeMap<ConnectPoint, List<TypedFlowEntryWithLoad>> allLoad = new TreeMap<ConnectPoint, List<TypedFlowEntryWithLoad>>(Comparators.CONNECT_POINT_COMPARATOR);
        loadMap.forEach((k, v) -> {
            List<TypedFlowEntryWithLoad> tfelList = this.toFlowEntryWithLoad((List<FlowEntryWithLoad>)v);
            allLoad.put((ConnectPoint)k, tfelList);
        });
        return allLoad;
    }

    private List<TypedFlowEntryWithLoad> toFlowEntryWithLoad(List<FlowEntryWithLoad> loadList) {
        ArrayList<TypedFlowEntryWithLoad> tfelList = new ArrayList<TypedFlowEntryWithLoad>();
        loadList.forEach(fel -> {
            StoredFlowEntry sfe = fel.storedFlowEntry();
            TypedStoredFlowEntry.FlowLiveType liveType = this.toTypedStoredFlowEntryLiveType(sfe.liveType());
            DefaultTypedFlowEntry tfe = new DefaultTypedFlowEntry((FlowEntry)sfe, liveType);
            TypedFlowEntryWithLoad tfel = new TypedFlowEntryWithLoad(fel.connectPoint(), (TypedStoredFlowEntry)tfe, fel.load());
            tfelList.add(tfel);
        });
        return tfelList;
    }

    private void checkLoadValidity(Set<FlowEntry> current, Set<FlowEntry> previous) {
        current.forEach(c -> {
            FlowEntry f = previous.stream().filter(p -> c.equals(p)).findAny().orElse(null);
            if (f != null && c.bytes() < f.bytes()) {
                this.log.debug("FlowStatisticManager:checkLoadValidity():Error: " + c + " :Previous bytes=" + f.bytes() + " is larger than current bytes=" + c.bytes() + " !!!");
            }
        });
    }

    private static Predicate<FlowEntry> hasInstructionType(final Instruction.Type instType) {
        return new Predicate<FlowEntry>(){

            public boolean apply(FlowEntry flowEntry) {
                List allInstructions = flowEntry.treatment().allInstructions();
                return allInstructions.stream().filter(i -> i.type() == instType).findAny().isPresent();
            }
        };
    }

    private static Predicate<FlowEntry> hasLiveType(FlowEntry.FlowLiveType liveType) {
        return flowEntry -> flowEntry.liveType() == liveType;
    }

    protected void bindStatisticStore(StatisticStore statisticStore) {
        this.statisticStore = statisticStore;
    }

    protected void unbindStatisticStore(StatisticStore statisticStore) {
        if (this.statisticStore == statisticStore) {
            this.statisticStore = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private static class TypedStatistics {
        private final ImmutableSet<FlowEntry> current;
        private final ImmutableSet<FlowEntry> previous;
        private final Map<FlowRule, FlowEntry> currentAll = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousAll = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> currentImmediate = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousImmediate = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> currentShort = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousShort = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> currentMid = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousMid = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> currentLong = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousLong = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> currentUnknown = new HashMap<FlowRule, FlowEntry>();
        private final Map<FlowRule, FlowEntry> previousUnknown = new HashMap<FlowRule, FlowEntry>();

        public TypedStatistics(Set<FlowEntry> current, Set<FlowEntry> previous) {
            this.current = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(current)));
            this.previous = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(previous)));
            current.forEach(fe -> {
                switch (fe.liveType()) {
                    case IMMEDIATE: {
                        this.currentImmediate.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case SHORT: {
                        this.currentShort.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case MID: {
                        this.currentMid.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case LONG: {
                        this.currentLong.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    default: {
                        this.currentUnknown.put((FlowRule)fe, (FlowEntry)fe);
                    }
                }
                this.currentAll.put((FlowRule)fe, (FlowEntry)fe);
            });
            previous.forEach(fe -> {
                switch (fe.liveType()) {
                    case IMMEDIATE: {
                        if (this.currentImmediate.containsKey(fe)) {
                            this.previousImmediate.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentShort.containsKey(fe)) {
                            this.previousShort.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentMid.containsKey(fe)) {
                            this.previousMid.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentLong.containsKey(fe)) {
                            this.previousLong.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        this.previousUnknown.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case SHORT: {
                        if (this.currentShort.containsKey(fe)) {
                            this.previousShort.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentMid.containsKey(fe)) {
                            this.previousMid.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentLong.containsKey(fe)) {
                            this.previousLong.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        this.previousUnknown.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case MID: {
                        if (this.currentMid.containsKey(fe)) {
                            this.previousMid.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        if (this.currentLong.containsKey(fe)) {
                            this.previousLong.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        this.previousUnknown.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    case LONG: {
                        if (this.currentLong.containsKey(fe)) {
                            this.previousLong.put((FlowRule)fe, (FlowEntry)fe);
                            break;
                        }
                        this.previousUnknown.put((FlowRule)fe, (FlowEntry)fe);
                        break;
                    }
                    default: {
                        this.previousUnknown.put((FlowRule)fe, (FlowEntry)fe);
                    }
                }
                this.previousAll.put((FlowRule)fe, (FlowEntry)fe);
            });
        }

        public ImmutableSet<FlowEntry> current() {
            return this.current;
        }

        public ImmutableSet<FlowEntry> previous() {
            return this.previous;
        }

        public Map<FlowRule, FlowEntry> currentAll() {
            return this.currentAll;
        }

        public Map<FlowRule, FlowEntry> previousAll() {
            return this.previousAll;
        }

        public Map<FlowRule, FlowEntry> currentImmediate() {
            return this.currentImmediate;
        }

        public Map<FlowRule, FlowEntry> previousImmediate() {
            return this.previousImmediate;
        }

        public Map<FlowRule, FlowEntry> currentShort() {
            return this.currentShort;
        }

        public Map<FlowRule, FlowEntry> previousShort() {
            return this.previousShort;
        }

        public Map<FlowRule, FlowEntry> currentMid() {
            return this.currentMid;
        }

        public Map<FlowRule, FlowEntry> previousMid() {
            return this.previousMid;
        }

        public Map<FlowRule, FlowEntry> currentLong() {
            return this.currentLong;
        }

        public Map<FlowRule, FlowEntry> previousLong() {
            return this.previousLong;
        }

        public Map<FlowRule, FlowEntry> currentUnknown() {
            return this.currentUnknown;
        }

        public Map<FlowRule, FlowEntry> previousUnknown() {
            return this.previousUnknown;
        }

        public boolean isValid() {
            return !this.currentAll.isEmpty() && !this.previousAll.isEmpty();
        }

        public int hashCode() {
            return Objects.hash(this.currentAll, this.previousAll);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypedStatistics)) {
                return false;
            }
            TypedStatistics other = (TypedStatistics)obj;
            return Objects.equals(this.currentAll, other.currentAll) && Objects.equals(this.previousAll, other.previousAll);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("current", this.currentAll).add("previous", this.previousAll).toString();
        }
    }
}

