/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.resource.ResourceAdminService;
import org.onosproject.net.resource.ResourceQueryService;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.impl.ResourceDeviceListener;
import org.onosproject.net.resource.impl.ResourceNetworkConfigListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Beta
public final class ResourceRegistrar {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceAdminService adminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgRegistry;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<ConfigFactory<?, ?>> factories = ImmutableList.of((Object)new ConfigFactory<ConnectPoint, BandwidthCapacity>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, BandwidthCapacity.class, "bandwidthCapacity"){

        public BandwidthCapacity createConfig() {
            return new BandwidthCapacity();
        }
    });
    private DeviceListener deviceListener;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/resource", (String)"registrar", (Logger)this.log));
    private NetworkConfigListener cfgListener;

    @Activate
    public void activate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).registerConfigFactory(arg_0));
        this.cfgListener = new ResourceNetworkConfigListener(this.adminService, (NetworkConfigService)this.cfgRegistry, this.mastershipService, this.executor);
        this.cfgRegistry.addListener((EventListener)this.cfgListener);
        this.deviceListener = new ResourceDeviceListener(this.adminService, (ResourceQueryService)this.resourceService, this.deviceService, this.mastershipService, this.driverService, (NetworkConfigService)this.cfgRegistry, this.executor);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.cfgRegistry.removeListener((EventListener)this.cfgListener);
        this.executor.shutdownNow();
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.cfgRegistry).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    protected void bindAdminService(ResourceAdminService resourceAdminService) {
        this.adminService = resourceAdminService;
    }

    protected void unbindAdminService(ResourceAdminService resourceAdminService) {
        if (this.adminService == resourceAdminService) {
            this.adminService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgRegistry = networkConfigRegistry;
    }

    protected void unbindCfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgRegistry == networkConfigRegistry) {
            this.cfgRegistry = null;
        }
    }
}

